/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.services.data.impl;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.criteria.Expression;
import javax.persistence.metamodel.SingularAttribute;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.VersionAwareResponseService;
import org.cxbox.core.dict.WorkflowDictionaryType;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.service.action.Actions;
import org.cxbox.core.service.rowmeta.FieldMetaBuilder;
import org.cxbox.engine.workflow.services.WorkflowDao;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.model.workflow.entity.WorkflowPostFunction;
import org.cxbox.model.workflow.entity.WorkflowPostFunction_;
import org.cxbox.model.workflow.entity.WorkflowTransitionConditionGroup;
import org.cxbox.model.workflow.entity.WorkflowTransitionConditionGroup_;
import org.cxbox.source.dto.WorkflowPostFunctionDto;
import org.cxbox.source.dto.WorkflowPostFunctionDto_;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;

public abstract class BaseWorkflowPostFunctionServiceImpl<D extends WorkflowPostFunctionDto, E extends WorkflowPostFunction>
extends VersionAwareResponseService<D, E> {
    @Autowired
    private WorkflowDao workflowDao;

    public BaseWorkflowPostFunctionServiceImpl(Class<D> typeOfDTO, Class<E> typeOfEntity, SingularAttribute<? super E, ? extends BaseEntity> parentSpec, Class<? extends FieldMetaBuilder<D>> metaBuilder) {
        super(typeOfDTO, typeOfEntity, parentSpec, metaBuilder);
    }

    protected final ActionResultDTO<D> doUpdateEntity(E entity, D dto, BusinessComponent bc) {
        this.update(entity, dto, bc);
        return new ActionResultDTO((DataResponseDTO)((WorkflowPostFunctionDto)this.entityToDto(bc, (BaseEntity)entity)));
    }

    protected void update(E entity, D dto, BusinessComponent bc) {
        if (dto.isFieldChanged(WorkflowPostFunctionDto_.seq)) {
            entity.setSeq(((WorkflowPostFunctionDto)((Object)dto)).getSeq());
        }
        if (dto.isFieldChanged(WorkflowPostFunctionDto_.actionCd)) {
            entity.setActionCd(WorkflowDictionaryType.WF_TRN_ACT.lookupName(((WorkflowPostFunctionDto)((Object)dto)).getActionCd()));
        }
        if (dto.isFieldChanged(WorkflowPostFunctionDto_.stepTerm)) {
            entity.setStepTerm(((WorkflowPostFunctionDto)((Object)dto)).getStepTerm());
        }
    }

    protected final CreateResult<D> doCreateEntity(E entity, BusinessComponent bc) {
        entity.setConditionGroup((WorkflowTransitionConditionGroup)this.baseDAO.findById(WorkflowTransitionConditionGroup.class, bc.getParentIdAsLong()));
        Optional<WorkflowPostFunction> workflowPostFunction = this.baseDAO.getList(WorkflowPostFunction.class, Specification.where((Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(WorkflowPostFunction_.conditionGroup).get(WorkflowTransitionConditionGroup_.id), (Object)bc.getParentIdAsLong()))).stream().filter(o -> !Objects.isNull(o.getSeq())).max(Comparator.comparing(WorkflowPostFunction::getSeq));
        entity.setSeq(workflowPostFunction.map(workflowPostFunction1 -> workflowPostFunction1.getSeq() + 1L).orElse(1L));
        entity.setActionCd(WorkflowDictionaryType.WF_TRN_ACT.lookupName("SetStepTerm"));
        this.baseDAO.save(entity);
        return new CreateResult((DataResponseDTO)((WorkflowPostFunctionDto)this.entityToDto(bc, (BaseEntity)entity)));
    }

    protected abstract E create(BusinessComponent var1);

    public ActionResultDTO<D> deleteEntity(BusinessComponent bc) {
        this.workflowDao.deletePostFunction((WorkflowPostFunction)this.isExist(bc.getIdAsLong()));
        return new ActionResultDTO();
    }

    public Actions<D> getActions() {
        return Actions.builder().create().available(this::isCreateAvailable).add().save().add().delete().add().build();
    }

    protected boolean isCreateAvailable(BusinessComponent bc) {
        return true;
    }
}

