/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.services.data.impl;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.metamodel.SingularAttribute;
import org.cxbox.WorkflowServiceAssociation;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.core.crudma.bc.BcIdentifier;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.VersionAwareResponseService;
import org.cxbox.core.dict.WorkflowDictionaryType;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.service.action.Actions;
import org.cxbox.core.service.rowmeta.FieldMetaBuilder;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.model.workflow.entity.WorkflowTransitionConditionGroup;
import org.cxbox.model.workflow.entity.WorkflowTransitionValidation;
import org.cxbox.model.workflow.entity.WorkflowTransitionValidation_;
import org.cxbox.source.dto.WorkflowTransitionValidationDto;
import org.cxbox.source.dto.WorkflowTransitionValidationDto_;
import org.springframework.data.jpa.domain.Specification;

public abstract class BaseWorkflowTransitionValidationServiceImpl<D extends WorkflowTransitionValidationDto, E extends WorkflowTransitionValidation>
extends VersionAwareResponseService<D, E> {
    public BaseWorkflowTransitionValidationServiceImpl(Class<D> typeOfDTO, Class<E> typeOfEntity, SingularAttribute<? super E, ? extends BaseEntity> parentSpec, Class<? extends FieldMetaBuilder<D>> metaBuilder) {
        super(typeOfDTO, typeOfEntity, parentSpec, metaBuilder);
    }

    protected Specification<E> getParentSpecification(BusinessComponent bc) {
        if (WorkflowServiceAssociation.wfTransitionValidPreInvoke.isBc((BcIdentifier)bc)) {
            return (Specification & Serializable)(root, cq, cb) -> {
                Long id = bc.getParentIdAsLong();
                if (Objects.nonNull(id)) {
                    return cb.equal((Expression)root.get(WorkflowTransitionValidation_.id), (Object)id);
                }
                return cb.and(new Predicate[0]);
            };
        }
        return super.getParentSpecification(bc);
    }

    protected final ActionResultDTO<D> doUpdateEntity(E entity, D dto, BusinessComponent bc) {
        this.update(entity, dto, bc);
        return new ActionResultDTO((DataResponseDTO)((WorkflowTransitionValidationDto)this.entityToDto(bc, (BaseEntity)entity)));
    }

    protected void update(E entity, D dto, BusinessComponent bc) {
        if (dto.isFieldChanged(WorkflowTransitionValidationDto_.seq)) {
            entity.setSeq(((WorkflowTransitionValidationDto)((Object)dto)).getSeq());
        }
        if (dto.isFieldChanged(WorkflowTransitionValidationDto_.dmn)) {
            entity.setDmn(((WorkflowTransitionValidationDto)((Object)dto)).getDmn());
        }
        if (dto.isFieldChanged(WorkflowTransitionValidationDto_.validCd)) {
            entity.setValidCd(WorkflowDictionaryType.WF_TRN_DATA_VAL.lookupName(((WorkflowTransitionValidationDto)((Object)dto)).getValidCd()));
        }
        if (dto.isFieldChanged(WorkflowTransitionValidationDto_.errorMessage)) {
            entity.setErrorMessage(((WorkflowTransitionValidationDto)((Object)dto)).getErrorMessage());
        }
        if (dto.isFieldChanged(WorkflowTransitionValidationDto_.preInvokeType)) {
            entity.setPreInvokeTypeCd(WorkflowDictionaryType.PRE_INVOKE_TYPE.lookupName(((WorkflowTransitionValidationDto)((Object)dto)).getPreInvokeType()));
        }
        if (dto.isFieldChanged(WorkflowTransitionValidationDto_.preInvokeCond)) {
            entity.setPreInvokeCondCd(WorkflowDictionaryType.PRE_INVOKE_COND.lookupName(((WorkflowTransitionValidationDto)((Object)dto)).getPreInvokeCond()));
        }
        if (dto.isFieldChanged(WorkflowTransitionValidationDto_.preInvokeMessage)) {
            entity.setPreInvokeMessage(((WorkflowTransitionValidationDto)((Object)dto)).getPreInvokeMessage());
        }
    }

    public ActionResultDTO<D> deleteEntity(BusinessComponent bc) {
        this.baseDAO.delete(WorkflowTransitionValidation.class, bc.getIdAsLong());
        return new ActionResultDTO();
    }

    protected final CreateResult<D> doCreateEntity(E entity, BusinessComponent bc) {
        entity.setConditionGroup((WorkflowTransitionConditionGroup)this.baseDAO.findById(WorkflowTransitionConditionGroup.class, bc.getParentIdAsLong()));
        this.baseDAO.save(entity);
        return new CreateResult((DataResponseDTO)((WorkflowTransitionValidationDto)this.entityToDto(bc, (BaseEntity)entity)));
    }

    protected abstract E create(BusinessComponent var1);

    public Actions<D> getActions() {
        return Actions.builder().create().add().save().add().delete().add().build();
    }
}

