/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.services.data.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import lombok.Generated;
import org.cxbox.api.data.ResultPage;
import org.cxbox.core.controller.param.FilterParameter;
import org.cxbox.core.controller.param.FilterParameters;
import org.cxbox.core.controller.param.QueryParameters;
import org.cxbox.core.controller.param.SearchOperation;
import org.cxbox.core.crudma.bc.BcRegistry;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.bc.impl.BcDescription;
import org.cxbox.core.crudma.bc.impl.InnerBcDescription;
import org.cxbox.core.crudma.impl.AbstractResponseService;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.model.ui.entity.View;
import org.cxbox.model.ui.entity.ViewWidgets;
import org.cxbox.model.ui.entity.ViewWidgets_;
import org.cxbox.model.ui.entity.View_;
import org.cxbox.model.ui.entity.Widget_;
import org.cxbox.source.dto.AdminBcDto;
import org.cxbox.source.services.data.TaskChildBcService;
import org.cxbox.source.services.data.WorkflowableTaskService;
import org.cxbox.source.services.meta.TaskChildBcFieldMetaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskChildBcServiceImpl
extends AbstractResponseService<AdminBcDto, BaseEntity>
implements TaskChildBcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskChildBcServiceImpl.class);
    @Autowired
    private List<EntityManager> entityManagers;
    @Autowired
    private BcRegistry bcRegistry;

    public TaskChildBcServiceImpl() {
        super(AdminBcDto.class, BaseEntity.class, null, TaskChildBcFieldMetaBuilder.class);
    }

    public ResultPage<AdminBcDto> getList(BusinessComponent bc) {
        QueryParameters params = bc.getParameters();
        List<BcDescription> saValues = this.getAllBusCompBelowTask();
        Map<String, String> allViewsByBcNames = this.getAllViewsByBcNames(saValues.stream().map(BcDescription::getName).collect(Collectors.toList()));
        List resultList = saValues.stream().map(bcDescription -> {
            AdminBcDto adminBcDto = new AdminBcDto((BcDescription)bcDescription);
            adminBcDto.setAffectedWidgets((String)allViewsByBcNames.get(bcDescription.getName()));
            return adminBcDto;
        }).filter(dto -> this.filterByQueryParams((AdminBcDto)((Object)dto), params.getFilter())).collect(Collectors.toList());
        resultList = resultList.stream().skip((long)params.getPageNumber() * (long)params.getPageSize()).limit((long)params.getPageSize() + 1L).collect(Collectors.toList());
        return this.dtoListToResultPage(resultList, params.getPageSize());
    }

    private Map<String, String> getAllViewsByBcNames(List<String> bcNames) {
        EntityManager entityManager = this.getSupportedEntityManager(ViewWidgets.class.getName());
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createTupleQuery();
        Root viewWidgetsRoot = cq.from(ViewWidgets.class);
        Root viewRoot = cq.from(View.class);
        Join widgetJoin = viewWidgetsRoot.join(ViewWidgets_.widget);
        cq.multiselect(new Selection[]{widgetJoin.get(Widget_.bc), widgetJoin.get(Widget_.title), viewRoot.get(View_.title)});
        cq.where((Expression)cb.and((Expression)cb.or((Predicate[])bcNames.stream().map(bcName -> cb.equal((Expression)widgetJoin.get(Widget_.bc), bcName)).toArray(Predicate[]::new)), (Expression)cb.equal((Expression)viewWidgetsRoot.get(ViewWidgets_.viewName), (Expression)viewRoot.get(View_.name))));
        List resultList = entityManager.createQuery(cq).getResultList();
        HashMap<String, String> result = new HashMap<String, String>();
        for (Tuple tuple : resultList) {
            LinkedList<Object> objects = new LinkedList<Object>(Arrays.asList(tuple.toArray()));
            String bc = (String)objects.get(0);
            String name = objects.get(1) + " -> " + objects.get(2);
            if (result.containsKey(bc)) {
                result.put(bc, (String)result.get(bc) + "\n" + name);
                continue;
            }
            result.put(bc, name);
        }
        return result;
    }

    private List<BcDescription> getAllBusCompBelowTask() {
        List<BcDescription> saValues = this.bcRegistry.select(bc -> bc.getParentName() != null).filter(bc -> this.isWorkflowBc(this.bcRegistry.getBcDescription(bc.getParentName()))).collect(Collectors.toList());
        List addonialSaValues = new ArrayList(saValues);
        do {
            ArrayList finalAddonialSaValues = addonialSaValues;
            addonialSaValues = this.bcRegistry.select(sa -> finalAddonialSaValues.contains(Optional.of(sa).map(BcDescription::getParentName).map(arg_0 -> ((BcRegistry)this.bcRegistry).getBcDescription(arg_0)).orElse(null))).collect(Collectors.toList());
            saValues.addAll(addonialSaValues);
        } while (!addonialSaValues.isEmpty());
        return saValues;
    }

    private boolean filterByQueryParams(AdminBcDto dto, FilterParameters searchParameters) {
        for (FilterParameter parameter : searchParameters) {
            if ("name".equals(parameter.getName())) {
                if (parameter.getOperation() == SearchOperation.EQUALS) {
                    return Objects.equals(parameter.getStringValue(), dto.getName());
                }
                if (parameter.getOperation() == SearchOperation.SPECIFIED) {
                    if (Boolean.TRUE.equals(parameter.getBooleanValue())) {
                        return dto.getName() != null;
                    }
                    return dto.getName() == null;
                }
                if (parameter.getOperation() == SearchOperation.CONTAINS) {
                    if (parameter.getStringValue() == null) {
                        return true;
                    }
                    if (dto.getName() == null) {
                        return false;
                    }
                    return dto.getName().contains(parameter.getStringValue());
                }
                if (parameter.getOperation() == SearchOperation.CONTAINS_ONE_OF) {
                    return parameter.getStringValuesAsList().stream().anyMatch(param -> {
                        if (param == null) {
                            return true;
                        }
                        if (dto.getName() == null) {
                            return false;
                        }
                        return dto.getName().contains((CharSequence)param);
                    });
                }
                if (parameter.getOperation() == SearchOperation.EQUALS_ONE_OF) {
                    return parameter.getStringValuesAsList().stream().anyMatch(param -> Objects.equals(param, dto.getName()));
                }
            }
            if (!"affectedWidgets".equals(parameter.getName())) continue;
            if (parameter.getOperation() == SearchOperation.EQUALS) {
                return Objects.equals(parameter.getStringValue(), dto.getAffectedWidgets());
            }
            if (parameter.getOperation() == SearchOperation.SPECIFIED) {
                if (Boolean.TRUE.equals(parameter.getBooleanValue())) {
                    return dto.getAffectedWidgets() != null;
                }
                return dto.getAffectedWidgets() == null;
            }
            if (parameter.getOperation() != SearchOperation.CONTAINS) continue;
            if (parameter.getStringValue() == null) {
                return true;
            }
            if (dto.getAffectedWidgets() == null) {
                return false;
            }
            return dto.getAffectedWidgets().contains(parameter.getStringValue());
        }
        return true;
    }

    public long count(BusinessComponent bc) {
        return this.bcRegistry.select(this::isWorkflowBc).count();
    }

    private boolean isWorkflowBc(BcDescription bcDescription) {
        return bcDescription instanceof InnerBcDescription && WorkflowableTaskService.class.isAssignableFrom(((InnerBcDescription)bcDescription).getServiceClass());
    }

    protected EntityManager getSupportedEntityManager(String entityClazz) {
        List supportedEntityManagers = this.entityManagers.stream().filter(entityManager -> entityManager.getMetamodel().getEntities().stream().anyMatch(entityType -> com.google.common.base.Objects.equal((Object)entityType.getBindableJavaType().getSimpleName(), (Object)entityClazz) || com.google.common.base.Objects.equal((Object)entityType.getBindableJavaType().getName(), (Object)entityClazz))).collect(Collectors.toList());
        if (supportedEntityManagers.size() == 1) {
            return (EntityManager)supportedEntityManagers.get(0);
        }
        throw new IllegalArgumentException("Can't find unique EntityManager for entity: " + entityClazz);
    }
}

