/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.services.data.impl;

import java.io.Serializable;
import java.util.List;
import javax.persistence.criteria.Predicate;
import org.cxbox.WorkflowServiceAssociation;
import org.cxbox.api.data.dictionary.DictionaryType;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.util.i18n.ErrorMessageSource;
import org.cxbox.core.crudma.bc.BcIdentifier;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.VersionAwareResponseService;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.exception.BusinessException;
import org.cxbox.core.service.action.Actions;
import org.cxbox.core.util.session.SessionService;
import org.cxbox.engine.workflow.services.WorkflowDao;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.model.core.entity.Department;
import org.cxbox.model.workflow.entity.Workflow;
import org.cxbox.model.workflow.entity.WorkflowVersion;
import org.cxbox.source.dto.WorkflowDto;
import org.cxbox.source.dto.WorkflowDto_;
import org.cxbox.source.services.data.WorkflowService;
import org.cxbox.source.services.meta.WorkflowFieldMetaBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class WorkflowServiceImpl
extends VersionAwareResponseService<WorkflowDto, Workflow>
implements WorkflowService {
    @Autowired
    private SessionService sessionService;
    @Autowired
    private WorkflowDao workflowDao;

    public WorkflowServiceImpl() {
        super(WorkflowDto.class, Workflow.class, null, WorkflowFieldMetaBuilder.class);
    }

    protected Specification<Workflow> getParentSpecification(BusinessComponent bc) {
        if (WorkflowServiceAssociation.pfChildWorkflow.isBc((BcIdentifier)bc)) {
            return (Specification & Serializable)(root, cq, cb) -> cb.and(new Predicate[0]);
        }
        return super.getParentSpecification(bc);
    }

    protected ActionResultDTO<WorkflowDto> doUpdateEntity(Workflow entity, WorkflowDto dto, BusinessComponent bc) {
        if (dto.isFieldChanged(WorkflowDto_.deptId)) {
            entity.setDepartment((Department)this.baseDAO.findById(Department.class, dto.getDeptId()));
        }
        if (dto.isFieldChanged(WorkflowDto_.name)) {
            entity.setName(dto.getName());
        }
        if (dto.isFieldChanged(WorkflowDto_.description)) {
            entity.setDescription(dto.getDescription());
        }
        if (dto.isFieldChanged(WorkflowDto_.taskTypeCd)) {
            entity.setTaskTypeCd(DictionaryType.TASK_TYPE.lookupName(dto.getTaskTypeCd()));
        }
        if (dto.isFieldChanged(WorkflowDto_.activeVersion)) {
            entity.setActiveVersion(dto.getActiveVersionId() == null ? null : (WorkflowVersion)this.baseDAO.findById(WorkflowVersion.class, dto.getActiveVersionId()));
        }
        return new ActionResultDTO((DataResponseDTO)((WorkflowDto)this.entityToDto(bc, (BaseEntity)entity)));
    }

    public ActionResultDTO<WorkflowDto> deleteEntity(BusinessComponent bc) {
        this.baseDAO.delete(Workflow.class, bc.getIdAsLong());
        return new ActionResultDTO();
    }

    protected CreateResult<WorkflowDto> doCreateEntity(Workflow entity, BusinessComponent bc) {
        List<LOV> taskTypes = this.workflowDao.getTaskTypesNotInWf();
        if (taskTypes.isEmpty()) {
            throw new BusinessException().addPopup(ErrorMessageSource.errorMessage((String)"error.no_task_type_available"));
        }
        entity.setTaskTypeCd(taskTypes.get(0));
        entity.setDepartment(this.sessionService.getSessionUserDepartment());
        this.baseDAO.save((Object)entity);
        return new CreateResult((DataResponseDTO)((WorkflowDto)this.entityToDto(bc, (BaseEntity)entity)));
    }

    public Actions<WorkflowDto> getActions() {
        return Actions.builder().create().available(this::hasTaskTypesNotInWf).add().save().available(this::isEditable).add().delete().available(this::isEditable).add().build();
    }

    private boolean hasTaskTypesNotInWf(BusinessComponent bc) {
        return this.isEditable(bc) && !this.workflowDao.getTaskTypesNotInWf().isEmpty();
    }

    private boolean isEditable(BusinessComponent bc) {
        return WorkflowServiceAssociation.migrationWf.isNotBc((BcIdentifier)bc);
    }
}

