/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.services.data.impl;

import java.io.Serializable;
import java.util.Optional;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.cxbox.WorkflowServiceAssociation;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.core.crudma.bc.BcIdentifier;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.VersionAwareResponseService;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.service.action.Actions;
import org.cxbox.engine.workflow.dao.WorkflowableTaskDao;
import org.cxbox.engine.workflow.services.WorkflowDao;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.model.core.entity.BaseEntity_;
import org.cxbox.model.workflow.entity.WorkflowStep;
import org.cxbox.model.workflow.entity.WorkflowStep_;
import org.cxbox.model.workflow.entity.WorkflowTask;
import org.cxbox.model.workflow.entity.WorkflowTransition;
import org.cxbox.model.workflow.entity.WorkflowVersion;
import org.cxbox.model.workflow.entity.WorkflowVersion_;
import org.cxbox.model.workflow.entity.WorkflowableTask;
import org.cxbox.source.dto.WorkflowStepDto;
import org.cxbox.source.dto.WorkflowStepDto_;
import org.cxbox.source.services.data.WorkflowStepService;
import org.cxbox.source.services.meta.WorkflowStepFieldMetaBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class WorkflowStepServiceImpl
extends VersionAwareResponseService<WorkflowStepDto, WorkflowStep>
implements WorkflowStepService {
    @Autowired
    private WorkflowableTaskDao<?> workflowableTaskDao;
    @Autowired
    private WorkflowDao workflowDao;

    public WorkflowStepServiceImpl() {
        super(WorkflowStepDto.class, WorkflowStep.class, WorkflowStep_.workflowVersion, WorkflowStepFieldMetaBuilder.class);
    }

    protected Specification<WorkflowStep> getParentSpecification(BusinessComponent bc) {
        if (WorkflowServiceAssociation.wfStepAutoClosed.isBc((BcIdentifier)bc)) {
            return (Specification & Serializable)(root, query, cb) -> cb.and((Expression)cb.equal((Expression)root.get(WorkflowStep_.workflowVersion).get(BaseEntity_.id), (Object)bc.getParentIdAsLong()), (Expression)cb.equal((Expression)root.get(WorkflowStep_.linkedStatusCd), (Object)new LOV("AUTO_CLOSED")));
        }
        if (WorkflowServiceAssociation.wfTaskMigrationNewStep.isBc((BcIdentifier)bc) || WorkflowServiceAssociation.wfTemplateMigrationNewStep.isBc((BcIdentifier)bc)) {
            WorkflowableTask task = this.workflowableTaskDao.getTask(bc.getParentIdAsLong());
            return (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get(WorkflowStep_.workflowVersion).get(WorkflowVersion_.workflow), (Object)this.workflowDao.getWorkflowStep(task.getWorkflowTask()).getWorkflowVersion().getWorkflow()), cb.equal((Expression)root.get(WorkflowStep_.workflowVersion).get(WorkflowVersion_.draft), (Object)Boolean.FALSE), cb.not((Expression)cb.equal((Expression)root.get(WorkflowStep_.workflowVersion), (Object)this.workflowDao.getWorkflowStep(task.getWorkflowTask()).getWorkflowVersion()))});
        }
        return (Specification & Serializable)(root, cq, cb) -> {
            Long parentId = this.getWorkflowVersionId(bc);
            return parentId == null ? cb.and(new Predicate[0]) : cb.equal((Expression)root.get(WorkflowStep_.workflowVersion).get(BaseEntity_.id), (Object)parentId);
        };
    }

    protected Long getWorkflowVersionId(BusinessComponent bc) {
        if (WorkflowServiceAssociation.wfTransitionDestStep.isBc((BcIdentifier)bc)) {
            return Optional.ofNullable((WorkflowTransition)this.baseDAO.findById(WorkflowTransition.class, bc.getParentIdAsLong())).map(WorkflowTransition::getSourceStep).map(WorkflowStep::getWorkflowVersion).map(BaseEntity::getId).orElse(null);
        }
        if (WorkflowServiceAssociation.wfTaskMigrationCurrentStep.isBc((BcIdentifier)bc) || WorkflowServiceAssociation.wfTemplateMigrationCurrentStep.isBc((BcIdentifier)bc)) {
            return Optional.ofNullable(this.workflowableTaskDao.getTask(bc.getParentIdAsLong())).map(WorkflowableTask::getWorkflowTask).map(wfTask -> this.workflowDao.getWorkflowStep((WorkflowTask)wfTask)).map(WorkflowStep::getWorkflowVersion).map(BaseEntity::getId).orElse(null);
        }
        return bc.getParentIdAsLong();
    }

    protected ActionResultDTO<WorkflowStepDto> doUpdateEntity(WorkflowStep entity, WorkflowStepDto dto, BusinessComponent bc) {
        if (dto.isFieldChanged(WorkflowStepDto_.name)) {
            entity.setName(dto.getName());
        }
        if (dto.isFieldChanged(WorkflowStepDto_.linkedStatusValue)) {
            entity.setLinkedStatusCd(dto.getLinkedStatusKey() == null ? null : new LOV(dto.getLinkedStatusKey()));
        }
        if (dto.isFieldChanged(WorkflowStepDto_.overdueTransitionId)) {
            entity.setOverdueTransition(dto.getOverdueTransitionId() == null ? null : (WorkflowTransition)this.baseDAO.findById(WorkflowTransition.class, dto.getOverdueTransitionId()));
        }
        return new ActionResultDTO((DataResponseDTO)((WorkflowStepDto)this.entityToDto(bc, (BaseEntity)entity)));
    }

    public ActionResultDTO<WorkflowStepDto> deleteEntity(BusinessComponent bc) {
        this.baseDAO.delete(WorkflowStep.class, bc.getIdAsLong());
        return new ActionResultDTO();
    }

    protected CreateResult<WorkflowStepDto> doCreateEntity(WorkflowStep entity, BusinessComponent bc) {
        entity.setWorkflowVersion((WorkflowVersion)this.baseDAO.findById(WorkflowVersion.class, bc.getParentIdAsLong()));
        this.baseDAO.save((Object)entity);
        return new CreateResult((DataResponseDTO)((WorkflowStepDto)this.entityToDto(bc, (BaseEntity)entity)));
    }

    public Actions<WorkflowStepDto> getActions() {
        return Actions.builder().create().add().save().add().delete().add().build();
    }
}

