/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.services.data.impl;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.cxbox.WorkflowServiceAssociation;
import org.cxbox.api.data.ResultPage;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.util.i18n.ErrorMessageSource;
import org.cxbox.core.crudma.bc.BcIdentifier;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.AbstractResponseService;
import org.cxbox.core.dao.BaseDAO;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.PostAction;
import org.cxbox.core.exception.BusinessException;
import org.cxbox.core.service.action.Actions;
import org.cxbox.engine.workflow.WorkflowSettings;
import org.cxbox.engine.workflow.dao.WorkflowableTaskDao;
import org.cxbox.engine.workflow.services.WorkflowDao;
import org.cxbox.engine.workflow.services.WorkflowEngine;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.model.workflow.entity.WorkflowStep;
import org.cxbox.model.workflow.entity.WorkflowTask_;
import org.cxbox.model.workflow.entity.WorkflowTransition;
import org.cxbox.model.workflow.entity.WorkflowVersion;
import org.cxbox.model.workflow.entity.WorkflowableTask;
import org.cxbox.model.workflow.entity.WorkflowableTask_;
import org.cxbox.source.dto.WorkflowTaskMigrationDto;
import org.cxbox.source.dto.WorkflowTaskMigrationDto_;
import org.cxbox.source.services.data.WorkflowTaskMigrationService;
import org.cxbox.source.services.meta.WorkflowTaskMigrationFieldMetaBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class WorkflowTaskMigrationServiceImpl
extends AbstractResponseService<WorkflowTaskMigrationDto, WorkflowableTask>
implements WorkflowTaskMigrationService {
    @Autowired
    private WorkflowSettings<?> workflowSettings;
    @Autowired
    private WorkflowableTaskDao<?> workflowableTaskDao;
    @Autowired
    private WorkflowEngine workflowEngine;
    @Autowired
    private WorkflowDao workflowDao;

    public WorkflowTaskMigrationServiceImpl() {
        super(WorkflowTaskMigrationDto.class, WorkflowableTask.class, null, WorkflowTaskMigrationFieldMetaBuilder.class);
    }

    protected String getFetchGraphName(BusinessComponent bc) {
        return null;
    }

    public WorkflowableTask getOneAsEntity(BusinessComponent bc) {
        return this.workflowableTaskDao.getTask(bc.getIdAsLong());
    }

    public ResultPage<WorkflowTaskMigrationDto> getList(BaseDAO dao, BusinessComponent bc) {
        return this.getList(dao, bc, this.workflowSettings.getEntityClass(), this.typeOfDTO);
    }

    public long count(BaseDAO dao, BusinessComponent bc) {
        return this.count(dao, bc, this.workflowSettings.getEntityClass(), this.typeOfDTO);
    }

    protected Specification<WorkflowableTask> getParentSpecification(BusinessComponent bc) {
        WorkflowVersion version = (WorkflowVersion)this.baseDAO.findById(WorkflowVersion.class, bc.getParentIdAsLong());
        return (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get(WorkflowableTask_.workflowTask).get(WorkflowTask_.workflowName), (Object)version.getWorkflow().getName()), cb.equal((Expression)root.get(WorkflowableTask_.workflowTask).get(WorkflowTask_.version), (Object)version.getVersion()), cb.equal((Expression)root.get(WorkflowableTask_.templateFlg), (Object)(WorkflowServiceAssociation.wfTemplateMigration.isBc((BcIdentifier)bc) ? Boolean.TRUE : Boolean.FALSE))});
    }

    public ActionResultDTO<WorkflowTaskMigrationDto> updateEntity(BusinessComponent bc, DataResponseDTO data) {
        WorkflowableTask entity = this.workflowableTaskDao.getTask(bc.getIdAsLong());
        WorkflowTaskMigrationDto dto = (WorkflowTaskMigrationDto)data;
        if (data.hasChangedFields()) {
            if (data.isFieldChanged(WorkflowTaskMigrationDto_.newStepId)) {
                this.workflowEngine.setCustomStep(entity, (WorkflowStep)this.baseDAO.findById(WorkflowStep.class, dto.getNewStepId()));
            }
            if (data.isFieldChanged(WorkflowTaskMigrationDto_.newAutomaticTransitionId)) {
                WorkflowTransition automaticTransition = this.workflowDao.getActiveWorkflowTransitionByName(dto.getNewAutomaticTransitionId());
                if (!Objects.equals(automaticTransition.getSourceStep(), this.workflowDao.getWorkflowStep(entity.getWorkflowTask()))) {
                    throw new BusinessException().addPopup(ErrorMessageSource.errorMessage((String)"error.automatic_transition_mismatch"));
                }
                entity.setAutomaticTransitionName(automaticTransition.getName());
            }
        }
        WorkflowTaskMigrationDto updatedDto = (WorkflowTaskMigrationDto)this.entityToDto(bc, (BaseEntity)entity);
        return new ActionResultDTO((DataResponseDTO)updatedDto).setAction(PostAction.refreshBc((BcIdentifier)bc));
    }

    public Actions<WorkflowTaskMigrationDto> getActions() {
        return Actions.builder().save().add().build();
    }
}

