/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.services.data.impl;

import java.io.Serializable;
import javax.persistence.criteria.Expression;
import org.cxbox.WorkflowServiceAssociation;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.core.crudma.bc.BcIdentifier;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.VersionAwareResponseService;
import org.cxbox.core.dict.WorkflowDictionaries;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.service.action.Actions;
import org.cxbox.engine.workflow.services.WorkflowDao;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.model.core.entity.BaseEntity_;
import org.cxbox.model.workflow.entity.WorkflowTransition;
import org.cxbox.model.workflow.entity.WorkflowTransitionConditionGroup;
import org.cxbox.model.workflow.entity.WorkflowTransitionConditionGroup_;
import org.cxbox.source.dto.WorkflowTransitionConditionGroupDto;
import org.cxbox.source.dto.WorkflowTransitionConditionGroupDto_;
import org.cxbox.source.services.data.WorkflowTransitionConditionGroupService;
import org.cxbox.source.services.meta.WorkflowTransitionConditionGroupFieldMetaBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class WorkflowTransitionConditionGroupServiceImpl
extends VersionAwareResponseService<WorkflowTransitionConditionGroupDto, WorkflowTransitionConditionGroup>
implements WorkflowTransitionConditionGroupService {
    @Autowired
    private WorkflowDao workflowDao;

    protected WorkflowTransitionConditionGroupServiceImpl() {
        super(WorkflowTransitionConditionGroupDto.class, WorkflowTransitionConditionGroup.class, WorkflowTransitionConditionGroup_.transition, WorkflowTransitionConditionGroupFieldMetaBuilder.class);
    }

    protected Specification<WorkflowTransitionConditionGroup> getParentSpecification(BusinessComponent bc) {
        return (Specification & Serializable)(root, cq, cb) -> cb.and((Expression)cb.equal((Expression)root.get(this.parentSpec).get(BaseEntity_.id), (Object)bc.getParentIdAsLong()), (Expression)cb.equal((Expression)root.get(WorkflowTransitionConditionGroup_.condGroupCd), (Object)this.getCondGroupCd(bc)));
    }

    private LOV getCondGroupCd(BusinessComponent bc) {
        if (WorkflowServiceAssociation.wfTransitionCondGroup.isBc((BcIdentifier)bc)) {
            return WorkflowDictionaries.ConditionGroupType.CONDITION;
        }
        if (WorkflowServiceAssociation.wfPostFuncGroup.isBc((BcIdentifier)bc)) {
            return WorkflowDictionaries.ConditionGroupType.POST_FUNCTION;
        }
        if (WorkflowServiceAssociation.wfTranCondGroupValid.isBc((BcIdentifier)bc)) {
            return WorkflowDictionaries.ConditionGroupType.VALIDATION;
        }
        return null;
    }

    protected CreateResult<WorkflowTransitionConditionGroupDto> doCreateEntity(WorkflowTransitionConditionGroup entity, BusinessComponent bc) {
        entity.setCondGroupCd(this.getCondGroupCd(bc));
        entity.setTransition((WorkflowTransition)this.baseDAO.findById(WorkflowTransition.class, bc.getParentIdAsLong()));
        this.baseDAO.save((Object)entity);
        this.workflowDao.createDefaultPostFunctions(entity);
        return new CreateResult((DataResponseDTO)((WorkflowTransitionConditionGroupDto)this.entityToDto(bc, (BaseEntity)entity)));
    }

    protected ActionResultDTO<WorkflowTransitionConditionGroupDto> doUpdateEntity(WorkflowTransitionConditionGroup entity, WorkflowTransitionConditionGroupDto dto, BusinessComponent bc) {
        if (dto.isFieldChanged(WorkflowTransitionConditionGroupDto_.seq)) {
            entity.setSeq(dto.getSeq());
        }
        if (dto.isFieldChanged(WorkflowTransitionConditionGroupDto_.name)) {
            entity.setName(dto.getName());
        }
        return new ActionResultDTO((DataResponseDTO)((WorkflowTransitionConditionGroupDto)this.entityToDto(bc, (BaseEntity)entity)));
    }

    public ActionResultDTO<WorkflowTransitionConditionGroupDto> deleteEntity(BusinessComponent bc) {
        this.workflowDao.deleteTransitionConditionGroup((WorkflowTransitionConditionGroup)this.isExist(bc.getIdAsLong()));
        return new ActionResultDTO();
    }

    public Actions<WorkflowTransitionConditionGroupDto> getActions() {
        return Actions.builder().create().add().save().add().delete().add().build();
    }
}

