/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.services.data.impl;

import java.io.Serializable;
import java.util.Optional;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.cxbox.WorkflowServiceAssociation;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.util.i18n.ErrorMessageSource;
import org.cxbox.core.crudma.bc.BcIdentifier;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.VersionAwareResponseService;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.exception.BusinessException;
import org.cxbox.core.service.action.Actions;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.model.core.entity.BaseEntity_;
import org.cxbox.model.workflow.entity.WorkflowStep;
import org.cxbox.model.workflow.entity.WorkflowTransition;
import org.cxbox.model.workflow.entity.WorkflowTransitionGroup;
import org.cxbox.model.workflow.entity.WorkflowTransitionGroup_;
import org.cxbox.source.dto.WorkflowTransitionGroupDto;
import org.cxbox.source.dto.WorkflowTransitionGroupDto_;
import org.cxbox.source.services.data.WorkflowTransitionGroupService;
import org.cxbox.source.services.meta.WorkflowTransitionGroupMetaBuilder;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class WorkflowTransitionGroupServiceImpl
extends VersionAwareResponseService<WorkflowTransitionGroupDto, WorkflowTransitionGroup>
implements WorkflowTransitionGroupService {
    protected WorkflowTransitionGroupServiceImpl() {
        super(WorkflowTransitionGroupDto.class, WorkflowTransitionGroup.class, WorkflowTransitionGroup_.workflowStep, WorkflowTransitionGroupMetaBuilder.class);
    }

    protected Specification<WorkflowTransitionGroup> getParentSpecification(BusinessComponent bc) {
        return (Specification & Serializable)(root, cq, cb) -> {
            Long parentId = this.getParentId(bc);
            return parentId == null ? cb.and(new Predicate[0]) : cb.equal((Expression)root.get(WorkflowTransitionGroup_.workflowStep).get(BaseEntity_.id), (Object)parentId);
        };
    }

    private Long getParentId(BusinessComponent bc) {
        if (WorkflowServiceAssociation.wfTransitionGroupPopup.isBc((BcIdentifier)bc)) {
            return Optional.ofNullable((WorkflowTransition)this.baseDAO.findById(WorkflowTransition.class, bc.getParentIdAsLong())).map(WorkflowTransition::getSourceStep).map(BaseEntity::getId).orElse(null);
        }
        return bc.getParentIdAsLong();
    }

    protected CreateResult<WorkflowTransitionGroupDto> doCreateEntity(WorkflowTransitionGroup entity, BusinessComponent bc) {
        WorkflowStep workflowStep = Optional.ofNullable((WorkflowStep)this.baseDAO.findById(WorkflowStep.class, bc.getParentIdAsLong())).orElseThrow(() -> new BusinessException().addPopup(ErrorMessageSource.errorMessage((String)"error.no_parent_workflow_step")));
        entity.setWorkflowStep(workflowStep);
        this.baseDAO.save((Object)entity);
        return new CreateResult((DataResponseDTO)((WorkflowTransitionGroupDto)this.entityToDto(bc, (BaseEntity)entity)));
    }

    protected ActionResultDTO<WorkflowTransitionGroupDto> doUpdateEntity(WorkflowTransitionGroup entity, WorkflowTransitionGroupDto dto, BusinessComponent bc) {
        if (dto.isFieldChanged(WorkflowTransitionGroupDto_.maxShowButtonsInGroup)) {
            entity.setMaxShowButtonsInGroup(dto.getMaxShowButtonsInGroup().intValue());
        }
        if (dto.isFieldChanged(WorkflowTransitionGroupDto_.nameButtonYet)) {
            entity.setNameButtonYet(dto.getNameButtonYet());
        }
        if (dto.isFieldChanged(WorkflowTransitionGroupDto_.description)) {
            entity.setDescription(dto.getDescription());
        }
        return new ActionResultDTO((DataResponseDTO)((WorkflowTransitionGroupDto)this.entityToDto(bc, (BaseEntity)entity)));
    }

    public Actions<WorkflowTransitionGroupDto> getActions() {
        return Actions.builder().create().add().save().add().delete().add().build();
    }
}

