/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.services.data.impl;

import java.io.Serializable;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.cxbox.WorkflowServiceAssociation;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.core.crudma.bc.BcIdentifier;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.VersionAwareResponseService;
import org.cxbox.core.dict.WorkflowDictionaries;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.service.action.Actions;
import org.cxbox.engine.workflow.dao.WorkflowableTaskDao;
import org.cxbox.engine.workflow.services.WorkflowDao;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.model.core.entity.BaseEntity_;
import org.cxbox.model.workflow.entity.WorkflowPostFunction;
import org.cxbox.model.workflow.entity.WorkflowPostFunction_;
import org.cxbox.model.workflow.entity.WorkflowStep;
import org.cxbox.model.workflow.entity.WorkflowStep_;
import org.cxbox.model.workflow.entity.WorkflowTransition;
import org.cxbox.model.workflow.entity.WorkflowTransitionConditionGroup;
import org.cxbox.model.workflow.entity.WorkflowTransitionConditionGroup_;
import org.cxbox.model.workflow.entity.WorkflowTransitionGroup;
import org.cxbox.model.workflow.entity.WorkflowTransition_;
import org.cxbox.model.workflow.entity.WorkflowVersion_;
import org.cxbox.model.workflow.entity.WorkflowableTask;
import org.cxbox.source.dto.WorkflowTransitionDto;
import org.cxbox.source.dto.WorkflowTransitionDto_;
import org.cxbox.source.services.data.WorkflowTransitionService;
import org.cxbox.source.services.meta.WorkflowTransitionFieldMetaBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class WorkflowTransitionServiceImpl
extends VersionAwareResponseService<WorkflowTransitionDto, WorkflowTransition>
implements WorkflowTransitionService {
    @Autowired
    private WorkflowableTaskDao<?> workflowableTaskDao;
    @Autowired
    private WorkflowDao workflowDao;

    public WorkflowTransitionServiceImpl() {
        super(WorkflowTransitionDto.class, WorkflowTransition.class, WorkflowTransition_.sourceStep, WorkflowTransitionFieldMetaBuilder.class);
    }

    protected Specification<WorkflowTransition> getParentSpecification(BusinessComponent bc) {
        if (WorkflowServiceAssociation.wfTemplateMigrationNewAutomaticTransition.isBc((BcIdentifier)bc)) {
            WorkflowableTask task = this.workflowableTaskDao.getTask(bc.getParentIdAsLong());
            return (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get(WorkflowTransition_.sourceStep).get(WorkflowStep_.workflowVersion).get(WorkflowVersion_.workflow), (Object)this.workflowDao.getWorkflowStep(task.getWorkflowTask()).getWorkflowVersion().getWorkflow()), cb.equal((Expression)root.get(WorkflowTransition_.sourceStep).get(WorkflowStep_.workflowVersion).get(WorkflowVersion_.draft), (Object)Boolean.FALSE), cb.not((Expression)cb.equal((Expression)root.get(WorkflowTransition_.sourceStep).get(WorkflowStep_.workflowVersion), (Object)this.workflowDao.getWorkflowStep(task.getWorkflowTask()).getWorkflowVersion()))});
        }
        if (WorkflowServiceAssociation.wfTemplateMigrationCurrentAutomaticTransition.isBc((BcIdentifier)bc)) {
            WorkflowableTask task = this.workflowableTaskDao.getTask(bc.getParentIdAsLong());
            return (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(WorkflowTransition_.sourceStep).get(WorkflowStep_.workflowVersion), (Object)this.workflowDao.getWorkflowStep(task.getWorkflowTask()).getWorkflowVersion());
        }
        return (Specification & Serializable)(root, cq, cb) -> {
            Long parentId = this.getSourceStepId(bc);
            return parentId == null ? cb.and(new Predicate[0]) : cb.equal((Expression)root.get(WorkflowTransition_.sourceStep).get(BaseEntity_.id), (Object)parentId);
        };
    }

    private Long getSourceStepId(BusinessComponent bc) {
        return bc.getParentIdAsLong();
    }

    protected ActionResultDTO<WorkflowTransitionDto> doUpdateEntity(WorkflowTransition entity, WorkflowTransitionDto dto, BusinessComponent bc) {
        if (dto.isFieldChanged(WorkflowTransitionDto_.name)) {
            entity.setName(dto.getName());
        }
        if (dto.isFieldChanged(WorkflowTransitionDto_.workflowDestStepId)) {
            entity.setDestinationStep(dto.getWorkflowDestStepId() == null ? null : (WorkflowStep)this.baseDAO.findById(WorkflowStep.class, dto.getWorkflowDestStepId()));
        }
        if (dto.isFieldChanged(WorkflowTransitionDto_.workflowTransitionGroupId)) {
            entity.setWorkflowTransitionGroup(dto.getWorkflowTransitionGroupId() == null ? null : (WorkflowTransitionGroup)this.baseDAO.findById(WorkflowTransitionGroup.class, dto.getWorkflowTransitionGroupId()));
        }
        if (dto.isFieldChanged(WorkflowTransitionDto_.checkRequiredFields)) {
            entity.setCheckRequiredFields(dto.getCheckRequiredFields());
        }
        if (dto.isFieldChanged(WorkflowTransitionDto_.backgroundExecution)) {
            entity.setBackgroundExecution(dto.getBackgroundExecution());
        }
        return new ActionResultDTO((DataResponseDTO)((WorkflowTransitionDto)this.entityToDto(bc, (BaseEntity)entity)));
    }

    public ActionResultDTO<WorkflowTransitionDto> deleteEntity(BusinessComponent bc) {
        WorkflowTransitionConditionGroup workflowGroup = (WorkflowTransitionConditionGroup)this.baseDAO.getSingleResultOrNull(WorkflowTransitionConditionGroup.class, (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(WorkflowTransitionConditionGroup_.transition).get(WorkflowTransition_.id), (Object)bc.getIdAsLong()));
        if (workflowGroup != null) {
            WorkflowPostFunction workflowPostFunction = (WorkflowPostFunction)this.baseDAO.getSingleResultOrNull(WorkflowPostFunction.class, (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(WorkflowPostFunction_.conditionGroup), (Object)workflowGroup));
            if (workflowPostFunction != null) {
                this.baseDAO.delete(WorkflowPostFunction.class, workflowPostFunction.getId());
            }
            this.baseDAO.delete(WorkflowTransitionConditionGroup.class, workflowGroup.getId());
        }
        this.baseDAO.delete(WorkflowTransition.class, bc.getIdAsLong());
        return new ActionResultDTO();
    }

    protected CreateResult<WorkflowTransitionDto> doCreateEntity(WorkflowTransition entity, BusinessComponent bc) {
        entity.setSourceStep((WorkflowStep)this.baseDAO.findById(WorkflowStep.class, bc.getParentIdAsLong()));
        entity.setDestinationStep((WorkflowStep)this.baseDAO.findById(WorkflowStep.class, bc.getParentIdAsLong()));
        entity.setCheckRequiredFields(Boolean.TRUE);
        this.baseDAO.save((Object)entity);
        WorkflowTransitionConditionGroup defaultPostFunctionGroup = this.createDefaultConditionGroup(entity);
        this.workflowDao.createDefaultPostFunctions(defaultPostFunctionGroup);
        return new CreateResult((DataResponseDTO)((WorkflowTransitionDto)this.entityToDto(bc, (BaseEntity)entity)));
    }

    private WorkflowTransitionConditionGroup createDefaultConditionGroup(WorkflowTransition transition) {
        WorkflowTransitionConditionGroup postFunctionGroup = new WorkflowTransitionConditionGroup();
        postFunctionGroup.setTransition(transition);
        postFunctionGroup.setSeq(Long.valueOf(1L));
        postFunctionGroup.setName("\u0413\u0440\u0443\u043f\u043f\u0430 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
        postFunctionGroup.setCondGroupCd(WorkflowDictionaries.ConditionGroupType.POST_FUNCTION);
        this.baseDAO.save((Object)postFunctionGroup);
        return postFunctionGroup;
    }

    public Actions<WorkflowTransitionDto> getActions() {
        return Actions.builder().create().add().save().add().delete().add().build();
    }
}

