/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.services.data.impl;

import java.io.Serializable;
import javax.persistence.criteria.Expression;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.WorkflowServiceAssociation;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.file.entity.CxboxFile;
import org.cxbox.core.crudma.bc.BcIdentifier;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.VersionAwareResponseService;
import org.cxbox.core.dto.DrillDownType;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.ActionType;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.dto.rowmeta.PostAction;
import org.cxbox.core.service.action.ActionAvailableChecker;
import org.cxbox.core.service.action.Actions;
import org.cxbox.core.service.action.DrillDownTypeSpecifier;
import org.cxbox.core.service.action.ResponseServiceAction;
import org.cxbox.engine.workflow.services.WorkflowDao;
import org.cxbox.engine.workflow.services.WorkflowExporter;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.model.core.entity.BaseEntity_;
import org.cxbox.model.workflow.entity.Workflow;
import org.cxbox.model.workflow.entity.WorkflowStep;
import org.cxbox.model.workflow.entity.WorkflowVersion;
import org.cxbox.model.workflow.entity.WorkflowVersion_;
import org.cxbox.source.dto.WorkflowVersionDto;
import org.cxbox.source.dto.WorkflowVersionDto_;
import org.cxbox.source.services.action.WorkflowVersionMigrateTaskAction;
import org.cxbox.source.services.data.WorkflowVersionService;
import org.cxbox.source.services.meta.WorkflowVersionFieldMetaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class WorkflowVersionServiceImpl
extends VersionAwareResponseService<WorkflowVersionDto, WorkflowVersion>
implements WorkflowVersionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowVersionServiceImpl.class);
    @Autowired(required=false)
    private WorkflowExporter workflowExporter;
    @Autowired
    private WorkflowDao workflowDao;
    @Autowired
    private WorkflowVersionMigrateTaskAction workflowVersionMigrateTaskAction;

    public WorkflowVersionServiceImpl() {
        super(WorkflowVersionDto.class, WorkflowVersion.class, WorkflowVersion_.workflow, WorkflowVersionFieldMetaBuilder.class);
    }

    protected Specification<WorkflowVersion> getParentSpecification(BusinessComponent bc) {
        if (WorkflowServiceAssociation.wfActiveVersion.isBc((BcIdentifier)bc)) {
            return (Specification & Serializable)(root, query, cb) -> cb.and((Expression)cb.equal((Expression)root.get(WorkflowVersion_.workflow).get(BaseEntity_.id), (Object)bc.getParentIdAsLong()), (Expression)cb.equal((Expression)root.get(WorkflowVersion_.draft), (Object)Boolean.FALSE));
        }
        return super.getParentSpecification(bc);
    }

    protected ActionResultDTO<WorkflowVersionDto> doUpdateEntity(WorkflowVersion entity, WorkflowVersionDto dto, BusinessComponent bc) {
        if (dto.isFieldChanged(WorkflowVersionDto_.description)) {
            entity.setDescription(dto.getDescription());
        }
        if (dto.isFieldChanged(WorkflowVersionDto_.firstStepId)) {
            entity.setFirstStep(dto.getFirstStepId() == null ? null : (WorkflowStep)this.baseDAO.findById(WorkflowStep.class, dto.getFirstStepId()));
        }
        if (dto.isFieldChanged(WorkflowVersionDto_.autoClosedStepId)) {
            entity.setAutoClosedStep(dto.getAutoClosedStepId() == null ? null : (WorkflowStep)this.baseDAO.findById(WorkflowStep.class, dto.getAutoClosedStepId()));
        }
        return new ActionResultDTO((DataResponseDTO)((WorkflowVersionDto)this.entityToDto(bc, (BaseEntity)entity)));
    }

    protected CreateResult<WorkflowVersionDto> doCreateEntity(WorkflowVersion entity, BusinessComponent bc) {
        Workflow workflow = (Workflow)this.baseDAO.findById(Workflow.class, bc.getParentIdAsLong());
        entity.setWorkflow(workflow);
        entity.setVersion(Double.valueOf(this.workflowDao.getNextVersion(workflow, false).doubleValue()));
        entity.setDraft(Boolean.TRUE.booleanValue());
        this.baseDAO.save((Object)entity);
        return new CreateResult((DataResponseDTO)((WorkflowVersionDto)this.entityToDto(bc, (BaseEntity)entity)));
    }

    public Actions<WorkflowVersionDto> getActions() {
        return Actions.builder().create().available(this::isEditable).add().save().available(this::isEditable).add().action(ActionType.COPY).available(ActionAvailableChecker.and((ActionAvailableChecker[])new ActionAvailableChecker[]{bc -> this.workflowExporter != null, this::versionIsNotDraft})).invoker(this::copyNewVersion).add().action("export", "\u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u0434\u043b\u044f \u043f\u043e\u0441\u0442\u0430\u0432\u043a\u0438").available(ActionAvailableChecker.and((ActionAvailableChecker[])new ActionAvailableChecker[]{bc -> this.workflowExporter != null, this::versionIsNotDraft})).invoker(this::exportNewVersion).add().action("activate-version", "\u0417\u0430\u0444\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u0435\u0440\u0441\u0438\u044e").available(this::versionIsDraft).invoker(this::activateVersion).add().add("migrate-all-tasks", (ResponseServiceAction)this.workflowVersionMigrateTaskAction).build();
    }

    private ActionResultDTO<WorkflowVersionDto> exportNewVersion(BusinessComponent bc, WorkflowVersionDto data) {
        CxboxFile fileEntity = this.workflowExporter.exportNewVersion(bc, data);
        return new ActionResultDTO((DataResponseDTO)data).setAction(PostAction.downloadFile((String)String.valueOf(fileEntity.getId())));
    }

    private ActionResultDTO<WorkflowVersionDto> copyNewVersion(BusinessComponent bc, WorkflowVersionDto data) {
        WorkflowVersion newVersion = this.workflowExporter.copyNewVersion(bc, data);
        return new ActionResultDTO((DataResponseDTO)data).setAction(PostAction.drillDown((DrillDownTypeSpecifier)DrillDownType.INNER, (String)StringUtils.joinWith((String)"/", (Object[])new Object[]{"screen/admin/view/wftransitionfunc", WorkflowServiceAssociation.wf, newVersion.getWorkflow().getId(), WorkflowServiceAssociation.wfVersion, newVersion.getId()})));
    }

    private boolean isEditable(BusinessComponent bc) {
        return WorkflowServiceAssociation.migrationWfVersion.isNotBc((BcIdentifier)bc);
    }

    private boolean versionIsNotDraft(BusinessComponent bc) {
        return this.isEditable(bc) && bc.getId() != null && !((WorkflowVersion)this.baseDAO.findById(WorkflowVersion.class, bc.getIdAsLong())).isDraft();
    }

    private boolean versionIsDraft(BusinessComponent bc) {
        return this.isEditable(bc) && bc.getId() != null && ((WorkflowVersion)this.baseDAO.findById(WorkflowVersion.class, bc.getIdAsLong())).isDraft();
    }

    private ActionResultDTO<WorkflowVersionDto> activateVersion(BusinessComponent bc, WorkflowVersionDto data) {
        WorkflowVersion version = (WorkflowVersion)this.baseDAO.findById(WorkflowVersion.class, bc.getIdAsLong());
        version.setDraft(false);
        return new ActionResultDTO((DataResponseDTO)((WorkflowVersionDto)this.entityToDto(bc, (BaseEntity)version)));
    }
}

