/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.testing.tests;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import lombok.Generated;
import org.cxbox.api.data.ResultPage;
import org.cxbox.core.dao.BaseDAO;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.testing.conf.PersistenceTestContext;
import org.cxbox.testing.tests.AbstractCxboxTest;
import org.hibernate.Hibernate;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.query.internal.AbstractProducedQuery;
import org.hibernate.type.Type;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextHierarchy;

@ContextHierarchy(value={@ContextConfiguration(name="root", classes={PersistenceTestContext.class})})
public abstract class BaseDAOAwareTest
extends AbstractCxboxTest {
    protected final AtomicLong idSequence = new AtomicLong(Long.MIN_VALUE);
    protected List<EntityManager> entityManagers;
    @Autowired
    protected BaseDAO baseDAO;
    protected Map<EntityKey, Object> entities = new HashMap<EntityKey, Object>();
    protected Map<QueryKey, List<?>> queries = new HashMap();

    @AfterEach
    protected void tearDown() {
        this.queries.clear();
        this.entities.clear();
    }

    @AfterAll
    protected void tearDownALL() {
        Mockito.reset((Object[])new BaseDAO[]{this.baseDAO});
    }

    @BeforeAll
    protected void tearUpALL() {
        Mockito.when((Object)this.baseDAO.save(ArgumentMatchers.any(BaseEntity.class))).thenAnswer(invocation -> {
            BaseEntity entity = (BaseEntity)invocation.getArgument(0);
            if (entity.getId() == null) {
                Long id = this.idSequence.incrementAndGet();
                entity.setId(id);
            }
            this.entities.put(this.createEntityKey(entity), entity);
            return entity.getId();
        });
        Mockito.when((Object)this.baseDAO.findById((Class)ArgumentMatchers.any(Class.class), Long.valueOf(ArgumentMatchers.anyLong()))).thenAnswer(invocation -> {
            Class cls = (Class)invocation.getArgument(0);
            Long id = (Long)invocation.getArgument(1);
            return this.entities.get(this.createEntityKey(cls, id));
        });
        Mockito.when((Object)this.baseDAO.getEntityGraph((Class)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)this.baseDAO.getList((Class)ArgumentMatchers.any(), (Class)ArgumentMatchers.any(), (Specification)ArgumentMatchers.any(Specification.class), (org.cxbox.core.controller.param.QueryParameters)ArgumentMatchers.any(), (EntityGraph)ArgumentMatchers.any())).thenAnswer(invocation -> {
            Class cls = (Class)invocation.getArgument(0);
            Specification specification = (Specification)invocation.getArgument(2);
            return ResultPage.of(this.queries.getOrDefault(this.createQueryKey(cls, specification), Collections.emptyList()), (boolean)false);
        });
    }

    protected <T> void addResultSet(Class<T> cls, Specification<T> spec, List<T> data) {
        this.queries.put(this.createQueryKey(cls, spec), data);
    }

    private <T> QueryKey createQueryKey(Class<T> cls, Specification<T> spec) {
        AbstractProducedQuery<T> query = this.compile(cls, spec);
        QueryParameters queryParameters = query.getQueryParameters();
        return new QueryKey(query.getQueryString(), queryParameters.getPositionalParameterTypes(), queryParameters.getPositionalParameterValues(), queryParameters.getNamedParameters());
    }

    private <T> AbstractProducedQuery<T> compile(Class<T> cls, Specification<T> spec) {
        CriteriaBuilder cb = this.entityManagers.get(0).getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(cls);
        Root root = cq.from(cls);
        cq.where((Expression)spec.toPredicate(root, cq, cb));
        return (AbstractProducedQuery)this.entityManagers.get(0).createQuery(cq).unwrap(AbstractProducedQuery.class);
    }

    private EntityKey createEntityKey(Class<?> cls, Serializable id) {
        return new EntityKey(id, this.getModelName(cls));
    }

    private EntityKey createEntityKey(BaseEntity entity) {
        return this.createEntityKey(Hibernate.unproxy((Object)entity).getClass(), entity.getId());
    }

    private String getModelName(Class<?> cls) {
        return this.entityManagers.get(0).getMetamodel().entity(cls).getName();
    }

    private static class QueryKey {
        private final String query;
        private final Type[] positionalParameterTypes;
        private final Object[] positionalParameterValues;
        private final Map<String, TypedValue> namedParameters;

        @ConstructorProperties(value={"query", "positionalParameterTypes", "positionalParameterValues", "namedParameters"})
        @Generated
        public QueryKey(String query, Type[] positionalParameterTypes, Object[] positionalParameterValues, Map<String, TypedValue> namedParameters) {
            this.query = query;
            this.positionalParameterTypes = positionalParameterTypes;
            this.positionalParameterValues = positionalParameterValues;
            this.namedParameters = namedParameters;
        }

        @Generated
        public String getQuery() {
            return this.query;
        }

        @Generated
        public Type[] getPositionalParameterTypes() {
            return this.positionalParameterTypes;
        }

        @Generated
        public Object[] getPositionalParameterValues() {
            return this.positionalParameterValues;
        }

        @Generated
        public Map<String, TypedValue> getNamedParameters() {
            return this.namedParameters;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryKey)) {
                return false;
            }
            QueryKey other = (QueryKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$query = this.getQuery();
            String other$query = other.getQuery();
            if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getPositionalParameterTypes(), other.getPositionalParameterTypes())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getPositionalParameterValues(), other.getPositionalParameterValues())) {
                return false;
            }
            Map<String, TypedValue> this$namedParameters = this.getNamedParameters();
            Map<String, TypedValue> other$namedParameters = other.getNamedParameters();
            return !(this$namedParameters == null ? other$namedParameters != null : !((Object)this$namedParameters).equals(other$namedParameters));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof QueryKey;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $query = this.getQuery();
            result = result * 59 + ($query == null ? 43 : $query.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getPositionalParameterTypes());
            result = result * 59 + Arrays.deepHashCode(this.getPositionalParameterValues());
            Map<String, TypedValue> $namedParameters = this.getNamedParameters();
            result = result * 59 + ($namedParameters == null ? 43 : ((Object)$namedParameters).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BaseDAOAwareTest.QueryKey(query=" + this.getQuery() + ", positionalParameterTypes=" + Arrays.deepToString(this.getPositionalParameterTypes()) + ", positionalParameterValues=" + Arrays.deepToString(this.getPositionalParameterValues()) + ", namedParameters=" + this.getNamedParameters() + ")";
        }
    }

    private static class EntityKey {
        private final Serializable id;
        private final String name;

        @ConstructorProperties(value={"id", "name"})
        @Generated
        public EntityKey(Serializable id, String name) {
            this.id = id;
            this.name = name;
        }

        @Generated
        public Serializable getId() {
            return this.id;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EntityKey)) {
                return false;
            }
            EntityKey other = (EntityKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Serializable this$id = this.getId();
            Serializable other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EntityKey;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Serializable $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BaseDAOAwareTest.EntityKey(id=" + this.getId() + ", name=" + this.getName() + ")";
        }
    }
}

