/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.ssdp;

import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.cybergarage.upnp.ControlPoint;
import org.cybergarage.upnp.ssdp.HTTPUSocket;
import org.cybergarage.upnp.ssdp.SSDPPacket;
import org.cybergarage.upnp.ssdp.SSDPSearchRequest;
import org.cybergarage.upnp.ssdp.SSDPSearchResponse;

public class SSDPSearchResponseSocket
extends HTTPUSocket
implements Runnable {
    private ControlPoint controlPoint = null;
    private Thread deviceSearchResponseThread = null;

    public SSDPSearchResponseSocket() {
        this.setControlPoint(null);
    }

    public SSDPSearchResponseSocket(String bindAddr, int port) throws BindException {
        super(bindAddr, port);
        this.setControlPoint(null);
    }

    public void setControlPoint(ControlPoint ctrlp) {
        this.controlPoint = ctrlp;
    }

    public ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    @Override
    public void run() {
        Thread thisThread = Thread.currentThread();
        ControlPoint ctrlPoint = this.getControlPoint();
        while (this.deviceSearchResponseThread == thisThread) {
            Thread.yield();
            SSDPPacket packet = this.receive();
            if (packet == null) break;
            if (ctrlPoint == null) continue;
            ctrlPoint.searchResponseReceived(packet);
        }
    }

    public void start() {
        StringBuffer name = new StringBuffer("Cyber.SSDPSearchResponseSocket/");
        DatagramSocket s = this.getDatagramSocket();
        InetAddress localAddr = s.getLocalAddress();
        if (localAddr != null) {
            name.append(s.getLocalAddress()).append(':');
            name.append(s.getLocalPort());
        }
        this.deviceSearchResponseThread = new Thread((Runnable)this, name.toString());
        this.deviceSearchResponseThread.start();
    }

    public void stop() {
        this.deviceSearchResponseThread = null;
    }

    public boolean post(String addr, int port, SSDPSearchResponse res) {
        return this.post(addr, port, res.getHeader());
    }

    public boolean post(String addr, int port, SSDPSearchRequest req) {
        return this.post(addr, port, req.toString());
    }
}

