/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.cybergarage.http.HTTPRequest;
import org.cybergarage.http.HTTPRequestListener;
import org.cybergarage.http.HTTPServerThread;
import org.cybergarage.util.Debug;
import org.cybergarage.util.ListenerList;

public class HTTPServer
implements Runnable {
    public static final String NAME = "CyberHTTP";
    public static final String VERSION = "1.0";
    public static final int DEFAULT_PORT = 80;
    public static final int DEFAULT_TIMEOUT = 80000;
    private ServerSocket serverSock = null;
    private InetAddress bindAddr = null;
    private int bindPort = 0;
    protected int timeout = 80000;
    private ListenerList httpRequestListenerList = new ListenerList();
    private Thread httpServerThread = null;

    public static String getName() {
        String osName = System.getProperty("os.name");
        String osVer = System.getProperty("os.version");
        return osName + "/" + osVer + " CyberHTTP/1.0";
    }

    public ServerSocket getServerSock() {
        return this.serverSock;
    }

    public String getBindAddress() {
        if (this.bindAddr == null) {
            return "";
        }
        return this.bindAddr.toString();
    }

    public int getBindPort() {
        return this.bindPort;
    }

    public synchronized int getTimeout() {
        return this.timeout;
    }

    public synchronized void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean open(InetAddress addr, int port) {
        if (this.serverSock != null) {
            return true;
        }
        try {
            this.serverSock = new ServerSocket(this.bindPort, 0, this.bindAddr);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean open(String addr, int port) {
        if (this.serverSock != null) {
            return true;
        }
        try {
            this.bindAddr = InetAddress.getByName(addr);
            this.bindPort = port;
            this.serverSock = new ServerSocket(this.bindPort, 0, this.bindAddr);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean close() {
        if (this.serverSock == null) {
            return true;
        }
        try {
            this.serverSock.close();
            this.serverSock = null;
            this.bindAddr = null;
            this.bindPort = 0;
        }
        catch (Exception e) {
            Debug.warning(e);
            return false;
        }
        return true;
    }

    public Socket accept() {
        if (this.serverSock == null) {
            return null;
        }
        try {
            Socket sock = this.serverSock.accept();
            sock.setSoTimeout(this.getTimeout());
            return sock;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isOpened() {
        return this.serverSock != null;
    }

    public void addRequestListener(HTTPRequestListener listener) {
        this.httpRequestListenerList.add(listener);
    }

    public void removeRequestListener(HTTPRequestListener listener) {
        this.httpRequestListenerList.remove(listener);
    }

    public void performRequestListener(HTTPRequest httpReq) {
        int listenerSize = this.httpRequestListenerList.size();
        for (int n = 0; n < listenerSize; ++n) {
            HTTPRequestListener listener = (HTTPRequestListener)this.httpRequestListenerList.get(n);
            listener.httpRequestRecieved(httpReq);
        }
    }

    @Override
    public void run() {
        if (!this.isOpened()) {
            return;
        }
        Thread thisThread = Thread.currentThread();
        while (this.httpServerThread == thisThread) {
            Socket sock;
            block4: {
                Thread.yield();
                try {
                    Debug.message("accept ...");
                    sock = this.accept();
                    if (sock == null) break block4;
                    Debug.message("sock = " + sock.getRemoteSocketAddress());
                }
                catch (Exception e) {
                    Debug.warning(e);
                    break;
                }
            }
            HTTPServerThread httpServThread = new HTTPServerThread(this, sock);
            httpServThread.start();
            Debug.message("httpServThread ...");
        }
    }

    public boolean start() {
        StringBuffer name = new StringBuffer("Cyber.HTTPServer/");
        name.append(this.serverSock.getLocalSocketAddress());
        this.httpServerThread = new Thread((Runnable)this, name.toString());
        this.httpServerThread.start();
        return true;
    }

    public boolean stop() {
        this.httpServerThread = null;
        return true;
    }
}

