/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.cybergarage.xml.Node;

public class Icon {
    public static final String ELEM_NAME = "icon";
    private Node iconNode;
    private static final String MIME_TYPE = "mimetype";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String DEPTH = "depth";
    private static final String URL = "url";
    private Object userData = null;
    private byte[] bytes = null;

    public Node getIconNode() {
        return this.iconNode;
    }

    public Icon(Node node) {
        this.iconNode = node;
    }

    public Icon() {
        this(new Node(ELEM_NAME));
    }

    public static boolean isIconNode(Node node) {
        return ELEM_NAME.equals(node.getName());
    }

    public void setMimeType(String value) {
        this.getIconNode().setNode(MIME_TYPE, value);
    }

    public String getMimeType() {
        return this.getIconNode().getNodeValue(MIME_TYPE);
    }

    public boolean hasMimeType() {
        String iconMimeType = this.getMimeType();
        if (iconMimeType == null) {
            return false;
        }
        return 0 < iconMimeType.length();
    }

    public void setWidth(String value) {
        this.getIconNode().setNode(WIDTH, value);
    }

    public void setWidth(int value) {
        try {
            this.setWidth(Integer.toString(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getWidth() {
        try {
            return Integer.parseInt(this.getIconNode().getNodeValue(WIDTH));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setHeight(String value) {
        this.getIconNode().setNode(HEIGHT, value);
    }

    public void setHeight(int value) {
        try {
            this.setHeight(Integer.toString(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getHeight() {
        try {
            return Integer.parseInt(this.getIconNode().getNodeValue(HEIGHT));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setDepth(String value) {
        this.getIconNode().setNode(DEPTH, value);
    }

    public void setDepth(int value) {
        try {
            this.setDepth(Integer.toString(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getDepth() {
        try {
            return Integer.parseInt(this.getIconNode().getNodeValue(DEPTH));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setURL(String value) {
        this.getIconNode().setNode(URL, value);
    }

    public String getURL() {
        return this.getIconNode().getNodeValue(URL);
    }

    public boolean hasURL() {
        String iconURL = this.getURL();
        if (iconURL == null) {
            return false;
        }
        return 0 < iconURL.length();
    }

    public boolean isURL(String url) {
        if (url == null) {
            return false;
        }
        String iconURL = this.getURL();
        if (iconURL == null) {
            return false;
        }
        return iconURL.equals(url);
    }

    public void setUserData(Object data) {
        this.userData = data;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setBytes(byte[] data) {
        this.bytes = data;
    }

    public boolean hasBytes() {
        if (this.bytes != null) {
            return true;
        }
        if (this.hasURL()) {
            return Icon.class.getResourceAsStream(this.getURL()) != null;
        }
        return false;
    }

    public byte[] getBytes() {
        if (this.bytes == null && this.hasURL()) {
            try {
                InputStream inStream = Icon.class.getResourceAsStream(this.getURL());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int data = -1;
                while ((data = inStream.read()) != -1) {
                    baos.write(data);
                }
                inStream.close();
                this.bytes = baos.toByteArray();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.bytes;
    }
}

