/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.cybergarage.http.HTTPRequest;
import org.cybergarage.http.HTTPResponse;
import org.cybergarage.xml.Node;
import org.cybergarage.xml.ParserException;

public abstract class Parser {
    public abstract Node parse(InputStream var1) throws ParserException;

    public Node parse(URL locationURL) throws ParserException {
        String host = locationURL.getHost();
        int port = locationURL.getPort();
        if (port == -1) {
            port = 80;
        }
        String uri = locationURL.getPath();
        try {
            HttpURLConnection urlCon = (HttpURLConnection)locationURL.openConnection();
            urlCon.setRequestMethod("GET");
            urlCon.setRequestProperty("Content-Length", "0");
            if (host != null) {
                urlCon.setRequestProperty("HOST", host);
            }
            InputStream urlIn = urlCon.getInputStream();
            Node rootElem = this.parse(urlIn);
            urlIn.close();
            urlCon.disconnect();
            return rootElem;
        }
        catch (Exception urlCon) {
            HTTPRequest httpReq = new HTTPRequest();
            httpReq.setMethod("GET");
            httpReq.setURI(uri);
            HTTPResponse httpRes = httpReq.post(host, port);
            if (!httpRes.isSuccessful()) {
                throw new ParserException("HTTP comunication failed: no answer from peer.Unable to retrive resoure -> " + locationURL.toString());
            }
            String content = new String(httpRes.getContent());
            ByteArrayInputStream strBuf = new ByteArrayInputStream(content.getBytes());
            return this.parse(strBuf);
        }
    }

    public Node parse(File descriptionFile) throws ParserException {
        try {
            FileInputStream fileIn = new FileInputStream(descriptionFile);
            Node root = this.parse(fileIn);
            ((InputStream)fileIn).close();
            return root;
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    public Node parse(String descr) throws ParserException {
        try {
            ByteArrayInputStream decrIn = new ByteArrayInputStream(descr.getBytes());
            Node root = this.parse(decrIn);
            return root;
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }
}

