/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.sql;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import org.cybergarage.util.Debug;

public abstract class Database {
    private Connection con;
    private Statement stmt;
    private ResultSet rs;

    public Database() {
        this.setConnection(null);
        this.setStatement(null);
        this.setResultSet(null);
    }

    protected void setConnection(Connection c) {
        this.con = c;
    }

    private Connection getConnection() {
        return this.con;
    }

    private void setStatement(Statement s) {
        this.stmt = s;
    }

    private Statement getStatement() {
        return this.stmt;
    }

    private void setResultSet(ResultSet r) {
        this.rs = r;
    }

    private ResultSet getResultSet() {
        return this.rs;
    }

    public abstract boolean open(String var1, String var2, String var3, String var4);

    public void close() {
        Connection con = this.getConnection();
        if (con != null) {
            try {
                con.close();
                this.setConnection(null);
            }
            catch (Exception e) {
                Debug.warning((Exception)e);
            }
        }
    }

    public boolean query(String sql) {
        try {
            Connection con;
            ResultSet rs;
            Statement stmt = this.getStatement();
            if (stmt != null) {
                stmt.close();
            }
            if ((rs = this.getResultSet()) != null) {
                rs.close();
            }
            if ((con = this.getConnection()) == null) {
                return false;
            }
            stmt = con.createStatement();
            this.setStatement(stmt);
            rs = stmt.executeQuery(sql);
            this.setResultSet(rs);
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
            return false;
        }
        return true;
    }

    public boolean fetch() {
        boolean fetchRet = false;
        try {
            ResultSet rs = this.getResultSet();
            if (rs == null) {
                return false;
            }
            fetchRet = rs.next();
            if (!fetchRet) {
                Statement stmt = this.getStatement();
                if (stmt != null) {
                    stmt.close();
                    this.setStatement(null);
                }
                rs.close();
                this.setResultSet(null);
            }
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
        }
        return fetchRet;
    }

    public String getString(String name) {
        try {
            ResultSet rs = this.getResultSet();
            if (rs == null) {
                return "";
            }
            byte[] str_b = rs.getBytes(name);
            return new String(str_b);
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
            return "";
        }
    }

    public String getString(int n) {
        try {
            ResultSet rs = this.getResultSet();
            if (rs == null) {
                return "";
            }
            byte[] str_b = rs.getBytes(n);
            return new String(str_b);
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
            return "";
        }
    }

    public int getInteger(String name) {
        try {
            ResultSet rs = this.getResultSet();
            if (rs == null) {
                return 0;
            }
            return rs.getInt(name);
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
            return 0;
        }
    }

    public int getInteger(int n) {
        try {
            ResultSet rs = this.getResultSet();
            if (rs == null) {
                return 0;
            }
            return rs.getInt(n);
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
            return 0;
        }
    }

    public long getLong(String name) {
        try {
            ResultSet rs = this.getResultSet();
            if (rs == null) {
                return 0L;
            }
            return rs.getLong(name);
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
            return 0L;
        }
    }

    public long getLong(int n) {
        try {
            ResultSet rs = this.getResultSet();
            if (rs == null) {
                return 0L;
            }
            return rs.getLong(n);
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
            return 0L;
        }
    }

    public long getTimestamp(String name) {
        try {
            ResultSet rs = this.getResultSet();
            if (rs == null) {
                return 0L;
            }
            Timestamp ts = rs.getTimestamp(name);
            return ts.getTime();
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
            return 0L;
        }
    }

    public long getTimestamp(int n) {
        try {
            ResultSet rs = this.getResultSet();
            if (rs == null) {
                return 0L;
            }
            Timestamp ts = rs.getTimestamp(n);
            return ts.getTime();
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
            return 0L;
        }
    }

    public long getDate(String name) {
        try {
            ResultSet rs = this.getResultSet();
            if (rs == null) {
                return 0L;
            }
            Date ts = rs.getDate(name);
            return ts.getTime();
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
            return 0L;
        }
    }

    public long getDate(int n) {
        try {
            ResultSet rs = this.getResultSet();
            if (rs == null) {
                return 0L;
            }
            Date ts = rs.getDate(n);
            return ts.getTime();
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
            return 0L;
        }
    }

    public int update(String sql) {
        int numOfUpdated = 0;
        try {
            Connection con;
            ResultSet rs;
            Statement stmt = this.getStatement();
            if (stmt != null) {
                stmt.close();
                this.setStatement(null);
            }
            if ((rs = this.getResultSet()) != null) {
                rs.close();
                this.setResultSet(null);
            }
            if ((con = this.getConnection()) == null) {
                return 0;
            }
            stmt = con.createStatement();
            numOfUpdated = stmt.executeUpdate(sql);
            stmt.close();
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
        }
        return numOfUpdated;
    }
}

