/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.std.av.controller;

import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.Argument;
import org.cybergarage.upnp.ControlPoint;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.DeviceList;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.UPnP;
import org.cybergarage.upnp.std.av.player.action.BrowseAction;
import org.cybergarage.upnp.std.av.player.action.BrowseResult;
import org.cybergarage.upnp.std.av.server.object.ContentNode;
import org.cybergarage.upnp.std.av.server.object.container.ContainerNode;
import org.cybergarage.upnp.std.av.server.object.container.RootNode;
import org.cybergarage.upnp.std.av.server.object.item.ItemNode;
import org.cybergarage.upnp.std.av.server.object.item.ResourceNode;
import org.cybergarage.util.Debug;
import org.cybergarage.xml.Node;
import org.cybergarage.xml.Parser;
import org.cybergarage.xml.ParserException;

public class MediaController
extends ControlPoint {
    private DeviceList getDeviceList(String deviceType) {
        DeviceList devList = new DeviceList();
        DeviceList allDevList = this.getDeviceList();
        int allDevCnt = allDevList.size();
        for (int n = 0; n < allDevCnt; ++n) {
            Device dev = allDevList.getDevice(n);
            if (!dev.isDeviceType(deviceType)) continue;
            devList.add((Object)dev);
        }
        return devList;
    }

    public DeviceList getServerDeviceList() {
        return this.getDeviceList("urn:schemas-upnp-org:device:MediaServer:1");
    }

    public DeviceList getRendererDeviceList() {
        return this.getDeviceList("urn:schemas-upnp-org:device:MediaRenderer:1");
    }

    public Device getServerDevice(String name) {
        Device foundDev = this.getDevice(name);
        if (foundDev.isDeviceType("urn:schemas-upnp-org:device:MediaServer:1")) {
            return foundDev;
        }
        return null;
    }

    public Device getRendererDevice(String name) {
        Device foundDev = this.getDevice(name);
        if (foundDev.isDeviceType("urn:schemas-upnp-org:device:MediaRenderer:1")) {
            return foundDev;
        }
        return null;
    }

    public Node browse(Device dev, String objectID, String browseFlag, String filter, int startIndex, int requestedCount, String sortCaiteria) {
        Argument resultArg;
        System.out.println("browse " + objectID + ", " + browseFlag + ", " + startIndex + ", " + requestedCount);
        if (dev == null) {
            return null;
        }
        Service conDir = dev.getService("urn:schemas-upnp-org:service:ContentDirectory:1");
        if (conDir == null) {
            return null;
        }
        Action action = conDir.getAction("Browse");
        if (action == null) {
            return null;
        }
        BrowseAction browseAction = new BrowseAction(action);
        browseAction.setObjectID(objectID);
        browseAction.setBrowseFlag(browseFlag);
        browseAction.setStartingIndex(startIndex);
        browseAction.setRequestedCount(requestedCount);
        browseAction.setFilter(filter);
        browseAction.setSortCriteria(sortCaiteria);
        if (!browseAction.postControlAction()) {
            return null;
        }
        if (requestedCount == 0) {
            int numberReturned = browseAction.getNumberReturned();
            int totalMatches = browseAction.getTotalMatches();
            if (numberReturned == 0) {
                if (0 < totalMatches) {
                    browseAction.setRequestedCount(totalMatches);
                    if (!browseAction.postControlAction()) {
                        return null;
                    }
                } else {
                    browseAction.setRequestedCount(9999);
                    if (!browseAction.postControlAction()) {
                        return null;
                    }
                }
            }
        }
        if ((resultArg = browseAction.getArgument("Result")) == null) {
            return null;
        }
        String resultStr = resultArg.getValue();
        if (resultStr == null) {
            return null;
        }
        Node node = null;
        Parser xmlParser = UPnP.getXMLParser();
        try {
            node = xmlParser.parse(resultStr);
        }
        catch (ParserException pe) {
            Debug.warning((Exception)((Object)pe));
            return null;
        }
        return node;
    }

    public Node browseMetaData(Device dev, String objectId, String filter, int startIndex, int requestedCount, String sortCaiteria) {
        return this.browse(dev, objectId, "BrowseMetadata", filter, startIndex, requestedCount, sortCaiteria);
    }

    public Node browseMetaData(Device dev, String objectId) {
        return this.browseMetaData(dev, objectId, "*", 0, 0, "");
    }

    public Node browseDirectChildren(Device dev, String objectID, String filter, int startIndex, int requestedCount, String sortCaiteria) {
        return this.browse(dev, objectID, "BrowseDirectChildren", filter, startIndex, requestedCount, sortCaiteria);
    }

    public Node browseDirectChildren(Device dev, String objectId) {
        return this.browseDirectChildren(dev, objectId, "*", 0, 0, "");
    }

    public ContainerNode browse(Device dev) {
        return this.browse(dev, "0");
    }

    public ContainerNode browse(Device dev, String objectId) {
        return this.browse(dev, objectId, false);
    }

    public ContainerNode browse(Device dev, String objectId, boolean hasBrowseChildNodes, boolean hasRootNodeMetadata) {
        Node rootNode;
        RootNode contentRootNode = new RootNode();
        if (hasRootNodeMetadata && (rootNode = this.browseMetaData(dev, objectId, "*", 0, 0, "")) != null) {
            contentRootNode.set(rootNode);
        }
        this.browse(contentRootNode, dev, objectId, hasRootNodeMetadata);
        return contentRootNode;
    }

    public ContainerNode browse(Device dev, String objectId, boolean hasBrowseChildNodes) {
        return this.browse(dev, objectId, hasBrowseChildNodes, false);
    }

    private int browse(ContainerNode parentNode, Device dev, String objectID, boolean hasBrowseChildNodes) {
        if (objectID == null) {
            return 0;
        }
        Node resultNode = this.browseDirectChildren(dev, objectID, "*", 0, 0, "");
        if (resultNode == null) {
            return 0;
        }
        BrowseResult browseResult = new BrowseResult(resultNode);
        int nResultNode = 0;
        int nContents = browseResult.getNContentNodes();
        for (int n = 0; n < nContents; ++n) {
            ContainerNode containerNode;
            int childCnt;
            Node xmlNode = browseResult.getContentNode(n);
            ContentNode contentNode = null;
            if (ContainerNode.isContainerNode(xmlNode)) {
                contentNode = new ContainerNode();
            } else if (ItemNode.isItemNode(xmlNode)) {
                contentNode = new ItemNode();
            }
            if (contentNode == null) continue;
            contentNode.set(xmlNode);
            parentNode.addContentNode(contentNode);
            contentNode.setParentID(objectID);
            ++nResultNode;
            if (!hasBrowseChildNodes || !contentNode.isContainerNode() || 0 >= (childCnt = (containerNode = (ContainerNode)contentNode).getChildCount())) continue;
            String objid = containerNode.getID();
            this.browse(containerNode, dev, objid, true);
        }
        return nResultNode;
    }

    public ContentNode getContentDirectory(Device dev) {
        return this.getContentDirectory(dev, "0");
    }

    public ContentNode getContentDirectory(Device dev, String objectId) {
        return this.browse(dev, objectId, true);
    }

    public void printContentNode(ContentNode node, int indentLevel) {
        int n;
        for (n = 0; n < indentLevel; ++n) {
            System.out.print("  ");
        }
        System.out.print(node.getTitle());
        if (node.isItemNode()) {
            ItemNode itemNode = (ItemNode)node;
            String res = itemNode.getResource();
            String protocolInfo = itemNode.getProtocolInfo();
            System.out.print(" (" + res + ")");
        }
        System.out.println("");
        if (node.isContainerNode()) {
            ContainerNode containerNode = (ContainerNode)node;
            int nContentNodes = containerNode.getNContentNodes();
            for (n = 0; n < nContentNodes; ++n) {
                ContentNode cnode = containerNode.getContentNode(n);
                this.printContentNode(cnode, indentLevel + 1);
            }
        }
    }

    public void printContentDirectory(Device dev) {
        ContentNode node = this.getContentDirectory(dev);
        if (node == null) {
            return;
        }
        this.printContentNode(node, 1);
    }

    public void printMediaServers() {
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        int mediaServerCnt = 0;
        for (int n = 0; n < devCnt; ++n) {
            Device dev = devList.getDevice(n);
            if (!dev.isDeviceType("urn:schemas-upnp-org:device:MediaServer:1")) continue;
            System.out.println("[" + n + "] " + dev.getFriendlyName() + ", " + dev.getLeaseTime() + ", " + dev.getElapsedTime());
            this.printContentDirectory(dev);
            ++mediaServerCnt;
        }
        if (mediaServerCnt == 0) {
            System.out.println("MediaServer is not found");
        }
    }

    public boolean setAVTransportURI(Device dev, ItemNode itemNode) {
        if (dev == null) {
            return false;
        }
        ResourceNode resNode = itemNode.getFirstResource();
        if (resNode == null) {
            return false;
        }
        String resURL = resNode.getURL();
        if (resURL == null || resURL.length() <= 0) {
            return false;
        }
        Service avTransService = dev.getService("urn:schemas-upnp-org:service:AVTransport:1");
        if (avTransService == null) {
            return false;
        }
        Action action = avTransService.getAction("SetAVTransportURI");
        if (action == null) {
            return false;
        }
        action.setArgumentValue("InstanceID", "0");
        action.setArgumentValue("CurrentURI", resURL);
        action.setArgumentValue("CurrentURIMetaData", "");
        return action.postControlAction();
    }

    public boolean play(Device dev) {
        if (dev == null) {
            return false;
        }
        Service avTransService = dev.getService("urn:schemas-upnp-org:service:AVTransport:1");
        if (avTransService == null) {
            return false;
        }
        Action action = avTransService.getAction("Play");
        if (action == null) {
            return false;
        }
        action.setArgumentValue("InstanceID", "0");
        action.setArgumentValue("Speed", "1");
        return action.postControlAction();
    }

    public boolean stop(Device dev) {
        if (dev == null) {
            return false;
        }
        Service avTransService = dev.getService("urn:schemas-upnp-org:service:AVTransport:1");
        if (avTransService == null) {
            return false;
        }
        Action action = avTransService.getAction("Stop");
        if (action == null) {
            return false;
        }
        action.setArgumentValue("InstanceID", "0");
        return action.postControlAction();
    }

    public boolean play(Device dev, ItemNode itemNode) {
        this.stop(dev);
        if (!this.setAVTransportURI(dev, itemNode)) {
            return false;
        }
        return this.play(dev);
    }

    public static void main(String[] args) {
        MediaController mplayer = new MediaController();
        mplayer.start();
        while (true) {
            mplayer.printMediaServers();
            try {
                Thread.sleep(20000L);
            }
            catch (Exception exception) {
            }
        }
    }
}

