/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.std.av.controller.server;

import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.Argument;

public class BrowseAction {
    public static final String OBJECT_ID = "ObjectID";
    public static final String BROWSE_FLAG = "BrowseFlag";
    public static final String FILTER = "Filter";
    public static final String STARTING_INDEX = "StartingIndex";
    public static final String REQUESTED_COUNT = "RequestedCount";
    public static final String SORT_CRITERIA = "SortCriteria";
    public static final String BROWSE_METADATA = "BrowseMetadata";
    public static final String BROWSE_DIRECT_CHILDREN = "BrowseDirectChildren";
    public static final String RESULT = "Result";
    public static final String NUMBER_RETURNED = "NumberReturned";
    public static final String TOTAL_MACHES = "TotalMatches";
    public static final String UPDATE_ID = "UpdateID";
    private Action action;

    public BrowseAction(Action action) {
        this.action = action;
    }

    public Argument getArgument(String name) {
        return this.action.getArgument(name);
    }

    public String getBrowseFlag() {
        return this.action.getArgumentValue(BROWSE_FLAG);
    }

    public boolean isMetadata() {
        return BROWSE_METADATA.equals(this.getBrowseFlag());
    }

    public boolean isDirectChildren() {
        return BROWSE_DIRECT_CHILDREN.equals(this.getBrowseFlag());
    }

    public String getObjectID() {
        return this.action.getArgumentValue(OBJECT_ID);
    }

    public int getStartingIndex() {
        return this.action.getArgumentIntegerValue(STARTING_INDEX);
    }

    public int getRequestedCount() {
        return this.action.getArgumentIntegerValue(REQUESTED_COUNT);
    }

    public String getSortCriteria() {
        return this.action.getArgumentValue(SORT_CRITERIA);
    }

    public String getFilter() {
        return this.action.getArgumentValue(FILTER);
    }

    public void setBrowseFlag(String browseFlag) {
        this.action.setArgumentValue(BROWSE_FLAG, browseFlag);
    }

    public void setObjectID(String objectID) {
        this.action.setArgumentValue(OBJECT_ID, objectID);
    }

    public void setStartingIndex(int idx) {
        this.action.setArgumentValue(STARTING_INDEX, idx);
    }

    public void setRequestedCount(int count) {
        this.action.setArgumentValue(REQUESTED_COUNT, count);
    }

    public void setFilter(String filter) {
        this.action.setArgumentValue(FILTER, filter);
    }

    public void setSortCriteria(String sortCaiteria) {
        this.action.setArgumentValue(SORT_CRITERIA, sortCaiteria);
    }

    public void setResult(String value) {
        this.action.setArgumentValue(RESULT, value);
    }

    public void setNumberReturned(int value) {
        this.action.setArgumentValue(NUMBER_RETURNED, value);
    }

    public void setTotalMaches(int value) {
        this.action.setArgumentValue(TOTAL_MACHES, value);
    }

    public void setUpdateID(int value) {
        this.action.setArgumentValue(UPDATE_ID, value);
    }

    public boolean postControlAction() {
        return this.action.postControlAction();
    }
}

