/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.std.av.renderer;

import java.io.File;
import org.cybergarage.http.HTTPRequest;
import org.cybergarage.net.HostInterface;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.UPnP;
import org.cybergarage.upnp.control.ActionListener;
import org.cybergarage.upnp.device.InvalidDescriptionException;
import org.cybergarage.upnp.std.av.renderer.AVTransport;
import org.cybergarage.upnp.std.av.renderer.ConnectionManager;
import org.cybergarage.upnp.std.av.renderer.RenderingControl;
import org.cybergarage.util.Debug;

public class MediaRenderer
extends Device {
    public static final String DEVICE_TYPE = "urn:schemas-upnp-org:device:MediaRenderer:1";
    public static final int DEFAULT_HTTP_PORT = 39520;
    public static final String DESCRIPTION = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<root xmlns=\"urn:schemas-upnp-org:device-1-0\">\n   <specVersion>\n      <major>1</major>\n      <minor>0</minor>\n   </specVersion>\n   <device>\n      <deviceType>urn:schemas-upnp-org:device:MediaRender:1</deviceType>\n      <friendlyName>Cyber Garage Media Render</friendlyName>\n      <manufacturer>Cyber Garage</manufacturer>\n      <manufacturerURL>http://www.cybergarage.org</manufacturerURL>\n      <modelDescription>Provides content through UPnP ContentDirectory service</modelDescription>\n      <modelName>Cyber Garage Media Render</modelName>\n      <modelNumber>1.0</modelNumber>\n      <modelURL>http://www.cybergarage.org</modelURL>\n      <UDN>uuid:362d9414-31a0-48b6-b684-2b4bd38391d0</UDN>\n      <serviceList>\n         <service>\n            <serviceType>urn:schemas-upnp-org:service:RenderingControl:1</serviceType>\n            <serviceId>RenderingControl</serviceId>\n         </service>\n         <service>\n            <serviceType>urn:schemas-upnp-org:service:ConnectionManager:1</serviceType>\n            <serviceId>ConnectionManager</serviceId>\n         </service>\n         <service>\n            <serviceType>urn:schemas-upnp-org:service:AVTransport:1</serviceType>\n            <serviceId>AVTransport</serviceId>\n         </service>\n      </serviceList>\n   </device>\n</root>";
    private static final String DESCRIPTION_FILE_NAME = "description/description.xml";
    private ConnectionManager conMan;
    private RenderingControl renCon;
    private AVTransport avTrans;
    private ActionListener actionListener;

    public MediaRenderer(String descriptionFileName) throws InvalidDescriptionException {
        super(new File(descriptionFileName));
        this.initialize();
    }

    public MediaRenderer() {
        try {
            this.initialize(DESCRIPTION, "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<scpd xmlns=\"urn:schemas-upnp-org:service-1-0\">\n   <specVersion>\n      <major>1</major>\n      <minor>0</minor>\n\t</specVersion>\n  <serviceStateTable>    <stateVariable>      <name>PresetNameList</name> <sendEventsAttribute>no</sendEventsAttribute>      <dataType>string</dataType>    </stateVariable>    <stateVariable>       <name>LastChange</name> <sendEventsAttribute>yes</sendEventsAttribute>      <dataType>string</dataType>    </stateVariable>    <stateVariable><Optional/>      <name>Brightness</name> <sendEventsAttribute>no</sendEventsAttribute>      <dataType>ui2</dataType>\t<allowedValueRange>\t\t<minimum>0</minimum>\t\t<step>1</step>\t</allowedValueRange>    </stateVariable>    <stateVariable><Optional/>      <name>Contrast</name> <sendEventsAttribute>no</sendEventsAttribute>      <dataType>ui2</dataType>\t<allowedValueRange>\t\t<minimum>0</minimum>\t\t<step>1</step>\t</allowedValueRange>    </stateVariable>    <stateVariable><Optional/>      <name>Sharpness</name> <sendEventsAttribute>no</sendEventsAttribute>      <dataType>ui2</dataType>\t<allowedValueRange>\t\t<minimum>0</minimum>\t\t<step>1</step>\t</allowedValueRange>    </stateVariable>    <stateVariable><Optional/>      <name>RedVideoGain</name> <sendEventsAttribute>no</sendEventsAttribute>      <dataType>ui2</dataType>    </stateVariable>    <stateVariable><Optional/>      <name>GreenVideoGain</name> <sendEventsAttribute>no</sendEventsAttribute>      <dataType>ui2</dataType>\t<allowedValueRange>\t\t<minimum>0</minimum>\t\t<step>1</step>\t</allowedValueRange>    </stateVariable>    <stateVariable><Optional/>      <name>BlueVideoGain</name> <sendEventsAttribute>no</sendEventsAttribute>      <dataType>ui2</dataType>\t<allowedValueRange>\t\t<minimum>0</minimum>\t\t<step>1</step>\t</allowedValueRange>    </stateVariable>    <stateVariable><Optional/>      <name>RedVideoBlackLevel</name> <sendEventsAttribute>no</sendEventsAttribute>      <dataType>ui2</dataType>\t<allowedValueRange>\t\t<minimum>0</minimum>\t\t<step>1</step>\t</allowedValueRange>    </stateVariable>    <stateVariable><Optional/>      <name>GreenVideoBlackLevel</name> <sendEventsAttribute>no</sendEventsAttribute>      <dataType>ui2</dataType>\t<allowedValueRange>\t\t<minimum>0</minimum>\t\t<step>1</step>\t</allowedValueRange>    </stateVariable>    <stateVariable><Optional/>      <name>BlueVideoBlackLevel</name> <sendEventsAttribute>no</sendEventsAttribute>      <dataType>ui2</dataType>\t<allowedValueRange>\t\t<minimum>0</minimum>\t\t<step>1</step>\t</allowedValueRange>    </stateVariable>    <stateVariable><Optional/>      <name>ColorTemperature</name> <sendEventsAttribute>no</sendEventsAttribute>      <dataType>ui2</dataType>\t<allowedValueRange>\t\t<minimum>0</minimum>\t\t<step>1</step>\t</allowedValueRange>    </stateVariable>    <stateVariable><Optional/>      <name>HorizontalKeystone</name> <sendEventsAttribute>no</sendEventsAttribute>      <dataType>i2</dataType>\t<allowedValueRange>\t\t<step>1</step>\t</allowedValueRange>    </stateVariable>    <stateVariable><Optional/>      <name>VerticalKeystone</name> <sendEventsAttribute>no</sendEventsAttribute>      <dataType>i2</dataType>\t<allowedValueRange>\t\t<step>1</step>\t</allowedValueRange>    </stateVariable>    <stateVariable><Optional/>      <name>Mute</name> <sendEventsAttribute>no</sendEventsAttribute>      <dataType>boolean</dataType>    </stateVariable>    <stateVariable><Optional/>      <name>Volume</name> <sendEventsAttribute>no</sendEventsAttribute>      <dataType>ui2</dataType>\t<allowedValueRange>\t\t<minimum>0</minimum>\t\t<step>1</step>\t</allowedValueRange>    </stateVariable>    <stateVariable><Optional/>      <name>VolumeDB</name> <sendEventsAttribute>no</sendEventsAttribute>      <dataType>i2</dataType>    </stateVariable>    <stateVariable><Optional/>      <name>Loudness</name> <sendEventsAttribute>no</sendEventsAttribute>      <dataType>boolean</dataType>    </stateVariable>    <stateVariable><Optional/>      <name>A_ARG_TYPE_Channel</name> <sendEventsAttribute>no</sendEventsAttribute>      <dataType>string</dataType>      <allowedValueList>        <allowedValue>Master</allowedValue>      </allowedValueList>    </stateVariable>    <stateVariable><Optional/>      <name>A_ARG_TYPE_InstanceID</name> <sendEventsAttribute>no</sendEventsAttribute>      <dataType>ui4</dataType>    </stateVariable>    <stateVariable>      <name>A_ARG_TYPE_PresetName</name> <sendEventsAttribute>no</sendEventsAttribute>      <dataType>string</dataType>      <allowedValueList>        <allowedValue>FactoryDefaults</allowedValue>      </allowedValueList>    </stateVariable>  </serviceStateTable>  <actionList>    <action>    <name>ListPresets</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>CurrentPresetNameList</name>          <direction>out</direction>          <relatedStateVariable>PresetNameList</relatedStateVariable>        </argument>      </argumentList>    </action>    <action>    <name>SelectPreset</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>PresetName</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_PresetName</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>GetBrightness</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>CurrentBrightness</name>          <direction>out</direction>          <relatedStateVariable>Brightness</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>SetBrightness</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>DesiredBrightness</name>          <direction>in</direction>          <relatedStateVariable>Brightness</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>GetContrast</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>CurrentContrast</name>          <direction>out</direction>          <relatedStateVariable>Contrast</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>SetContrast</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>DesiredContrast</name>          <direction>in</direction>          <relatedStateVariable>Contrast</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>GetSharpness</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>CurrentSharpness</name>          <direction>out</direction>          <relatedStateVariable>Sharpness</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>SetSharpness</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>DesiredSharpness</name>          <direction>in</direction>          <relatedStateVariable>Sharpness</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>GetRedVideoGain</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>CurrentRedVideoGain</name>          <direction>out</direction>          <relatedStateVariable>RedVideoGain</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>SetRedVideoGain</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>DesiredRedVideoGain</name>          <direction>in</direction>          <relatedStateVariable>RedVideoGain</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>GetGreenVideoGain</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>CurrentGreenVideoGain</name>          <direction>out</direction>          <relatedStateVariable>GreenVideoGain</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>SetGreenVideoGain</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>DesiredGreenVideoGain</name>          <direction>in</direction>          <relatedStateVariable>GreenVideoGain</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>GetBlueVideoGain</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>CurrentBlueVideoGain</name>          <direction>out</direction>          <relatedStateVariable>BlueVideoGain</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>SetBlueVideoGain</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>DesiredBlueVideoGain</name>          <direction>in</direction>          <relatedStateVariable>BlueVideoGain</relatedStateVariable>        </argument>      </argumentList>    </action>   <action><Optional/>    <name>GetRedVideoBlackLevel</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>CurrentRedVideoBlackLevel</name>          <direction>out</direction>          <relatedStateVariable>RedVideoBlackLevel</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>SetRedVideoBlackLevel</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>DesiredRedVideoBlackLevel</name>          <direction>in</direction>          <relatedStateVariable>RedVideoBlackLevel</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>GetGreenVideoBlackLevel</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>CurrentGreenVideoBlackLevel</name>          <direction>out</direction>          <relatedStateVariable>GreenVideoBlackLevel</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>SetGreenVideoBlackLevel</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>DesiredGreenVideoBlackLevel</name>          <direction>in</direction>          <relatedStateVariable>GreenVideoBlackLevel</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>GetBlueVideoBlackLevel</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>CurrentBlueVideoBlackLevel</name>          <direction>out</direction>          <relatedStateVariable>BlueVideoBlackLevel</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>SetBlueVideoBlackLevel</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>DesiredBlueVideoBlackLevel</name>    <direction>in</direction>  <relatedStateVariable>BlueVideoBlackLevel</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>GetColorTemperature </name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>CurrentColorTemperature</name>          <direction>out</direction>          <relatedStateVariable>ColorTemperature</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>SetColorTemperature</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>DesiredColorTemperature</name>          <direction>in</direction>          <relatedStateVariable>ColorTemperature</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>GetHorizontalKeystone</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>CurrentHorizontalKeystone</name>          <direction>out</direction>          <relatedStateVariable>HorizontalKeystone</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>SetHorizontalKeystone</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>DesiredHorizontalKeystone</name>          <direction>in</direction>          <relatedStateVariable>HorizontalKeystone</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>GetVerticalKeystone</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>CurrentVerticalKeystone</name>          <direction>out</direction>          <relatedStateVariable>VerticalKeystone</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>SetVerticalKeystone</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>DesiredVerticalKeystone</name>          <direction>in</direction>          <relatedStateVariable>VerticalKeystone</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>GetMute</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>Channel</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_Channel</relatedStateVariable>        </argument>        <argument>          <name>CurrentMute</name>          <direction>out</direction>          <relatedStateVariable>Mute</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>SetMute</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>Channel</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_Channel</relatedStateVariable>        </argument>        <argument>          <name>DesiredMute</name>          <direction>in</direction>          <relatedStateVariable>Mute</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>GetVolume</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>Channel</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_Channel</relatedStateVariable>        </argument>        <argument>          <name>CurrentVolume</name>          <direction>out</direction>          <relatedStateVariable>Volume</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>SetVolume</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>Channel</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_Channel</relatedStateVariable>        </argument>        <argument>          <name>DesiredVolume</name>          <direction>in</direction>          <relatedStateVariable>Volume</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>GetVolumeDB</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>Channel</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_Channel</relatedStateVariable>        </argument>        <argument>          <name>CurrentVolume</name>          <direction>out</direction>          <relatedStateVariable>VolumeDB</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>SetVolumeDB</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>Channel</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_Channel</relatedStateVariable>        </argument>        <argument>          <name>DesiredVolume</name>          <direction>in</direction>          <relatedStateVariable>VolumeDB</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>GetVolumeDBRange</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>Channel</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_Channel</relatedStateVariable>        </argument>        <argument>          <name>MinValue</name>          <direction>out</direction>          <relatedStateVariable>VolumeDB</relatedStateVariable>        </argument>        <argument>          <name>MaxValue</name>          <direction>out</direction>          <relatedStateVariable>VolumeDB</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>GetLoudness</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>Channel</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_Channel</relatedStateVariable>        </argument>        <argument>          <name>CurrentLoudness</name>          <direction>out</direction>          <relatedStateVariable>Loudness</relatedStateVariable>        </argument>      </argumentList>    </action>    <action><Optional/>    <name>SetLoudness</name>      <argumentList>        <argument>          <name>InstanceID</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>        </argument>        <argument>          <name>Channel</name>          <direction>in</direction>          <relatedStateVariable>A_ARG_TYPE_Channel</relatedStateVariable>        </argument>        <argument>          <name>DesiredLoudness</name>          <direction>in</direction>          <relatedStateVariable>Loudness</relatedStateVariable>        </argument>      </argumentList>    </action>  </actionList></scpd>", "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<scpd xmlns=\"urn:schemas-upnp-org:service-1-0\">\n   <specVersion>\n      <major>1</major>\n      <minor>0</minor>\n\t</specVersion>\n\t<actionList>\n\t\t<action>\n         <name>GetCurrentConnectionInfo</name>\n         <argumentList>\n            <argument>\n               <name>ConnectionID</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_ConnectionID</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>RcsID</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_RcsID</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>AVTransportID</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_AVTransportID</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>ProtocolInfo</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_ProtocolInfo</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>PeerConnectionManager</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_ConnectionManager</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>PeerConnectionID</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_ConnectionID</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>Direction</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_Direction</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>Status</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_ConnectionStatus</relatedStateVariable>\n            </argument>\n         </argumentList>\n      </action>\n      <action>\n         <name>GetProtocolInfo</name>\n         <argumentList>\n            <argument>\n               <name>Source</name>\n               <direction>out</direction>\n               <relatedStateVariable>SourceProtocolInfo</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>Sink</name>\n               <direction>out</direction>\n               <relatedStateVariable>SinkProtocolInfo</relatedStateVariable>\n            </argument>\n         </argumentList>\n      </action>\n      <action>\n         <name>GetCurrentConnectionIDs</name>\n         <argumentList>\n            <argument>\n               <name>ConnectionIDs</name>\n               <direction>out</direction>\n               <relatedStateVariable>CurrentConnectionIDs</relatedStateVariable>\n            </argument>\n         </argumentList>\n      </action>\n   </actionList>\n   <serviceStateTable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_ProtocolInfo</name>\n         <dataType>string</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_ConnectionStatus</name>\n         <dataType>string</dataType>\n         <allowedValueList>\n            <allowedValue>OK</allowedValue>\n            <allowedValue>ContentFormatMismatch</allowedValue>\n            <allowedValue>InsufficientBandwidth</allowedValue>\n            <allowedValue>UnreliableChannel</allowedValue>\n            <allowedValue>Unknown</allowedValue>\n         </allowedValueList>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_AVTransportID</name>\n         <dataType>i4</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_RcsID</name>\n         <dataType>i4</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_ConnectionID</name>\n         <dataType>i4</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_ConnectionManager</name>\n         <dataType>string</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"yes\">\n         <name>SourceProtocolInfo</name>\n         <dataType>string</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"yes\">\n         <name>SinkProtocolInfo</name>\n         <dataType>string</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_Direction</name>\n         <dataType>string</dataType>\n         <allowedValueList>\n            <allowedValue>Input</allowedValue>\n            <allowedValue>Output</allowedValue>\n         </allowedValueList>\n      </stateVariable>\n      <stateVariable sendEvents=\"yes\">\n         <name>CurrentConnectionIDs</name>\n         <dataType>string</dataType>\n      </stateVariable>\n   </serviceStateTable>\n</scpd>", "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<scpd xmlns=\"urn:schemas-upnp-org:service-1-0\">\n   <specVersion>\n      <major>1</major>\n      <minor>0</minor>\n\t</specVersion>\n    <serviceStateTable>        <stateVariable>            <name>TransportState</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>            <allowedValueList>                <allowedValue>STOPPED</allowedValue>                <allowedValue>PLAYING</allowedValue>            </allowedValueList>        </stateVariable>        <stateVariable>            <name>TransportStatus</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>            <allowedValueList>                <allowedValue>OK</allowedValue>                <allowedValue>ERROR_OCCURRED</allowedValue>                       </allowedValueList>        </stateVariable>        <stateVariable>            <name>PlaybackStorageMedium</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>        </stateVariable>\t     <stateVariable>            <name>RecordStorageMedium</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>              </stateVariable>        <stateVariable>            <name>PossiblePlaybackStorageMedia</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>        </stateVariable>        <stateVariable>            <name>PossibleRecordStorageMedia</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>        </stateVariable>        <stateVariable>            <name>CurrentPlayMode</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>            <allowedValueList>                <allowedValue>NORMAL</allowedValue>            </allowedValueList>            <defaultValue>NORMAL</defaultValue>        </stateVariable>        <stateVariable>            <name>TransportPlaySpeed</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>\t         <allowedValueList>                <allowedValue>1</allowedValue>            </allowedValueList>        </stateVariable>        <stateVariable>            <sendEventsAttribute>no</sendEventsAttribute>            <name>RecordMediumWriteStatus </name>            <dataType>string</dataType>         </stateVariable>        <stateVariable>            <name>CurrentRecordQualityMode</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>          </stateVariable>        <stateVariable>            <name>PossibleRecordQualityModes</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>        </stateVariable>        <stateVariable>            <name>NumberOfTracks</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>ui4</dataType>\t\t     <allowedValueRange>\t\t\t     <minimum>0</minimum>\t\t     </allowedValueRange>         </stateVariable>        <stateVariable>            <name>CurrentTrack</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>ui4</dataType>\t\t     <allowedValueRange>\t\t\t    <minimum>0</minimum>\t\t\t    <step>1</step>\t\t     </allowedValueRange>        </stateVariable>        <stateVariable>            <name>CurrentTrackDuration</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>        </stateVariable>\t     <stateVariable>            <name>CurrentMediaDuration</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>        </stateVariable>        <stateVariable>            <name>CurrentTrackMetaData</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>        </stateVariable>        <stateVariable>            <name>CurrentTrackURI</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>        </stateVariable>        <stateVariable>            <name>AVTransportURI</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>        </stateVariable>        <stateVariable>            <name>AVTransportURIMetaData</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>        </stateVariable>        <stateVariable>            <name>NextAVTransportURI</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>        </stateVariable>        <stateVariable>            <name>NextAVTransportURIMetaData</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>        </stateVariable>        <stateVariable>            <name>RelativeTimePosition</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>        </stateVariable>        <stateVariable>            <name>AbsoluteTimePosition</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>        </stateVariable>        <stateVariable>            <name>RelativeCounterPosition</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>i4</dataType>        </stateVariable>        <stateVariable>            <name>AbsoluteCounterPosition</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>i4</dataType>        </stateVariable>        <stateVariable>\t\t<Optional/>            <name>CurrentTransportActions</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>        </stateVariable>        <stateVariable>            <name>LastChange</name>            <sendEventsAttribute>yes</sendEventsAttribute>            <dataType>string</dataType>        </stateVariable>        <stateVariable>            <name>A_ARG_TYPE_SeekMode</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>            <allowedValueList>                 <allowedValue>TRACK_NR</allowedValue>            </allowedValueList>        </stateVariable>        <stateVariable>            <name>A_ARG_TYPE_SeekTarget</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>string</dataType>        </stateVariable>        <stateVariable>            <name>A_ARG_TYPE_InstanceID</name>            <sendEventsAttribute>no</sendEventsAttribute>            <dataType>ui4</dataType>        </stateVariable>    </serviceStateTable>    <actionList>        <action>            <name>SetAVTransportURI</name>            <argumentList>                <argument>                    <name>InstanceID</name>                    <direction>in</direction>                    <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>                </argument>                <argument>                    <name>CurrentURI</name>                    <direction>in</direction>                    <relatedStateVariable>AVTransportURI</relatedStateVariable>                </argument>                <argument>                    <name>CurrentURIMetaData</name>                    <direction>in</direction>                    <relatedStateVariable>AVTransportURIMetaData</relatedStateVariable>                </argument>            </argumentList>        </action>        <action>\t<Optional/>            <name>SetNextAVTransportURI</name>            <argumentList>                <argument>                    <name>InstanceID</name>                    <direction>in</direction>                    <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>                </argument>                <argument>                    <name>NextURI</name>                    <direction>in</direction>                    <relatedStateVariable>NextAVTransportURI</relatedStateVariable>                </argument>                <argument>                    <name>NextURIMetaData</name>                    <direction>in</direction>                    <relatedStateVariable>NextAVTransportURIMetaData</relatedStateVariable>                </argument>            </argumentList>        </action>        <action>            <name>GetMediaInfo</name>            <argumentList>                <argument>                    <name>InstanceID</name>                    <direction>in</direction>                 <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>                </argument>                <argument>                    <name>NrTracks</name>                    <direction>out</direction>                    <relatedStateVariable>NumberOfTracks</relatedStateVariable>                </argument>                <argument>                    <name>MediaDuration</name>                    <direction>out</direction>                    <relatedStateVariable>CurrentMediaDuration</relatedStateVariable>                </argument>                <argument>                    <name>CurrentURI</name>                    <direction>out</direction>                    <relatedStateVariable>AVTransportURI</relatedStateVariable>                </argument>\t\t         <argument>                    <name>CurrentURIMetaData</name>                    <direction>out</direction>                    <relatedStateVariable>AVTransportURIMetaData</relatedStateVariable>                </argument>                <argument>                    <name>NextURI</name>                    <direction>out</direction>                    <relatedStateVariable>NextAVTransportURI</relatedStateVariable>                </argument>\t\t         <argument>                    <name>NextURIMetaData</name>                    <direction>out</direction>                    <relatedStateVariable>NextAVTransportURIMetaData</relatedStateVariable>                </argument>                <argument>                    <name>PlayMedium</name>                    <direction>out</direction>                    <relatedStateVariable>PlaybackStorageMedium</relatedStateVariable>                </argument>                <argument>                    <name>RecordMedium</name>                    <direction>out</direction>                    <relatedStateVariable>RecordStorageMedium</relatedStateVariable>                </argument>                <argument>                    <name>WriteStatus</name>                    <direction>out</direction>                    <relatedStateVariable>RecordMediumWriteStatus </relatedStateVariable>                </argument>            </argumentList>        </action>        <action>            <name>GetTransportInfo</name>            <argumentList>                <argument>                    <name>InstanceID</name>                    <direction>in</direction>                    <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>                </argument>                <argument>                    <name>CurrentTransportState</name>                    <direction>out</direction>                    <relatedStateVariable>TransportState</relatedStateVariable>                </argument>                <argument>                    <name>CurrentTransportStatus</name>                    <direction>out</direction>                    <relatedStateVariable>TransportStatus</relatedStateVariable>                </argument>                <argument>                    <name>CurrentSpeed</name>                    <direction>out</direction>                    <relatedStateVariable>TransportPlaySpeed</relatedStateVariable>                </argument>            </argumentList>        </action>        <action>            <name>GetPositionInfo</name>            <argumentList>                <argument>                    <name>InstanceID</name>                    <direction>in</direction>                    <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>                </argument>                <argument>                    <name>Track</name>                    <direction>out</direction>                    <relatedStateVariable>CurrentTrack</relatedStateVariable>                </argument>                <argument>                    <name>TrackDuration</name>                    <direction>out</direction>                    <relatedStateVariable>CurrentTrackDuration</relatedStateVariable>                </argument>                <argument>                    <name>TrackMetaData</name>                    <direction>out</direction>                    <relatedStateVariable>CurrentTrackMetaData</relatedStateVariable>                </argument>                <argument>                    <name>TrackURI</name>                    <direction>out</direction>                    <relatedStateVariable>CurrentTrackURI</relatedStateVariable>                </argument>                <argument>                    <name>RelTime</name>                    <direction>out</direction>                    <relatedStateVariable>RelativeTimePosition</relatedStateVariable>                </argument>                <argument>                    <name>AbsTime</name>                    <direction>out</direction>                    <relatedStateVariable>AbsoluteTimePosition</relatedStateVariable>                </argument>                <argument>                    <name>RelCount</name>                    <direction>out</direction>                    <relatedStateVariable>RelativeCounterPosition</relatedStateVariable>                </argument>                <argument>                    <name>AbsCount</name>                    <direction>out</direction>                    <relatedStateVariable>AbsoluteCounterPosition</relatedStateVariable>                </argument>            </argumentList>        </action>        <action>            <name>GetDeviceCapabilities</name>            <argumentList>                <argument>                    <name>InstanceID</name>                    <direction>in</direction>                    <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>                </argument>                <argument>                    <name>PlayMedia</name>                    <direction>out</direction>                    <relatedStateVariable>PossiblePlaybackStorageMedia</relatedStateVariable>                </argument>                <argument>                    <name>RecMedia</name>                    <direction>out</direction>                    <relatedStateVariable>PossibleRecordStorageMedia</relatedStateVariable>                </argument>                <argument>                    <name>RecQualityModes</name>                    <direction>out</direction>                    <relatedStateVariable>PossibleRecordQualityModes</relatedStateVariable>                </argument>            </argumentList>        </action>        <action>            <name>GetTransportSettings</name>            <argumentList>                <argument>                    <name>InstanceID</name>                    <direction>in</direction>                    <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>                </argument>                <argument>                    <name>PlayMode</name>                    <direction>out</direction>                    <relatedStateVariable>CurrentPlayMode</relatedStateVariable>                </argument>                <argument>                    <name>RecQualityMode</name>                    <direction>out</direction>                 <relatedStateVariable>CurrentRecordQualityMode</relatedStateVariable>                </argument>            </argumentList>        </action>        <action>            <name>Stop</name>            <argumentList>                <argument>                    <name>InstanceID</name>                    <direction>in</direction>                    <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>                </argument>            </argumentList>        </action>        <action>            <name>Play</name>            <argumentList>                <argument>                    <name>InstanceID</name>                    <direction>in</direction>                    <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>                </argument>                <argument>                    <name>Speed</name>                    <direction>in</direction>                    <relatedStateVariable>TransportPlaySpeed</relatedStateVariable>                </argument>            </argumentList>        </action>        <action>\t<Optional/>            <name>Pause</name>            <argumentList>                <argument>                    <name>InstanceID</name>                    <direction>in</direction>                    <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>                </argument>            </argumentList>        </action>        <action>\t<Optional/>            <name>Record</name>            <argumentList>                <argument>                    <name>InstanceID</name>                    <direction>in</direction>                    <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>                </argument>            </argumentList>        </action>        <action>            <name>Seek</name>            <argumentList>                <argument>                    <name>InstanceID</name>                    <direction>in</direction>                    <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>                </argument>                <argument>                    <name>Unit</name>                    <direction>in</direction>                    <relatedStateVariable>A_ARG_TYPE_SeekMode</relatedStateVariable>                </argument>                <argument>                    <name>Target</name>                    <direction>in</direction>                    <relatedStateVariable>A_ARG_TYPE_SeekTarget</relatedStateVariable>                </argument>            </argumentList>        </action>        <action>            <name>Next</name>            <argumentList>                <argument>                    <name>InstanceID</name>                    <direction>in</direction>                    <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>                </argument>            </argumentList>        </action>        <action>            <name>Previous</name>            <argumentList>                <argument>                    <name>InstanceID</name>                    <direction>in</direction>                    <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>                </argument>            </argumentList>        </action>        <action>\t<Optional/>            <name>SetPlayMode</name>            <argumentList>                <argument>                    <name>InstanceID</name>                    <direction>in</direction>                    <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>                </argument>                <argument>                    <name>NewPlayMode</name>                    <direction>in</direction>                    <relatedStateVariable>CurrentPlayMode</relatedStateVariable>                </argument>            </argumentList>        </action>        <action>\t<Optional/>            <name>SetRecordQualityMode</name>            <argumentList>                <argument>                    <name>InstanceID</name>                    <direction>in</direction>                    <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>                </argument>                <argument>                    <name>NewRecordQualityMode</name>                    <direction>in</direction>                    <relatedStateVariable>CurrentRecordQualityMode</relatedStateVariable>                </argument>            </argumentList>        </action>        <action>\t<Optional/>            <name>GetCurrentTransportActions</name>            <argumentList>                <argument>                    <name>InstanceID</name>                    <direction>in</direction>                    <relatedStateVariable>A_ARG_TYPE_InstanceID</relatedStateVariable>                </argument>                <argument>                    <name>Actions</name>                    <direction>out</direction>                    <relatedStateVariable>CurrentTransportActions</relatedStateVariable>                </argument>            </argumentList>        </action>    </actionList></scpd>");
        }
        catch (InvalidDescriptionException invalidDescriptionException) {
            // empty catch block
        }
    }

    public MediaRenderer(String description, String renderCtrlSCPD, String conMgrSCPD, String avTransSCPD) throws InvalidDescriptionException {
        this.initialize(description, renderCtrlSCPD, conMgrSCPD, avTransSCPD);
    }

    private void initialize(String description, String renderCtrlSCPD, String conMgrSCPD, String avTransSCPD) throws InvalidDescriptionException {
        this.loadDescription(description);
        Service renCtrlService = this.getService("urn:schemas-upnp-org:service:RenderingControl:1");
        renCtrlService.loadSCPD(renderCtrlSCPD);
        Service conManService = this.getService("urn:schemas-upnp-org:service:ConnectionManager:1");
        conManService.loadSCPD(conMgrSCPD);
        Service avTransService = this.getService("urn:schemas-upnp-org:service:AVTransport:1");
        avTransService.loadSCPD(avTransSCPD);
        this.initialize();
    }

    private void initialize() {
        UPnP.setEnable((int)9);
        String firstIf = HostInterface.getHostAddress((int)0);
        this.setInterfaceAddress(firstIf);
        this.setHTTPPort(39520);
        this.renCon = new RenderingControl(this);
        this.conMan = new ConnectionManager(this);
        this.avTrans = new AVTransport(this);
        this.setActionListener(null);
    }

    protected void finalize() {
        this.stop();
    }

    public ConnectionManager getConnectionManager() {
        return this.conMan;
    }

    public RenderingControl getRenderingControl() {
        return this.renCon;
    }

    public AVTransport getAVTransport() {
        return this.avTrans;
    }

    public void setInterfaceAddress(String ifaddr) {
        HostInterface.setInterface((String)ifaddr);
    }

    public String getInterfaceAddress() {
        return HostInterface.getInterface();
    }

    public void httpRequestRecieved(HTTPRequest httpReq) {
        String uri = httpReq.getURI();
        Debug.message((String)("uri = " + uri));
        super.httpRequestRecieved(httpReq);
    }

    public void setActionListener(ActionListener listener) {
        this.actionListener = listener;
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public boolean start() {
        super.start();
        return true;
    }

    public boolean stop() {
        super.stop();
        return true;
    }

    public void update() {
    }
}

