/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.std.av.server;

import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.StateVariable;
import org.cybergarage.upnp.control.ActionListener;
import org.cybergarage.upnp.control.QueryListener;
import org.cybergarage.upnp.std.av.server.ConnectionInfo;
import org.cybergarage.upnp.std.av.server.ConnectionInfoList;
import org.cybergarage.upnp.std.av.server.ContentDirectory;
import org.cybergarage.upnp.std.av.server.MediaServer;
import org.cybergarage.upnp.std.av.server.object.Format;
import org.cybergarage.util.Mutex;

public class ConnectionManager
implements ActionListener,
QueryListener {
    public static final String SERVICE_TYPE = "urn:schemas-upnp-org:service:ConnectionManager:1";
    public static final String HTTP_GET = "http-get";
    public static final String SOURCEPROTOCOLINFO = "SourceProtocolInfo";
    public static final String SINKPROTOCOLINFO = "SinkProtocolInfo";
    public static final String CURRENTCONNECTIONIDS = "CurrentConnectionIDs";
    public static final String GETPROTOCOLINFO = "GetProtocolInfo";
    public static final String SOURCE = "Source";
    public static final String SINK = "Sink";
    public static final String PREPAREFORCONNECTION = "PrepareForConnection";
    public static final String REMOTEPROTOCOLINFO = "RemoteProtocolInfo";
    public static final String PEERCONNECTIONMANAGER = "PeerConnectionManager";
    public static final String PEERCONNECTIONID = "PeerConnectionID";
    public static final String DIRECTION = "Direction";
    public static final String CONNECTIONID = "ConnectionID";
    public static final String AVTRANSPORTID = "AVTransportID";
    public static final String RCSID = "RcsID";
    public static final String CONNECTIONCOMPLETE = "ConnectionComplete";
    public static final String GETCURRENTCONNECTIONIDS = "GetCurrentConnectionIDs";
    public static final String CONNECTIONIDS = "ConnectionIDs";
    public static final String GETCURRENTCONNECTIONINFO = "GetCurrentConnectionInfo";
    public static final String PROTOCOLINFO = "ProtocolInfo";
    public static final String STATUS = "Status";
    public static final String OK = "OK";
    public static final String CONTENTFORMATMISMATCH = "ContentFormatMismatch";
    public static final String INSUFFICIENTBANDWIDTH = "InsufficientBandwidth";
    public static final String UNRELIABLECHANNEL = "UnreliableChannel";
    public static final String UNKNOWN = "Unknown";
    public static final String INPUT = "Input";
    public static final String OUTPUT = "Output";
    public static final String SCPD = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<scpd xmlns=\"urn:schemas-upnp-org:service-1-0\">\n   <specVersion>\n      <major>1</major>\n      <minor>0</minor>\n\t</specVersion>\n\t<actionList>\n\t\t<action>\n         <name>GetCurrentConnectionInfo</name>\n         <argumentList>\n            <argument>\n               <name>ConnectionID</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_ConnectionID</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>RcsID</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_RcsID</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>AVTransportID</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_AVTransportID</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>ProtocolInfo</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_ProtocolInfo</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>PeerConnectionManager</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_ConnectionManager</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>PeerConnectionID</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_ConnectionID</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>Direction</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_Direction</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>Status</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_ConnectionStatus</relatedStateVariable>\n            </argument>\n         </argumentList>\n      </action>\n      <action>\n         <name>GetProtocolInfo</name>\n         <argumentList>\n            <argument>\n               <name>Source</name>\n               <direction>out</direction>\n               <relatedStateVariable>SourceProtocolInfo</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>Sink</name>\n               <direction>out</direction>\n               <relatedStateVariable>SinkProtocolInfo</relatedStateVariable>\n            </argument>\n         </argumentList>\n      </action>\n      <action>\n         <name>GetCurrentConnectionIDs</name>\n         <argumentList>\n            <argument>\n               <name>ConnectionIDs</name>\n               <direction>out</direction>\n               <relatedStateVariable>CurrentConnectionIDs</relatedStateVariable>\n            </argument>\n         </argumentList>\n      </action>\n   </actionList>\n   <serviceStateTable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_ProtocolInfo</name>\n         <dataType>string</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_ConnectionStatus</name>\n         <dataType>string</dataType>\n         <allowedValueList>\n            <allowedValue>OK</allowedValue>\n            <allowedValue>ContentFormatMismatch</allowedValue>\n            <allowedValue>InsufficientBandwidth</allowedValue>\n            <allowedValue>UnreliableChannel</allowedValue>\n            <allowedValue>Unknown</allowedValue>\n         </allowedValueList>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_AVTransportID</name>\n         <dataType>i4</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_RcsID</name>\n         <dataType>i4</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_ConnectionID</name>\n         <dataType>i4</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_ConnectionManager</name>\n         <dataType>string</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"yes\">\n         <name>SourceProtocolInfo</name>\n         <dataType>string</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"yes\">\n         <name>SinkProtocolInfo</name>\n         <dataType>string</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_Direction</name>\n         <dataType>string</dataType>\n         <allowedValueList>\n            <allowedValue>Input</allowedValue>\n            <allowedValue>Output</allowedValue>\n         </allowedValueList>\n      </stateVariable>\n      <stateVariable sendEvents=\"yes\">\n         <name>CurrentConnectionIDs</name>\n         <dataType>string</dataType>\n      </stateVariable>\n   </serviceStateTable>\n</scpd>";
    private MediaServer mediaServer;
    private Mutex mutex = new Mutex();
    private int maxConnectionID;
    private ConnectionInfoList conInfoList = new ConnectionInfoList();

    public ConnectionManager(MediaServer mserver) {
        this.setMediaServer(mserver);
        this.maxConnectionID = 0;
    }

    private void setMediaServer(MediaServer mserver) {
        this.mediaServer = mserver;
    }

    public MediaServer getMediaServer() {
        return this.mediaServer;
    }

    public ContentDirectory getContentDirectory() {
        return this.getContentDirectory();
    }

    public void lock() {
        this.mutex.lock();
    }

    public void unlock() {
        this.mutex.unlock();
    }

    public int getNextConnectionID() {
        this.lock();
        ++this.maxConnectionID;
        this.unlock();
        return this.maxConnectionID;
    }

    public ConnectionInfoList getConnectionInfoList() {
        return this.conInfoList;
    }

    public ConnectionInfo getConnectionInfo(int id) {
        int size = this.conInfoList.size();
        for (int n = 0; n < size; ++n) {
            ConnectionInfo info = this.conInfoList.getConnectionInfo(n);
            if (info.getID() != id) continue;
            return info;
        }
        return null;
    }

    public void addConnectionInfo(ConnectionInfo info) {
        this.lock();
        this.conInfoList.add(info);
        this.unlock();
    }

    public void removeConnectionInfo(int id) {
        this.lock();
        int size = this.conInfoList.size();
        for (int n = 0; n < size; ++n) {
            ConnectionInfo info = this.conInfoList.getConnectionInfo(n);
            if (info.getID() != id) continue;
            this.conInfoList.remove(info);
            break;
        }
        this.unlock();
    }

    public void removeConnectionInfo(ConnectionInfo info) {
        this.lock();
        this.conInfoList.remove(info);
        this.unlock();
    }

    public boolean actionControlReceived(Action action) {
        String actionName = action.getName();
        if (actionName.equals(GETPROTOCOLINFO)) {
            Object sourceValue = "";
            int mimeTypeCnt = this.getContentDirectory().getNFormats();
            for (int n = 0; n < mimeTypeCnt; ++n) {
                if (0 < n) {
                    sourceValue = (String)sourceValue + ",";
                }
                Format format = this.getContentDirectory().getFormat(n);
                String mimeType = format.getMimeType();
                sourceValue = (String)sourceValue + "http-get:*:" + mimeType + ":*";
            }
            action.getArgument(SOURCE).setValue((String)sourceValue);
            action.getArgument(SINK).setValue("");
            return true;
        }
        if (actionName.equals(PREPAREFORCONNECTION)) {
            action.getArgument(CONNECTIONID).setValue(-1);
            action.getArgument(AVTRANSPORTID).setValue(-1);
            action.getArgument(RCSID).setValue(-1);
            return true;
        }
        if (actionName.equals(CONNECTIONCOMPLETE)) {
            return true;
        }
        if (actionName.equals(GETCURRENTCONNECTIONINFO)) {
            return this.getCurrentConnectionInfo(action);
        }
        if (actionName.equals(GETCURRENTCONNECTIONIDS)) {
            return this.getCurrentConnectionIDs(action);
        }
        return false;
    }

    private boolean getCurrentConnectionIDs(Action action) {
        Object conIDs = "";
        this.lock();
        int size = this.conInfoList.size();
        for (int n = 0; n < size; ++n) {
            ConnectionInfo info = this.conInfoList.getConnectionInfo(n);
            if (0 < n) {
                conIDs = (String)conIDs + ",";
            }
            conIDs = (String)conIDs + Integer.toString(info.getID());
        }
        action.getArgument(CONNECTIONIDS).setValue((String)conIDs);
        this.unlock();
        return true;
    }

    private boolean getCurrentConnectionInfo(Action action) {
        int id = action.getArgument(RCSID).getIntegerValue();
        this.lock();
        ConnectionInfo info = this.getConnectionInfo(id);
        if (info != null) {
            action.getArgument(RCSID).setValue(info.getRcsID());
            action.getArgument(AVTRANSPORTID).setValue(info.getAVTransportID());
            action.getArgument(PEERCONNECTIONMANAGER).setValue(info.getPeerConnectionManager());
            action.getArgument(PEERCONNECTIONID).setValue(info.getPeerConnectionID());
            action.getArgument(DIRECTION).setValue(info.getDirection());
            action.getArgument(STATUS).setValue(info.getStatus());
        } else {
            action.getArgument(RCSID).setValue(-1);
            action.getArgument(AVTRANSPORTID).setValue(-1);
            action.getArgument(PEERCONNECTIONMANAGER).setValue("");
            action.getArgument(PEERCONNECTIONID).setValue(-1);
            action.getArgument(DIRECTION).setValue(OUTPUT);
            action.getArgument(STATUS).setValue(UNKNOWN);
        }
        this.unlock();
        return true;
    }

    public boolean queryControlReceived(StateVariable stateVar) {
        return false;
    }
}

