/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.std.av.server;

import java.io.File;
import java.io.InputStream;
import java.util.StringTokenizer;
import org.cybergarage.http.HTTPRequest;
import org.cybergarage.http.HTTPResponse;
import org.cybergarage.http.Parameter;
import org.cybergarage.http.ParameterList;
import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.Argument;
import org.cybergarage.upnp.StateVariable;
import org.cybergarage.upnp.control.ActionListener;
import org.cybergarage.upnp.control.QueryListener;
import org.cybergarage.upnp.std.av.server.ConnectionInfo;
import org.cybergarage.upnp.std.av.server.ConnectionManager;
import org.cybergarage.upnp.std.av.server.Directory;
import org.cybergarage.upnp.std.av.server.DirectoryList;
import org.cybergarage.upnp.std.av.server.MediaServer;
import org.cybergarage.upnp.std.av.server.action.BrowseAction;
import org.cybergarage.upnp.std.av.server.action.SearchAction;
import org.cybergarage.upnp.std.av.server.object.ContentNode;
import org.cybergarage.upnp.std.av.server.object.ContentNodeList;
import org.cybergarage.upnp.std.av.server.object.DIDLLite;
import org.cybergarage.upnp.std.av.server.object.Format;
import org.cybergarage.upnp.std.av.server.object.FormatList;
import org.cybergarage.upnp.std.av.server.object.SearchCap;
import org.cybergarage.upnp.std.av.server.object.SearchCapList;
import org.cybergarage.upnp.std.av.server.object.SearchCriteria;
import org.cybergarage.upnp.std.av.server.object.SearchCriteriaList;
import org.cybergarage.upnp.std.av.server.object.SortCap;
import org.cybergarage.upnp.std.av.server.object.SortCapList;
import org.cybergarage.upnp.std.av.server.object.SortCriterionList;
import org.cybergarage.upnp.std.av.server.object.container.ContainerNode;
import org.cybergarage.upnp.std.av.server.object.container.RootNode;
import org.cybergarage.upnp.std.av.server.object.item.ItemNode;
import org.cybergarage.upnp.std.av.server.object.search.IdSearchCap;
import org.cybergarage.upnp.std.av.server.object.search.TitleSearchCap;
import org.cybergarage.upnp.std.av.server.object.sort.DCDateSortCap;
import org.cybergarage.upnp.std.av.server.object.sort.DCTitleSortCap;
import org.cybergarage.upnp.std.av.server.object.sort.UPnPClassSortCap;
import org.cybergarage.util.Debug;
import org.cybergarage.util.Mutex;
import org.cybergarage.util.StringUtil;
import org.cybergarage.util.ThreadCore;

public class ContentDirectory
extends ThreadCore
implements ActionListener,
QueryListener {
    public static final String SERVICE_TYPE = "urn:schemas-upnp-org:service:ContentDirectory:1";
    public static final String TRANSFERIDS = "TransferIDs";
    public static final String SEARCHCAPABILITIES = "SearchCapabilities";
    public static final String SORTCAPABILITIES = "SortCapabilities";
    public static final String SYSTEMUPDATEID = "SystemUpdateID";
    public static final String CONTAINERUPDATEIDS = "ContainerUpdateIDs";
    public static final String GETSEARCHCAPABILITIES = "GetSearchCapabilities";
    public static final String SEARCHCAPS = "SearchCaps";
    public static final String GETSORTCAPABILITIES = "GetSortCapabilities";
    public static final String SORTCAPS = "SortCaps";
    public static final String GETSYSTEMUPDATEID = "GetSystemUpdateID";
    public static final String ID = "Id";
    public static final String BROWSE = "Browse";
    public static final String OBJECTID = "ObjectID";
    public static final String BROWSEFLAG = "BrowseFlag";
    public static final String FILTER = "Filter";
    public static final String STARTINGINDEX = "StartingIndex";
    public static final String REQUESTEDCOUNT = "RequestedCount";
    public static final String SORTCRITERIA = "SortCriteria";
    public static final String RESULT = "Result";
    public static final String NUMBERRETURNED = "NumberReturned";
    public static final String TOTALMATCHES = "TotalMatches";
    public static final String UPDATEID = "UpdateID";
    public static final String SEARCH = "Search";
    public static final String CONTAINERID = "ContainerID";
    public static final String SEARCHCRITERIA = "SearchCriteria";
    public static final String CREATEOBJECT = "CreateObject";
    public static final String ELEMENTS = "Elements";
    public static final String DESTROYOBJECT = "DestroyObject";
    public static final String UPDATEOBJECT = "UpdateObject";
    public static final String CURRENTTAGVALUE = "CurrentTagValue";
    public static final String NEWTAGVALUE = "NewTagValue";
    public static final String IMPORTRESOURCE = "ImportResource";
    public static final String SOURCEURI = "SourceURI";
    public static final String DESTINATIONURI = "DestinationURI";
    public static final String TRANSFERID = "TransferID";
    public static final String EXPORTRESOURCE = "ExportResource";
    public static final String STOPTRANSFERRESOURCE = "StopTransferResource";
    public static final String GETTRANSFERPROGRESS = "GetTransferProgress";
    public static final String TRANSFERSTATUS = "TransferStatus";
    public static final String TRANSFERLENGTH = "TransferLength";
    public static final String TRANSFERTOTAL = "TransferTotal";
    public static final String DELETERESOURCE = "DeleteResource";
    public static final String RESOURCEURI = "ResourceURI";
    public static final String CREATEREFERENCE = "CreateReference";
    public static final String NEWID = "NewID";
    public static final String BROWSEMETADATA = "BrowseMetadata";
    public static final String BROWSEDIRECTCHILDREN = "BrowseDirectChildren";
    public static final String COMPLETED = "COMPLETED";
    public static final String ERROR = "ERROR";
    public static final String IN_PROGRESS = "IN_PROGRESS";
    public static final String STOPPED = "STOPPED";
    public static final String CONTENT_EXPORT_URI = "/ExportContent";
    public static final String CONTENT_IMPORT_URI = "/ImportContent";
    public static final String CONTENT_ID = "id";
    public static final String SCPD = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<scpd xmlns=\"urn:schemas-upnp-org:service-1-0\">\n   <specVersion>\n      <major>1</major>\n      <minor>0</minor>\n   </specVersion>\n   <actionList>\n      <action>\n         <name>ExportResource</name>\n         <argumentList>\n            <argument>\n               <name>SourceURI</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_URI</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>DestinationURI</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_URI</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>TransferID</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_TransferID</relatedStateVariable>\n            </argument>\n         </argumentList>\n      </action>\n      <action>\n         <name>StopTransferResource</name>\n         <argumentList>\n            <argument>\n               <name>TransferID</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_TransferID</relatedStateVariable>\n            </argument>\n         </argumentList>\n      </action>\n      <action>\n         <name>DestroyObject</name>\n         <argumentList>\n            <argument>\n               <name>ObjectID</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_ObjectID</relatedStateVariable>\n            </argument>\n         </argumentList>\n      </action>\n      <action>\n         <name>DeleteResource</name>\n         <argumentList>\n            <argument>\n               <name>ResourceURI</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_URI</relatedStateVariable>\n            </argument>\n         </argumentList>\n      </action>\n      <action>\n         <name>UpdateObject</name>\n         <argumentList>\n            <argument>\n               <name>ObjectID</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_ObjectID</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>CurrentTagValue</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_TagValueList</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>NewTagValue</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_TagValueList</relatedStateVariable>\n            </argument>\n         </argumentList>\n      </action>\n      <action>\n         <name>Browse</name>\n         <argumentList>\n            <argument>\n               <name>ObjectID</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_ObjectID</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>BrowseFlag</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_BrowseFlag</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>Filter</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_Filter</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>StartingIndex</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_Index</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>RequestedCount</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_Count</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>SortCriteria</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_SortCriteria</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>Result</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_Result</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>NumberReturned</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_Count</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>TotalMatches</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_Count</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>UpdateID</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_UpdateID</relatedStateVariable>\n            </argument>\n         </argumentList>\n      </action>\n      <action>\n         <name>GetTransferProgress</name>\n         <argumentList>\n            <argument>\n               <name>TransferID</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_TransferID</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>TransferStatus</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_TransferStatus</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>TransferLength</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_TransferLength</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>TransferTotal</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_TransferTotal</relatedStateVariable>\n            </argument>\n         </argumentList>\n      </action>\n      <action>\n         <name>GetSearchCapabilities</name>\n         <argumentList>\n            <argument>\n               <name>SearchCaps</name>\n               <direction>out</direction>\n               <relatedStateVariable>SearchCapabilities</relatedStateVariable>\n            </argument>\n         </argumentList>\n      </action>\n      <action>\n         <name>CreateObject</name>\n         <argumentList>\n            <argument>\n               <name>ContainerID</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_ObjectID</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>Elements</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_Result</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>ObjectID</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_ObjectID</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>Result</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_Result</relatedStateVariable>\n            </argument>\n         </argumentList>\n      </action>\n      <action>\n         <name>Search</name>\n         <argumentList>\n            <argument>\n               <name>ContainerID</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_ObjectID</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>SearchCriteria</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_SearchCriteria</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>Filter</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_Filter</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>StartingIndex</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_Index</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>RequestedCount</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_Count</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>SortCriteria</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_SortCriteria</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>Result</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_Result</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>NumberReturned</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_Count</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>TotalMatches</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_Count</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>UpdateID</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_UpdateID</relatedStateVariable>\n            </argument>\n         </argumentList>\n      </action>\n      <action>\n         <name>GetSortCapabilities</name>\n         <argumentList>\n            <argument>\n               <name>SortCaps</name>\n               <direction>out</direction>\n               <relatedStateVariable>SortCapabilities</relatedStateVariable>\n            </argument>\n         </argumentList>\n      </action>\n      <action>\n         <name>ImportResource</name>\n         <argumentList>\n            <argument>\n               <name>SourceURI</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_URI</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>DestinationURI</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_URI</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>TransferID</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_TransferID</relatedStateVariable>\n            </argument>\n         </argumentList>\n      </action>\n      <action>\n         <name>CreateReference</name>\n         <argumentList>\n            <argument>\n               <name>ContainerID</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_ObjectID</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>ObjectID</name>\n               <direction>in</direction>\n               <relatedStateVariable>A_ARG_TYPE_ObjectID</relatedStateVariable>\n            </argument>\n            <argument>\n               <name>NewID</name>\n               <direction>out</direction>\n               <relatedStateVariable>A_ARG_TYPE_ObjectID</relatedStateVariable>\n            </argument>\n         </argumentList>\n      </action>\n      <action>\n         <name>GetSystemUpdateID</name>\n         <argumentList>\n            <argument>\n              <name>Id</name>\n               <direction>out</direction>\n               <relatedStateVariable>SystemUpdateID</relatedStateVariable>\n            </argument>\n         </argumentList>\n      </action>\n   </actionList>\n   <serviceStateTable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_SortCriteria</name>\n         <dataType>string</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_TransferLength</name>\n         <dataType>string</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"yes\">\n         <name>TransferIDs</name>\n         <dataType>string</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_UpdateID</name>\n         <dataType>ui4</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_SearchCriteria</name>\n         <dataType>string</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_Filter</name>\n         <dataType>string</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"yes\">\n         <name>ContainerUpdateIDs</name>\n         <dataType>string</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_Result</name>\n         <dataType>string</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_Index</name>\n         <dataType>ui4</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_TransferID</name>\n         <dataType>ui4</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_TagValueList</name>\n         <dataType>string</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_URI</name>\n         <dataType>uri</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_ObjectID</name>\n         <dataType>string</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>SortCapabilities</name>\n         <dataType>string</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>SearchCapabilities</name>\n         <dataType>string</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_Count</name>\n         <dataType>ui4</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_BrowseFlag</name>\n         <dataType>string</dataType>\n         <allowedValueList>\n            <allowedValue>BrowseMetadata</allowedValue>\n            <allowedValue>BrowseDirectChildren</allowedValue>\n         </allowedValueList>\n      </stateVariable>\n      <stateVariable sendEvents=\"yes\">\n         <name>SystemUpdateID</name>\n         <dataType>ui4</dataType>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_TransferStatus</name>\n         <dataType>string</dataType>\n         <allowedValueList>\n            <allowedValue>COMPLETED</allowedValue>\n            <allowedValue>ERROR</allowedValue>\n            <allowedValue>IN_PROGRESS</allowedValue>\n            <allowedValue>STOPPED</allowedValue>\n         </allowedValueList>\n      </stateVariable>\n      <stateVariable sendEvents=\"no\">\n         <name>A_ARG_TYPE_TransferTotal</name>\n         <dataType>string</dataType>\n      </stateVariable>\n   </serviceStateTable>\n</scpd>";
    private MediaServer mediaServer;
    private Mutex mutex = new Mutex();
    private int systemUpdateID;
    private int maxContentID;
    private RootNode rootNode;
    private FormatList formatList = new FormatList();
    private SortCapList sortCapList = new SortCapList();
    private SearchCapList searchCapList = new SearchCapList();
    private DirectoryList dirList = new DirectoryList();
    private static final int DEFAULT_SYSTEMUPDATEID_INTERVAL = 2000;
    private static final int DEFAULT_CONTENTUPDATE_INTERVAL = 60000;
    private long systemUpdateIDInterval;
    private long contentUpdateInterval;

    public ContentDirectory(MediaServer mserver) {
        this.setMediaServer(mserver);
        this.systemUpdateID = 0;
        this.maxContentID = 0;
        this.setSystemUpdateInterval(2000L);
        this.setContentUpdateInterval(60000L);
        this.initRootNode();
        this.initSortCaps();
        this.initSearchCaps();
    }

    private void setMediaServer(MediaServer mserver) {
        this.mediaServer = mserver;
    }

    public MediaServer getMediaServer() {
        return this.mediaServer;
    }

    public void lock() {
        this.mutex.lock();
    }

    public void unlock() {
        this.mutex.unlock();
    }

    public synchronized void updateSystemUpdateID() {
        ++this.systemUpdateID;
    }

    public synchronized int getSystemUpdateID() {
        return this.systemUpdateID;
    }

    private synchronized int getNextContentID() {
        ++this.maxContentID;
        return this.maxContentID;
    }

    public int getNextItemID() {
        return this.getNextContentID();
    }

    public int getNextContainerID() {
        return this.getNextContentID();
    }

    private void initRootNode() {
        this.rootNode = new RootNode();
        this.rootNode.setContentDirectory(this);
    }

    public RootNode getRootNode() {
        return this.rootNode;
    }

    private ContainerNode createContainerNode() {
        ContainerNode node = new ContainerNode();
        return node;
    }

    public boolean addPlugIn(Format format) {
        this.formatList.add(format);
        return true;
    }

    public Format getFormat(File file) {
        return this.formatList.getFormat(file);
    }

    public Format getFormat(int n) {
        return this.formatList.getFormat(n);
    }

    public int getNFormats() {
        return this.formatList.size();
    }

    public boolean addSortCap(SortCap sortCap) {
        this.sortCapList.add(sortCap);
        return true;
    }

    public int getNSortCaps() {
        return this.sortCapList.size();
    }

    public SortCap getSortCap(int n) {
        return this.sortCapList.getSortCap(n);
    }

    public SortCap getSortCap(String type) {
        return this.sortCapList.getSortCap(type);
    }

    private void initSortCaps() {
        this.addSortCap(new UPnPClassSortCap());
        this.addSortCap(new DCTitleSortCap());
        this.addSortCap(new DCDateSortCap());
    }

    private String getSortCapabilities() {
        Object sortCapsStr = "";
        int nSortCaps = this.getNSortCaps();
        for (int n = 0; n < nSortCaps; ++n) {
            SortCap sortCap = this.getSortCap(n);
            String type = sortCap.getType();
            if (0 < n) {
                sortCapsStr = (String)sortCapsStr + ",";
            }
            sortCapsStr = (String)sortCapsStr + type;
        }
        return sortCapsStr;
    }

    public boolean addSearchCap(SearchCap searchCap) {
        this.searchCapList.add(searchCap);
        return true;
    }

    public SearchCapList getSearchCapList() {
        return this.searchCapList;
    }

    public int getNSearchCaps() {
        return this.searchCapList.size();
    }

    public SearchCap getSearchCap(int n) {
        return this.searchCapList.getSearchCap(n);
    }

    public SearchCap getSearchCap(String type) {
        return this.searchCapList.getSearchCap(type);
    }

    private void initSearchCaps() {
        this.addSearchCap(new IdSearchCap());
        this.addSearchCap(new TitleSearchCap());
    }

    private String getSearchCapabilities() {
        Object searchCapsStr = "";
        int nSearchCaps = this.getNSearchCaps();
        for (int n = 0; n < nSearchCaps; ++n) {
            SearchCap searchCap = this.getSearchCap(n);
            String type = searchCap.getPropertyName();
            if (0 < n) {
                searchCapsStr = (String)searchCapsStr + ",";
            }
            searchCapsStr = (String)searchCapsStr + type;
        }
        return searchCapsStr;
    }

    private DirectoryList getDirectoryList() {
        return this.dirList;
    }

    public boolean addDirectory(Directory dir) {
        dir.setContentDirectory(this);
        dir.setID(this.getNextContainerID());
        dir.updateContentList();
        this.dirList.add(dir);
        this.rootNode.addContentNode(dir);
        this.updateSystemUpdateID();
        return true;
    }

    public boolean removeDirectory(String name) {
        Directory dirNode = this.dirList.getDirectory(name);
        if (dirNode == null) {
            return false;
        }
        this.dirList.remove((Object)dirNode);
        this.rootNode.removeNode(dirNode);
        this.updateSystemUpdateID();
        return true;
    }

    public boolean removeAllDirectories() {
        this.dirList.removeAllElements();
        return true;
    }

    public int getNDirectories() {
        return this.dirList.size();
    }

    public Directory getDirectory(int n) {
        return this.dirList.getDirectory(n);
    }

    public ContentNode findContentNodeByID(String id) {
        return this.getRootNode().findContentNodeByID(id);
    }

    public boolean actionControlReceived(Action action) {
        String actionName = action.getName();
        if (actionName.equals(BROWSE)) {
            BrowseAction browseAct = new BrowseAction(action);
            return this.browseActionReceived(browseAct);
        }
        if (actionName.equals(SEARCH)) {
            SearchAction searchAct = new SearchAction(action);
            return this.searchActionReceived(searchAct);
        }
        if (actionName.equals(GETSEARCHCAPABILITIES)) {
            Argument searchCapsArg = action.getArgument(SEARCHCAPS);
            String searchCapsStr = this.getSearchCapabilities();
            searchCapsArg.setValue(searchCapsStr);
            return true;
        }
        if (actionName.equals(GETSORTCAPABILITIES)) {
            Argument sortCapsArg = action.getArgument(SORTCAPS);
            String sortCapsStr = this.getSortCapabilities();
            sortCapsArg.setValue(sortCapsStr);
            return true;
        }
        if (actionName.equals(GETSYSTEMUPDATEID)) {
            Argument idArg = action.getArgument(ID);
            idArg.setValue(this.getSystemUpdateID());
            return true;
        }
        return false;
    }

    private boolean browseActionReceived(BrowseAction action) {
        if (action.isMetadata()) {
            return this.browseMetadataActionReceived(action);
        }
        if (action.isDirectChildren()) {
            return this.browseDirectChildrenActionReceived(action);
        }
        return false;
    }

    private boolean browseMetadataActionReceived(BrowseAction action) {
        String objID = action.getObjectID();
        ContentNode node = this.findContentNodeByID(objID);
        if (node == null) {
            return false;
        }
        DIDLLite didlLite = new DIDLLite();
        didlLite.setContentNode(node);
        String result = didlLite.toString();
        action.setArgumentValue(RESULT, result);
        action.setArgumentValue(NUMBERRETURNED, 1);
        action.setArgumentValue(TOTALMATCHES, 1);
        action.setArgumentValue(UPDATEID, this.getSystemUpdateID());
        if (Debug.isOn()) {
            action.print();
        }
        return true;
    }

    private void sortContentNodeList(ContentNode[] conNode, SortCap sortCap, boolean ascSeq) {
        int nConNode = conNode.length;
        for (int i = 0; i < nConNode - 1; ++i) {
            int selIdx = i;
            for (int j = i + 1; j < nConNode; ++j) {
                int cmpRet = sortCap.compare(conNode[selIdx], conNode[j]);
                if (ascSeq && cmpRet < 0) {
                    selIdx = j;
                }
                if (ascSeq || 0 >= cmpRet) continue;
                selIdx = j;
            }
            ContentNode conTmp = conNode[i];
            conNode[i] = conNode[selIdx];
            conNode[selIdx] = conTmp;
        }
    }

    private SortCriterionList getSortCriteriaArray(String sortCriteria) {
        SortCriterionList sortCriList = new SortCriterionList();
        StringTokenizer st = new StringTokenizer(sortCriteria, ", ");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            sortCriList.add(token);
        }
        return sortCriList;
    }

    private ContentNodeList sortContentNodeList(ContentNodeList contentNodeList, String sortCriteria) {
        if (sortCriteria == null || sortCriteria.length() <= 0) {
            return contentNodeList;
        }
        int nChildNodes = contentNodeList.size();
        ContentNode[] conNode = new ContentNode[nChildNodes];
        for (int n = 0; n < nChildNodes; ++n) {
            conNode[n] = contentNodeList.getContentNode(n);
        }
        SortCriterionList sortCritList = this.getSortCriteriaArray(sortCriteria);
        int nSortCrit = sortCritList.size();
        for (int n = 0; n < nSortCrit; ++n) {
            SortCap sortCap;
            String sortStr = sortCritList.getSortCriterion(n);
            Debug.message((String)("[" + n + "] = " + sortStr));
            boolean ascSeq = true;
            char firstSortChar = sortStr.charAt(0);
            if (firstSortChar == '-') {
                ascSeq = false;
            }
            if (firstSortChar == '+' || firstSortChar == '-') {
                sortStr = sortStr.substring(1);
            }
            if ((sortCap = this.getSortCap(sortStr)) == null) continue;
            Debug.message((String)("  ascSeq = " + ascSeq));
            Debug.message((String)("  sortCap = " + sortCap.getType()));
            this.sortContentNodeList(conNode, sortCap, ascSeq);
        }
        ContentNodeList sortedContentNodeList = new ContentNodeList();
        for (int n = 0; n < nChildNodes; ++n) {
            sortedContentNodeList.add(conNode[n]);
        }
        return sortedContentNodeList;
    }

    private boolean browseDirectChildrenActionReceived(BrowseAction action) {
        int requestedCount;
        String objID = action.getObjectID();
        ContentNode node = this.findContentNodeByID(objID);
        if (node == null || !node.isContainerNode()) {
            return false;
        }
        ContainerNode containerNode = (ContainerNode)node;
        ContentNodeList contentNodeList = new ContentNodeList();
        int nChildNodes = containerNode.getNContentNodes();
        for (int n = 0; n < nChildNodes; ++n) {
            ContentNode cnode = containerNode.getContentNode(n);
            contentNodeList.add(cnode);
        }
        String sortCriteria = action.getSortCriteria();
        ContentNodeList sortedContentNodeList = this.sortContentNodeList(contentNodeList, sortCriteria);
        int startingIndex = action.getStartingIndex();
        if (startingIndex <= 0) {
            startingIndex = 0;
        }
        if ((requestedCount = action.getRequestedCount()) == 0) {
            requestedCount = nChildNodes;
        }
        DIDLLite didlLite = new DIDLLite();
        int numberReturned = 0;
        for (int n = startingIndex; n < nChildNodes && numberReturned < requestedCount; ++numberReturned, ++n) {
            ContentNode cnode = sortedContentNodeList.getContentNode(n);
            didlLite.addContentNode(cnode);
            cnode.setParentID(objID);
        }
        String result = didlLite.toString();
        action.setResult(result);
        action.setNumberReturned(numberReturned);
        action.setTotalMaches(nChildNodes);
        action.setUpdateID(this.getSystemUpdateID());
        return true;
    }

    private SearchCriteriaList getSearchCriteriaList(String searchStr) {
        SearchCriteriaList searchList = new SearchCriteriaList();
        if (searchStr == null) {
            return searchList;
        }
        if (searchStr.compareTo("*") == 0) {
            return searchList;
        }
        StringTokenizer searchCriTokenizer = new StringTokenizer(searchStr, " \t\n\f\r");
        while (searchCriTokenizer.hasMoreTokens()) {
            String prop = searchCriTokenizer.nextToken();
            if (!searchCriTokenizer.hasMoreTokens()) break;
            String binOp = searchCriTokenizer.nextToken();
            if (!searchCriTokenizer.hasMoreTokens()) break;
            String value = searchCriTokenizer.nextToken();
            value = StringUtil.trim((String)value, (String)"\"");
            String logOp = "";
            if (searchCriTokenizer.hasMoreTokens()) {
                logOp = searchCriTokenizer.nextToken();
            }
            SearchCriteria searchCri = new SearchCriteria();
            searchCri.setProperty(prop);
            searchCri.setOperation(binOp);
            searchCri.setValue(value);
            searchCri.setLogic(logOp);
            searchList.add(searchCri);
        }
        return searchList;
    }

    private int getSearchContentList(ContainerNode node, SearchCriteriaList searchCriList, SearchCapList searchCapList, ContentNodeList contentNodeList) {
        if (searchCriList.compare(node, searchCapList)) {
            contentNodeList.add(node);
        }
        int nChildNodes = node.getNContentNodes();
        for (int n = 0; n < nChildNodes; ++n) {
            ContentNode cnode = node.getContentNode(n);
            if (!cnode.isContainerNode()) continue;
            this.getSearchContentList((ContainerNode)cnode, searchCriList, searchCapList, contentNodeList);
        }
        return contentNodeList.size();
    }

    private boolean searchActionReceived(SearchAction action) {
        int requestedCount;
        int n;
        String contaierID = action.getContainerID();
        ContentNode node = this.findContentNodeByID(contaierID);
        if (node == null || !node.isContainerNode()) {
            return false;
        }
        ContainerNode containerNode = (ContainerNode)node;
        String searchCriteria = action.getSearchCriteria();
        SearchCriteriaList searchCriList = this.getSearchCriteriaList(searchCriteria);
        SearchCapList searchCapList = this.getSearchCapList();
        ContentNodeList contentNodeList = new ContentNodeList();
        int nChildNodes = containerNode.getNContentNodes();
        for (n = 0; n < nChildNodes; ++n) {
            ContentNode cnode = containerNode.getContentNode(n);
            if (!cnode.isContainerNode()) continue;
            this.getSearchContentList((ContainerNode)cnode, searchCriList, searchCapList, contentNodeList);
        }
        nChildNodes = contentNodeList.size();
        String sortCriteria = action.getSortCriteria();
        ContentNodeList sortedContentNodeList = this.sortContentNodeList(contentNodeList, sortCriteria);
        int startingIndex = action.getStartingIndex();
        if (startingIndex <= 0) {
            startingIndex = 0;
        }
        if ((requestedCount = action.getRequestedCount()) == 0) {
            requestedCount = nChildNodes;
        }
        DIDLLite didlLite = new DIDLLite();
        int numberReturned = 0;
        for (n = startingIndex; n < nChildNodes && numberReturned < requestedCount; ++numberReturned, ++n) {
            ContentNode cnode = sortedContentNodeList.getContentNode(n);
            didlLite.addContentNode(cnode);
        }
        String result = didlLite.toString();
        action.setResult(result);
        action.setNumberReturned(numberReturned);
        action.setTotalMaches(nChildNodes);
        action.setUpdateID(this.getSystemUpdateID());
        return true;
    }

    public boolean queryControlReceived(StateVariable stateVar) {
        return false;
    }

    public void contentExportRequestRecieved(HTTPRequest httpReq) {
        String uri = httpReq.getURI();
        if (!uri.startsWith(CONTENT_EXPORT_URI)) {
            httpReq.returnBadRequest();
            return;
        }
        ParameterList paramList = httpReq.getParameterList();
        for (int n = 0; n < paramList.size(); ++n) {
            Parameter param = paramList.getParameter(n);
            Debug.message((String)("[" + param.getName() + "] = " + param.getValue()));
        }
        String id = paramList.getValue(CONTENT_ID);
        ContentNode node = this.findContentNodeByID(id);
        if (node == null) {
            httpReq.returnBadRequest();
            return;
        }
        if (!(node instanceof ItemNode)) {
            httpReq.returnBadRequest();
            return;
        }
        ItemNode itemNode = (ItemNode)node;
        long contentLen = itemNode.getContentLength();
        String contentType = itemNode.getMimeType();
        InputStream contentIn = itemNode.getContentInputStream();
        if (contentLen <= 0L || contentType.length() <= 0 || contentIn == null) {
            httpReq.returnBadRequest();
            return;
        }
        MediaServer mserver = this.getMediaServer();
        ConnectionManager conMan = mserver.getConnectionManager();
        int conID = conMan.getNextConnectionID();
        ConnectionInfo conInfo = new ConnectionInfo(conID);
        conInfo.setProtocolInfo(contentType);
        conInfo.setDirection("Output");
        conInfo.setStatus("OK");
        conMan.addConnectionInfo(conInfo);
        HTTPResponse httpRes = new HTTPResponse();
        httpRes.setContentType(contentType);
        httpRes.setStatusCode(200);
        httpRes.setContentLength(contentLen);
        httpRes.setContentInputStream(contentIn);
        httpReq.post(httpRes);
        try {
            contentIn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        conMan.removeConnectionInfo(conID);
    }

    public String getInterfaceAddress() {
        return this.getInterfaceAddress();
    }

    public int getHTTPPort() {
        return this.getHTTPPort();
    }

    public String getContentExportURL(String id) {
        return "http://" + this.getInterfaceAddress() + ":" + this.getHTTPPort() + "/ExportContent?id=" + id;
    }

    public String getContentImportURL(String id) {
        return "http://" + this.getInterfaceAddress() + ":" + this.getHTTPPort() + "/ImportContent?id=" + id;
    }

    public void setSystemUpdateInterval(long itime) {
        this.systemUpdateIDInterval = itime;
    }

    public long getSystemUpdateIDInterval() {
        return this.systemUpdateIDInterval;
    }

    public void setContentUpdateInterval(long itime) {
        this.contentUpdateInterval = itime;
    }

    public long getContentUpdateInterval() {
        return this.contentUpdateInterval;
    }

    public void run() {
        MediaServer mserver = this.getMediaServer();
        StateVariable varSystemUpdateID = mserver.getStateVariable(SYSTEMUPDATEID);
        int lastSystemUpdateID = 0;
        long lastContentUpdateTime = System.currentTimeMillis();
        while (this.isRunnable()) {
            try {
                Thread.sleep(this.getSystemUpdateIDInterval());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int currSystemUpdateID = this.getSystemUpdateID();
            if (lastSystemUpdateID != currSystemUpdateID) {
                varSystemUpdateID.setValue(currSystemUpdateID);
                lastSystemUpdateID = currSystemUpdateID;
            }
            long currTime = System.currentTimeMillis();
            if (this.getContentUpdateInterval() >= currTime - lastContentUpdateTime) continue;
            this.getDirectoryList().update();
            lastContentUpdateTime = currTime;
        }
    }
}

