/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.std.av.server.directory.file;

import java.io.File;
import org.cybergarage.upnp.std.av.server.Directory;
import org.cybergarage.upnp.std.av.server.object.ContentNode;
import org.cybergarage.upnp.std.av.server.object.Format;
import org.cybergarage.upnp.std.av.server.object.FormatObject;
import org.cybergarage.upnp.std.av.server.object.item.file.FileItemNode;
import org.cybergarage.upnp.std.av.server.object.item.file.FileItemNodeList;
import org.cybergarage.util.Debug;
import org.cybergarage.xml.AttributeList;

public class FileDirectory
extends Directory {
    private String path;

    public FileDirectory(String name, String path) {
        super(name);
        this.setPath(path);
    }

    public void setPath(String value) {
        this.path = value;
    }

    public String getPath() {
        return this.path;
    }

    private boolean updateItemNode(FileItemNode itemNode, File file) {
        String mediaClass;
        String creator;
        Format format = this.getContentDirectory().getFormat(file);
        if (format == null) {
            return false;
        }
        FormatObject formatObj = format.createObject(file);
        itemNode.setFile(file);
        String title = formatObj.getTitle();
        if (0 < title.length()) {
            itemNode.setTitle(title);
        }
        if (0 < (creator = formatObj.getCreator()).length()) {
            itemNode.setCreator(creator);
        }
        if (0 < (mediaClass = format.getMediaClass()).length()) {
            itemNode.setUPnPClass(mediaClass);
        }
        long lastModTime = file.lastModified();
        itemNode.setDate(lastModTime);
        try {
            long fileSize = file.length();
            itemNode.setStorageUsed(fileSize);
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
        }
        String mimeType = format.getMimeType();
        String protocol = "http-get:*:" + mimeType + ":*";
        String id = itemNode.getID();
        String url = this.getContentDirectory().getContentExportURL(id);
        AttributeList objAttrList = formatObj.getAttributeList();
        itemNode.setResource(url, protocol, objAttrList);
        this.getContentDirectory().updateSystemUpdateID();
        return true;
    }

    private FileItemNode createCompareItemNode(File file) {
        Format format = this.getContentDirectory().getFormat(file);
        if (format == null) {
            return null;
        }
        FileItemNode itemNode = new FileItemNode();
        itemNode.setFile(file);
        return itemNode;
    }

    private int getDirectoryItemNodeList(File dirFile, FileItemNodeList itemNodeList) {
        for (File file : dirFile.listFiles()) {
            FileItemNode itemNode;
            if (file.isDirectory()) {
                this.getDirectoryItemNodeList(file, itemNodeList);
                continue;
            }
            if (!file.isFile() || (itemNode = this.createCompareItemNode(file)) == null) continue;
            itemNodeList.add(itemNode);
        }
        return itemNodeList.size();
    }

    private FileItemNodeList getCurrentDirectoryItemNodeList() {
        FileItemNodeList itemNodeList = new FileItemNodeList();
        String path = this.getPath();
        File pathFile = new File(path);
        this.getDirectoryItemNodeList(pathFile, itemNodeList);
        return itemNodeList;
    }

    private FileItemNode getItemNode(File file) {
        int nContents = this.getNContentNodes();
        for (int n = 0; n < nContents; ++n) {
            FileItemNode itemNode;
            ContentNode cnode = this.getContentNode(n);
            if (!(cnode instanceof FileItemNode) || !(itemNode = (FileItemNode)cnode).equals(file)) continue;
            return itemNode;
        }
        return null;
    }

    private void addItemNode(FileItemNode itemNode) {
        this.addContentNode(itemNode);
    }

    private boolean updateItemNodeList(FileItemNode newItemNode) {
        long newTimeStamp;
        File newItemNodeFile = newItemNode.getFile();
        FileItemNode currItemNode = this.getItemNode(newItemNodeFile);
        if (currItemNode == null) {
            int newItemID = this.getContentDirectory().getNextItemID();
            newItemNode.setID(newItemID);
            this.updateItemNode(newItemNode, newItemNodeFile);
            this.addItemNode(newItemNode);
            return true;
        }
        long currTimeStamp = currItemNode.getFileTimeStamp();
        if (currTimeStamp == (newTimeStamp = newItemNode.getFileTimeStamp())) {
            return false;
        }
        this.updateItemNode(currItemNode, newItemNodeFile);
        return true;
    }

    private boolean updateItemNodeList() {
        int n;
        boolean updateFlag = false;
        int nContents = this.getNContentNodes();
        ContentNode[] cnode = new ContentNode[nContents];
        for (n = 0; n < nContents; ++n) {
            cnode[n] = this.getContentNode(n);
        }
        for (n = 0; n < nContents; ++n) {
            FileItemNode itemNode;
            File itemFile;
            if (!(cnode[n] instanceof FileItemNode) || (itemFile = (itemNode = (FileItemNode)cnode[n]).getFile()) == null || itemFile.exists()) continue;
            this.removeContentNode(cnode[n]);
            updateFlag = true;
        }
        FileItemNodeList itemNodeList = this.getCurrentDirectoryItemNodeList();
        int itemNodeCnt = itemNodeList.size();
        for (int n2 = 0; n2 < itemNodeCnt; ++n2) {
            FileItemNode itemNode = itemNodeList.getFileItemNode(n2);
            if (!this.updateItemNodeList(itemNode)) continue;
            updateFlag = true;
        }
        return updateFlag;
    }

    @Override
    public boolean update() {
        return this.updateItemNodeList();
    }
}

