/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.std.av.server.directory.gateway;

import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.DeviceList;
import org.cybergarage.upnp.std.av.controller.MediaController;
import org.cybergarage.upnp.std.av.player.MediaPlayer;
import org.cybergarage.upnp.std.av.server.Directory;
import org.cybergarage.upnp.std.av.server.object.ContentNode;
import org.cybergarage.upnp.std.av.server.object.container.ContainerNode;

public class GatewayDirectory
extends Directory {
    private static final String NAME = "CyberMediaGate";
    private MediaPlayer mplayer = new MediaPlayer();

    public GatewayDirectory(String name) {
        super(name);
        MediaPlayer mplayer = this.getMediaPlayer();
        mplayer.start();
    }

    public GatewayDirectory() {
        this(NAME);
    }

    public MediaPlayer getMediaPlayer() {
        return this.mplayer;
    }

    private boolean updateMediaServerList() {
        int n;
        boolean updateFlag = false;
        MediaPlayer dmp = this.getMediaPlayer();
        if (dmp == null) {
            return false;
        }
        MediaController controller = dmp.getController();
        if (controller == null) {
            return false;
        }
        DeviceList devList = controller.getDeviceList();
        int devCnt = devList.size();
        for (int n2 = 0; n2 < devCnt; ++n2) {
            Device dev = devList.getDevice(n2);
            if (!dev.isDeviceType("urn:schemas-upnp-org:device:MediaServer:1")) continue;
            System.out.println("[" + n2 + "] " + dev.getFriendlyName() + ", " + dev.getLeaseTime() + ", " + dev.getElapsedTime());
        }
        int nContents = this.getNContentNodes();
        ContentNode[] cnode = new ContentNode[nContents];
        for (n = 0; n < nContents; ++n) {
            cnode[n] = this.getContentNode(n);
        }
        for (n = 0; n < nContents; ++n) {
            String containerName = cnode[n].getName();
            if (controller.hasDevice(containerName)) continue;
            ContainerNode mserverNode = new ContainerNode();
            mserverNode.setName(containerName);
            this.addContentNode(mserverNode);
        }
        return updateFlag;
    }

    @Override
    public boolean update() {
        return this.updateMediaServerList();
    }
}

