/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.std.av.server.directory.mythtv;

import org.cybergarage.upnp.std.av.server.Directory;
import org.cybergarage.upnp.std.av.server.directory.mythtv.MythDatabase;
import org.cybergarage.upnp.std.av.server.directory.mythtv.MythRecordedInfo;
import org.cybergarage.upnp.std.av.server.object.item.mythtv.MythRecordedItemNode;
import org.cybergarage.util.Debug;

public class MythDirectory
extends Directory {
    private static final String NAME = "MythTV";

    public MythDirectory(String name) {
        super(name);
    }

    public MythDirectory() {
        this(NAME);
    }

    private MythRecordedItemNode[] getAddedRecordedItemNodes() {
        int nContents = this.getNContentNodes();
        MythRecordedItemNode[] recNode = new MythRecordedItemNode[nContents];
        for (int n = 0; n < nContents; ++n) {
            recNode[n] = (MythRecordedItemNode)this.getContentNode(n);
        }
        return recNode;
    }

    private MythRecordedInfo[] getCurrentRecordedInfos() {
        MythDatabase mythdb = new MythDatabase();
        mythdb.open();
        MythRecordedInfo[] recInfo = mythdb.getRecordedInfos();
        mythdb.close();
        return recInfo;
    }

    @Override
    public boolean update() {
        boolean hasRecItem;
        boolean updateFlag = false;
        MythRecordedItemNode[] addedItemNode = this.getAddedRecordedItemNodes();
        MythRecordedInfo[] currRecInfo = this.getCurrentRecordedInfos();
        int nAddedItems = addedItemNode.length;
        int nCurrRecInfos = currRecInfo.length;
        for (int i = 0; i < nAddedItems; ++i) {
            MythRecordedItemNode recItem = addedItemNode[i];
            hasRecItem = false;
            for (int j = 0; j < nCurrRecInfos; ++j) {
                MythRecordedInfo recInfo = currRecInfo[j];
                if (!recItem.equals(recInfo)) continue;
                hasRecItem = true;
                break;
            }
            if (hasRecItem) continue;
            this.removeContentNode(recItem);
            updateFlag = true;
        }
        for (int j = 0; j < nCurrRecInfos; ++j) {
            MythRecordedInfo recInfo = currRecInfo[j];
            hasRecItem = false;
            for (int i = 0; i < nAddedItems; ++i) {
                MythRecordedItemNode recItem = addedItemNode[i];
                if (!recItem.equals(recInfo)) continue;
                hasRecItem = true;
                break;
            }
            if (hasRecItem) continue;
            MythRecordedItemNode recItem = new MythRecordedItemNode();
            int newItemID = this.getContentDirectory().getNextItemID();
            recItem.setID(newItemID);
            recItem.setContentDirectory(this.getContentDirectory());
            recItem.setRecordedInfo(recInfo);
            this.addContentNode(recItem);
            updateFlag = true;
        }
        return updateFlag;
    }

    public static void main(String[] args) {
        Debug.on();
        MythDirectory mythdir = new MythDirectory();
        mythdir.update();
    }
}

