/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.std.av.server.object;

import java.io.PrintWriter;
import org.cybergarage.upnp.std.av.server.ContentDirectory;
import org.cybergarage.upnp.std.av.server.MediaServer;
import org.cybergarage.upnp.std.av.server.object.ContentProperty;
import org.cybergarage.upnp.std.av.server.object.ContentPropertyList;
import org.cybergarage.upnp.std.av.server.object.container.ContainerNode;
import org.cybergarage.upnp.std.av.server.object.item.ItemNode;
import org.cybergarage.xml.Attribute;
import org.cybergarage.xml.Node;

public abstract class ContentNode
extends Node {
    public static final String ID = "id";
    public static final String PARENT_ID = "parentID";
    public static final String RESTRICTED = "restricted";
    public static final String UNKNOWN = "UNKNOWN";
    private ContentDirectory contentDir;
    private ContentPropertyList propList = new ContentPropertyList();

    public ContentNode() {
        this.setID(0);
        this.setParentID(-1);
        this.setRestricted(1);
        this.setContentDirectory(null);
    }

    public void setContentDirectory(ContentDirectory cdir) {
        this.contentDir = cdir;
    }

    public ContentDirectory getContentDirectory() {
        return this.contentDir;
    }

    public MediaServer getMediaServer() {
        return this.getContentDirectory().getMediaServer();
    }

    public boolean isContainerNode() {
        return this instanceof ContainerNode;
    }

    public boolean isItemNode() {
        return this instanceof ItemNode;
    }

    public int getNProperties() {
        return this.propList.size();
    }

    public ContentProperty getProperty(int index) {
        return this.propList.getContentProperty(index);
    }

    public ContentProperty getProperty(String name) {
        return this.propList.getContentProperty(name);
    }

    public void addProperty(ContentProperty prop) {
        this.propList.add(prop);
    }

    public void insertPropertyAt(ContentProperty prop, int index) {
        this.propList.insertElementAt(prop, index);
    }

    public void addProperty(String name, String value) {
        ContentProperty prop = new ContentProperty(name, value);
        this.addProperty(prop);
    }

    public boolean removeProperty(ContentProperty prop) {
        return this.propList.remove(prop);
    }

    public boolean removeProperty(String name) {
        return this.removeProperty(this.getProperty(name));
    }

    public boolean hasProperties() {
        return 0 < this.getNProperties();
    }

    public void setProperty(String name, String value) {
        ContentProperty prop = this.getProperty(name);
        if (prop != null) {
            prop.setValue(value);
            return;
        }
        prop = new ContentProperty(name, value);
        this.addProperty(prop);
    }

    public void setProperty(String name, int value) {
        this.setProperty(name, Integer.toString(value));
    }

    public void setProperty(String name, long value) {
        this.setProperty(name, Long.toString(value));
    }

    public String getPropertyValue(String name) {
        ContentProperty prop = this.getProperty(name);
        if (prop != null) {
            return prop.getValue();
        }
        return "";
    }

    public int getPropertyIntegerValue(String name) {
        String val = this.getPropertyValue(name);
        try {
            return Integer.parseInt(val);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public long getPropertyLongValue(String name) {
        String val = this.getPropertyValue(name);
        try {
            return Long.parseLong(val);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public void setPropertyAttribure(String propName, String attrName, String value) {
        ContentProperty prop = this.getProperty(propName);
        if (prop == null) {
            prop = new ContentProperty(propName, "");
            this.addProperty(prop);
        }
        prop.setAttribute(attrName, value);
    }

    public String getPropertyAttribureValue(String propName, String attrName) {
        ContentProperty prop = this.getProperty(propName);
        if (prop != null) {
            return prop.getAttributeValue(attrName);
        }
        return "";
    }

    public abstract boolean set(Node var1);

    public void setID(int id) {
        this.setAttribute(ID, id);
    }

    public void setID(String id) {
        this.setAttribute(ID, id);
    }

    public String getID() {
        return this.getAttributeValue(ID);
    }

    public void setParentID(int id) {
        this.setAttribute(PARENT_ID, id);
    }

    public void setParentID(String id) {
        this.setAttribute(PARENT_ID, id);
    }

    public String getParentID() {
        return this.getAttributeValue(PARENT_ID);
    }

    public void setRestricted(int id) {
        this.setAttribute(RESTRICTED, id);
    }

    public int getRestricted() {
        return this.getAttributeIntegerValue(RESTRICTED);
    }

    public void setTitle(String title) {
        this.setProperty("dc:title", title);
    }

    public String getTitle() {
        return this.getPropertyValue("dc:title");
    }

    public void setUPnPClass(String title) {
        this.setProperty("upnp:class", title);
    }

    public String getUPnPClass() {
        return this.getPropertyValue("upnp:class");
    }

    public boolean isUPnPClassStartWith(String targetClass) {
        if (targetClass == null) {
            return false;
        }
        String upnpClass = this.getUPnPClass();
        if (upnpClass == null) {
            return false;
        }
        return upnpClass.startsWith(targetClass);
    }

    public void setWriteStatus(String status) {
        this.setProperty("upnp:writeStatus", status);
    }

    public String getWriteStatus() {
        return this.getPropertyValue("upnp:writeStatus");
    }

    private void outputPropertyAttributes(PrintWriter ps, ContentProperty prop) {
        int nAttributes = prop.getNAttributes();
        for (int n = 0; n < nAttributes; ++n) {
            Attribute attr = prop.getAttribute(n);
            ps.print(" " + attr.getName() + "=\"" + attr.getValue() + "\"");
        }
    }

    public void output(PrintWriter ps, int indentLevel, boolean hasChildNode) {
        String indentString = this.getIndentLevelString(indentLevel);
        String name = this.getName();
        String value = this.getValue();
        if (!this.hasNodes() && !this.hasProperties()) {
            ps.print(indentString + "<" + name);
            this.outputAttributes(ps);
            ps.println(">" + value + "</" + name + ">");
            return;
        }
        ps.print(indentString + "<" + name);
        this.outputAttributes(ps);
        ps.println(">");
        int nProps = this.getNProperties();
        for (int n = 0; n < nProps; ++n) {
            String propIndentString = this.getIndentLevelString(indentLevel + 1);
            ContentProperty prop = this.getProperty(n);
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (prop.hasAttributes()) {
                ps.print(propIndentString + "<" + propName);
                this.outputPropertyAttributes(ps, prop);
                ps.println(">" + propValue + "</" + propName + ">");
                continue;
            }
            ps.println(propIndentString + "<" + propName + ">" + propValue + "</" + propName + ">");
        }
        if (hasChildNode) {
            int nChildNodes = this.getNNodes();
            for (int n = 0; n < nChildNodes; ++n) {
                Node cnode = this.getNode(n);
                cnode.output(ps, indentLevel + 1, true);
            }
        }
        ps.println(indentString + "</" + name + ">");
    }
}

