/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.std.av.server.object;

import org.cybergarage.xml.Attribute;
import org.cybergarage.xml.AttributeList;

public class ContentProperty {
    private String name = new String();
    private String value = new String();
    private AttributeList attrList = new AttributeList();

    public ContentProperty() {
    }

    public ContentProperty(String name, String value) {
        this.setName(name);
        this.setValue(value);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public int getNAttributes() {
        return this.attrList.size();
    }

    public Attribute getAttribute(int index) {
        return this.attrList.getAttribute(index);
    }

    public Attribute getAttribute(String name) {
        return this.attrList.getAttribute(name);
    }

    public void addAttribute(Attribute attr) {
        this.attrList.add((Object)attr);
    }

    public void insertAttributeAt(Attribute attr, int index) {
        this.attrList.insertElementAt((Object)attr, index);
    }

    public void addAttribute(String name, String value) {
        Attribute attr = new Attribute(name, value);
        this.addAttribute(attr);
    }

    public boolean removeAttribute(Attribute attr) {
        return this.attrList.remove((Object)attr);
    }

    public boolean removeAttribute(String name) {
        return this.removeAttribute(this.getAttribute(name));
    }

    public boolean hasAttributes() {
        return 0 < this.getNAttributes();
    }

    public void setAttribute(String name, String value) {
        Attribute attr = this.getAttribute(name);
        if (attr != null) {
            attr.setValue(value);
            return;
        }
        attr = new Attribute(name, value);
        this.addAttribute(attr);
    }

    public void setAttribute(String name, int value) {
        this.setAttribute(name, Integer.toString(value));
    }

    public String getAttributeValue(String name) {
        Attribute attr = this.getAttribute(name);
        if (attr != null) {
            return attr.getValue();
        }
        return "";
    }

    public int getAttributeIntegerValue(String name) {
        String val = this.getAttributeValue(name);
        try {
            return Integer.parseInt(val);
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

