/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.std.av.server.object;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.cybergarage.upnp.std.av.server.object.ContentNode;
import org.cybergarage.upnp.std.av.server.object.ContentNodeList;
import org.cybergarage.upnp.std.av.server.object.DIDLLiteNode;
import org.cybergarage.util.Debug;

public class DIDLLite {
    public static final String NAME = "DIDL-Lite";
    public static final String XMLNS = "xmlns";
    public static final String XMLNS_URL = "urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/";
    public static final String XMLNS_DC = "xmlns:dc";
    public static final String XMLNS_DC_URL = "http://purl.org/dc/elements/1.1/";
    public static final String XMLNS_UPNP = "xmlns:upnp";
    public static final String XMLNS_UPNP_URL = "urn:schemas-upnp-org:metadata-1-0/upnp/";
    public static final String CONTAINER = "container";
    public static final String ID = "id";
    public static final String SEARCHABLE = "searchable";
    public static final String PARENTID = "parentID";
    public static final String RESTICTED = "restricted";
    public static final String OBJECT_CONTAINER = "object.container";
    public static final String RES = "res";
    public static final String RES_PROTOCOLINFO = "protocolInfo";
    private ContentNodeList nodeList = new ContentNodeList();

    public void setContentNode(ContentNode node) {
        this.nodeList.clear();
        this.nodeList.add(node);
    }

    public void addContentNode(ContentNode node) {
        this.nodeList.add(node);
    }

    public int getNContentNodes() {
        return this.nodeList.size();
    }

    public ContentNode getContentNode(int n) {
        return this.nodeList.getContentNode(n);
    }

    public void output(PrintWriter ps) {
        ps.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        DIDLLiteNode didlNode = new DIDLLiteNode();
        String name = didlNode.getName();
        ps.print("<" + name);
        didlNode.outputAttributes(ps);
        ps.println(">");
        int nNodes = this.getNContentNodes();
        for (int n = 0; n < nNodes; ++n) {
            ContentNode contentNode = this.getContentNode(n);
            contentNode.output(ps, 1, false);
        }
        ps.println("</" + name + ">");
    }

    public String toString() {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)byteOut, "UTF-8");
            PrintWriter pr = new PrintWriter(writer);
            this.output(pr);
            pr.flush();
            return byteOut.toString();
        }
        catch (UnsupportedEncodingException e) {
            Debug.warning((Exception)e);
            return "";
        }
    }
}

