/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.std.av.server.object.container;

import org.cybergarage.upnp.std.av.server.object.ContentNode;
import org.cybergarage.upnp.std.av.server.object.item.ItemNode;
import org.cybergarage.xml.Attribute;
import org.cybergarage.xml.Node;

public class ContainerNode
extends ContentNode {
    public static final String NAME = "container";
    public static final String CHILD_COUNT = "childCount";
    public static final String SEARCHABLE = "searchable";
    public static final String OBJECT_CONTAINER = "object.container";

    public ContainerNode() {
        this.setID(-1);
        this.setName(NAME);
        this.setSearchable(0);
        this.setChildCount(0);
        this.setUPnPClass(OBJECT_CONTAINER);
        this.setWriteStatus("UNKNOWN");
    }

    public static final boolean isContainerNode(Node node) {
        String name = node.getName();
        if (name == null) {
            return false;
        }
        return name.equals(NAME);
    }

    @Override
    public boolean set(Node node) {
        int nNode = node.getNNodes();
        for (int n = 0; n < nNode; ++n) {
            Node cnode = node.getNode(n);
            if (ContainerNode.isContainerNode(cnode) || ItemNode.isItemNode(cnode)) continue;
            this.setProperty(cnode.getName(), cnode.getValue());
        }
        int nAttr = node.getNAttributes();
        for (int n = 0; n < nAttr; ++n) {
            Attribute attr = node.getAttribute(n);
            this.setAttribute(attr.getName(), attr.getValue());
        }
        return true;
    }

    public boolean hasContentNodes() {
        return this.hasNodes();
    }

    public int getNContentNodes() {
        return this.getNNodes();
    }

    public ContentNode getContentNode(int index) {
        return (ContentNode)this.getNode(index);
    }

    public ContentNode getContentNode(String name) {
        return (ContentNode)this.getNode(name);
    }

    public void removeAllContentNodes() {
        this.removeAllNodes();
    }

    public void addContentNode(ContentNode node) {
        this.addNode(node);
        node.setParentID(this.getID());
        this.setChildCount(this.getNContentNodes());
        node.setContentDirectory(this.getContentDirectory());
    }

    public boolean removeContentNode(ContentNode node) {
        boolean ret = this.removeNode(node);
        this.setChildCount(this.getNContentNodes());
        return ret;
    }

    public ContentNode findContentNodeByID(String id) {
        if (id == null) {
            return null;
        }
        String nodeID = this.getID();
        if (id.equals(nodeID)) {
            return this;
        }
        int nodeCnt = this.getNContentNodes();
        for (int n = 0; n < nodeCnt; ++n) {
            ContentNode fnode;
            ContentNode cnode = this.getContentNode(n);
            if (!cnode.isContainerNode() || (fnode = ((ContainerNode)cnode).findContentNodeByID(id)) == null) continue;
            return fnode;
        }
        return null;
    }

    public void setChildCount(int id) {
        this.setAttribute(CHILD_COUNT, id);
    }

    public int getChildCount() {
        return this.getAttributeIntegerValue(CHILD_COUNT);
    }

    public void setSearchable(int value) {
        this.setAttribute(SEARCHABLE, value);
    }

    public int getSearchable() {
        return this.getAttributeIntegerValue(SEARCHABLE);
    }
}

