/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.std.av.server.object.format;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.cybergarage.util.Debug;

public abstract class Header {
    public static final byte[] getID(InputStream inputStream, int headerOffset, int headerSize) {
        int headerCnt = headerOffset + headerSize;
        byte[] header = new byte[headerCnt];
        try {
            DataInputStream dataIn = new DataInputStream(inputStream);
            for (int n = 0; n < headerCnt; ++n) {
                byte readByte = dataIn.readByte();
                if (n < headerOffset) continue;
                header[n - headerOffset] = readByte;
            }
            dataIn.close();
        }
        catch (EOFException dataIn) {
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
        }
        return header;
    }

    public static final byte[] getID(InputStream inputStream, int headerSize) {
        return Header.getID(inputStream, 0, headerSize);
    }

    public static final String getIDString(InputStream inputStream, int headerOffset, int headerSize) {
        return new String(Header.getID(inputStream, headerOffset, headerSize));
    }

    public static final String getIDString(InputStream inputStream, int headerSize) {
        return new String(Header.getID(inputStream, headerSize));
    }

    public static final byte[] getID(File file, int headerSize) {
        try {
            return Header.getID(new FileInputStream(file), headerSize);
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
            return new byte[0];
        }
    }

    public static final String getIDString(File file, int headerOffset, int headerSize) {
        try {
            return Header.getIDString(new FileInputStream(file), headerOffset, headerSize);
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
            return "";
        }
    }

    public static final String getIDString(File file, int headerSize) {
        return Header.getIDString(file, 0, headerSize);
    }

    public static final String getSuffix(File file) {
        String fname = file.getName();
        int idx = fname.lastIndexOf(".");
        if (idx < 0) {
            return "";
        }
        return fname.substring(idx + 1, fname.length());
    }
}

