/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.std.av.server.object.format;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.cybergarage.upnp.std.av.server.object.Format;
import org.cybergarage.upnp.std.av.server.object.FormatObject;
import org.cybergarage.upnp.std.av.server.object.format.Header;
import org.cybergarage.upnp.std.av.server.object.format.ID3Frame;
import org.cybergarage.upnp.std.av.server.object.format.ID3FrameList;
import org.cybergarage.util.Debug;
import org.cybergarage.xml.Attribute;
import org.cybergarage.xml.AttributeList;

public class ID3Format
extends Header
implements Format,
FormatObject {
    public static final String HEADER_ID = "ID3";
    public static final int HEADER_SIZE = 10;
    public static final int FRAME_HEADER_SIZE = 10;
    private byte[] header = new byte[10];
    private byte[] extHeader = new byte[4];
    private byte[] frameHeader = new byte[10];
    private ID3FrameList frameList = new ID3FrameList();
    private File mp3File;

    public ID3Format() {
        this.mp3File = null;
    }

    public ID3Format(File file) {
        this.mp3File = file;
        this.loadHeader(file);
    }

    public boolean loadHeader(InputStream inputStream) {
        try {
            int frameSize;
            int n;
            DataInputStream dataIn = new DataInputStream(inputStream);
            for (n = 0; n < 10; ++n) {
                this.header[n] = dataIn.readByte();
            }
            if (this.hasExtendedHeader()) {
                for (n = 0; n < 4; ++n) {
                    this.header[n] = dataIn.readByte();
                }
                int extHeaderSize = this.getExtHeaderSize();
                for (int n2 = 0; n2 < extHeaderSize - 4; ++n2) {
                    dataIn.readByte();
                }
            }
            this.frameList.clear();
            int frameDataSize = this.getHeaderSize() - 10;
            if (this.hasExtendedHeader()) {
                frameDataSize -= this.getExtHeaderSize();
            }
            for (int frameDataCnt = 0; frameDataCnt < frameDataSize; frameDataCnt += frameSize + 10) {
                for (int n3 = 0; n3 < 10; ++n3) {
                    this.frameHeader[n3] = dataIn.readByte();
                }
                String frameID = this.getFrameID(this.frameHeader);
                frameSize = this.getFrameSize(this.frameHeader);
                int frameFlag = this.getFrameFlag(this.frameHeader);
                byte[] frameData = new byte[frameSize];
                for (int i = 0; i < frameSize; ++i) {
                    frameData[i] = dataIn.readByte();
                }
                ID3Frame frame = new ID3Frame();
                frame.setID(frameID);
                frame.setSize(frameSize);
                frame.setFlag(frameFlag);
                frame.setData(frameData);
                this.frameList.add(frame);
            }
            dataIn.close();
        }
        catch (EOFException dataIn) {
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
            return false;
        }
        return true;
    }

    public boolean loadHeader(File file) {
        try {
            return this.loadHeader(new FileInputStream(file));
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
            return false;
        }
    }

    public boolean hasHeader() {
        String id = this.getHeaderID();
        if (id == null) {
            return false;
        }
        return id.equals(HEADER_ID);
    }

    public String getHeaderID() {
        return new String(this.header, 0, 3);
    }

    public int getHeaderSize() {
        int size = 0;
        for (int n = 0; n < 4; ++n) {
            size += (this.header[9 - n] & 0xFF) << n;
        }
        return size;
    }

    public int getFlag() {
        return this.header[5] & 0xFF;
    }

    public boolean isUnsynchronisation() {
        return (this.getFlag() & 0x80) == 1;
    }

    public boolean hasExtendedHeader() {
        return (this.getFlag() & 0x40) == 1;
    }

    public boolean isExperimental() {
        return (this.getFlag() & 0x20) == 1;
    }

    public boolean hasFooter() {
        return (this.getFlag() & 0x10) == 1;
    }

    public int getExtHeaderSize() {
        int size = 0;
        for (int n = 0; n < 4; ++n) {
            size += (this.extHeader[3 - n] & 0xFF) << n;
        }
        return size;
    }

    private String getFrameID(byte[] frameHeader) {
        return new String(frameHeader, 0, 4);
    }

    private int getFrameSize(byte[] frameHeader) {
        int size = 0;
        for (int n = 0; n < 4; ++n) {
            size += (frameHeader[7 - n] & 0xFF) << n;
        }
        return size;
    }

    private int getFrameFlag(byte[] frameHeader) {
        return ((frameHeader[8] & 0xFF) << 8) + (frameHeader[9] & 0xFF);
    }

    public byte[] getFrameData(String name) {
        return this.frameList.getFrameData(name);
    }

    public String getFrameStringData(String name) {
        return this.frameList.getFrameStringData(name);
    }

    @Override
    public boolean equals(File file) {
        String headerID = Header.getIDString(file, 3);
        return headerID.startsWith(HEADER_ID);
    }

    @Override
    public FormatObject createObject(File file) {
        return new ID3Format(file);
    }

    @Override
    public String getMimeType() {
        return "audio/mpeg";
    }

    @Override
    public String getMediaClass() {
        return "object.item.audioItem.musicTrack";
    }

    @Override
    public AttributeList getAttributeList() {
        AttributeList attrList = new AttributeList();
        long fsize = this.mp3File.length();
        Attribute sizeStr = new Attribute("size", Long.toString(fsize));
        attrList.add((Object)sizeStr);
        return attrList;
    }

    @Override
    public String getTitle() {
        String title = this.getFrameStringData("TIT2");
        if (0 < title.length()) {
            return title;
        }
        title = this.getFrameStringData("TIT1");
        if (0 < title.length()) {
            return title;
        }
        return this.getFrameStringData("TIT2");
    }

    @Override
    public String getCreator() {
        String creator = this.getFrameStringData("TPE1");
        if (0 < creator.length()) {
            return creator;
        }
        creator = this.getFrameStringData("TPE2");
        if (0 < creator.length()) {
            return creator;
        }
        creator = this.getFrameStringData("TPE3");
        if (0 < creator.length()) {
            return creator;
        }
        return this.getFrameStringData("TPE4");
    }

    public void print() {
        String headerStr = new String(this.header);
        System.out.println("header = " + headerStr);
        System.out.println("ID = " + this.getHeaderID());
        System.out.println("Size = " + this.getHeaderSize());
        System.out.println("isUnsynchronisation = " + this.isUnsynchronisation());
        System.out.println("hasExtendedHeader = " + this.hasExtendedHeader());
        System.out.println("isExperimental = " + this.isExperimental());
        System.out.println("hasFooter = " + this.hasFooter());
        int frameCnt = this.frameList.size();
        for (int n = 0; n < frameCnt; ++n) {
            ID3Frame frame = this.frameList.getFrame(n);
            System.out.println("[" + n + "] : " + frame.getID());
            System.out.println("     " + frame.getData());
        }
    }
}

