/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.std.av.server.object.format;

import java.io.File;
import org.cybergarage.upnp.std.av.server.object.Format;
import org.cybergarage.upnp.std.av.server.object.FormatObject;
import org.cybergarage.upnp.std.av.server.object.format.Header;
import org.cybergarage.util.Debug;
import org.cybergarage.xml.Attribute;
import org.cybergarage.xml.AttributeList;

public class MPEGFormat
implements Format,
FormatObject {
    private File mpegFile;

    public MPEGFormat() {
    }

    public MPEGFormat(File file) {
        this.mpegFile = file;
    }

    @Override
    public boolean equals(File file) {
        String ext = Header.getSuffix(file);
        if (ext == null) {
            return false;
        }
        return ext.startsWith("mpeg") || ext.startsWith("mpg");
    }

    @Override
    public FormatObject createObject(File file) {
        return new MPEGFormat(file);
    }

    @Override
    public String getMimeType() {
        return "video/mpeg";
    }

    @Override
    public String getMediaClass() {
        return "object.item.videoItem.movie";
    }

    @Override
    public AttributeList getAttributeList() {
        AttributeList attrList = new AttributeList();
        try {
            long fsize = this.mpegFile.length();
            Attribute sizeStr = new Attribute("size", Long.toString(fsize));
            attrList.add((Object)sizeStr);
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
        }
        return attrList;
    }

    @Override
    public String getTitle() {
        String fname = this.mpegFile.getName();
        int idx = fname.lastIndexOf(".");
        if (idx < 0) {
            return "";
        }
        String title = fname.substring(0, idx);
        return title;
    }

    @Override
    public String getCreator() {
        return "";
    }
}

