/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.std.av.server.object.item;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.cybergarage.upnp.std.av.server.object.ContentNode;
import org.cybergarage.upnp.std.av.server.object.container.ContainerNode;
import org.cybergarage.upnp.std.av.server.object.item.ResourceNode;
import org.cybergarage.upnp.std.av.server.object.item.ResourceNodeList;
import org.cybergarage.util.Debug;
import org.cybergarage.xml.Attribute;
import org.cybergarage.xml.AttributeList;
import org.cybergarage.xml.Node;

public class ItemNode
extends ContentNode {
    public static final String NAME = "item";
    public static final String RES = "res";
    public static final String PROTOCOL_INFO = "protocolInfo";
    public static final String SIZE = "size";
    public static final String IMPORT_URI = "importUri";
    public static final String COLOR_DEPTH = "colorDepth";
    public static final String RESOLUTION = "resolution";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private ResourceNodeList resourceNodeList = new ResourceNodeList();

    public ItemNode() {
        this.setID(-1);
        this.setName(NAME);
        this.setStorageMedium("UNKNOWN");
        this.setWriteStatus("UNKNOWN");
    }

    public static final boolean isItemNode(Node node) {
        String name = node.getName();
        if (name == null) {
            return false;
        }
        return name.equals(NAME);
    }

    @Override
    public boolean set(Node node) {
        int nNode = node.getNNodes();
        for (int n = 0; n < nNode; ++n) {
            Node cnode = node.getNode(n);
            if (ContainerNode.isContainerNode(cnode) || ItemNode.isItemNode(cnode)) continue;
            if (ResourceNode.isResourceNode(cnode)) {
                ResourceNode resNode = new ResourceNode();
                resNode.set(cnode);
                this.addResourceNode(resNode);
                continue;
            }
            this.setProperty(cnode.getName(), cnode.getValue());
        }
        int nAttr = node.getNAttributes();
        for (int n = 0; n < nAttr; ++n) {
            Attribute attr = node.getAttribute(n);
            this.setAttribute(attr.getName(), attr.getValue());
        }
        return true;
    }

    public void addContentNode(ContentNode node) {
        this.addNode(node);
        node.setParentID(this.getID());
        node.setContentDirectory(this.getContentDirectory());
    }

    public boolean removeContentNode(ContentNode node) {
        return this.removeNode(node);
    }

    public void setDate(String value) {
        this.setProperty("dc:date", value);
    }

    public String getDate() {
        return this.getPropertyValue("dc:date");
    }

    public void setDate(long dateTime) {
        try {
            Date date = new Date(dateTime);
            SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
            String dateStr = df.format(date);
            this.setDate(dateStr);
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
        }
    }

    public long getDateTime() {
        String dateStr = this.getDate();
        if (dateStr == null || dateStr.length() < 10) {
            return 0L;
        }
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        try {
            Date date = df.parse(dateStr);
            return date.getTime();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public void setCreator(String name) {
        this.setProperty("dc:creator", name);
    }

    public String getCreator() {
        return this.getPropertyValue("dc:creator");
    }

    public void setStorageMedium(String value) {
        this.setProperty("upnp:storageMedium", value);
    }

    public String getStorageMedium() {
        return this.getPropertyValue("upnp:storageMedium");
    }

    public void setStorageUsed(long value) {
        this.setProperty("upnp:storageUsed", value);
    }

    public long getStorageUsed() {
        return this.getPropertyLongValue("upnp:storageUsed");
    }

    public void setAlbumArtURI(String value) {
        this.setProperty("upnp:albumArtURI", value);
    }

    public String getAlbumArtURI() {
        return this.getPropertyValue("upnp:albumArtURI");
    }

    public boolean isMovieClass() {
        return this.isUPnPClassStartWith("object.item.movie") || this.isUPnPClassStartWith("object.item.video");
    }

    public boolean isVideoClass() {
        return this.isMovieClass();
    }

    public boolean isAudioClass() {
        return this.isUPnPClassStartWith("object.item.audio") || this.isUPnPClassStartWith("object.item.music");
    }

    public boolean isImageClass() {
        return this.isUPnPClassStartWith("object.item.image") || this.isUPnPClassStartWith("object.item.photo");
    }

    public void addResourceNode(ResourceNode resNode) {
        this.resourceNodeList.add(resNode);
    }

    public ResourceNodeList getResourceNodeList() {
        return this.resourceNodeList;
    }

    public int getNResourceNodeLists() {
        return this.resourceNodeList.size();
    }

    public ResourceNode getResourceNode(int n) {
        return this.resourceNodeList.getResourceNode(n);
    }

    public ResourceNode getFirstResource() {
        int nProperties = this.getNResourceNodeLists();
        for (int n = 0; n < nProperties; ++n) {
            ResourceNode resNode = this.getResourceNode(n);
            if (resNode.isThumbnail()) continue;
            return resNode;
        }
        return null;
    }

    public ResourceNode getThumbnailResource() {
        int nProperties = this.getNResourceNodeLists();
        for (int n = 0; n < nProperties; ++n) {
            ResourceNode resNode = this.getResourceNode(n);
            if (!resNode.isThumbnail()) continue;
            return resNode;
        }
        return null;
    }

    public ResourceNode getSmallImageResource() {
        int nProperties = this.getNResourceNodeLists();
        for (int n = 0; n < nProperties; ++n) {
            ResourceNode resNode = this.getResourceNode(n);
            if (!resNode.isSmallImage()) continue;
            return resNode;
        }
        return null;
    }

    public void setResource(String url, String protocolInfo, AttributeList attrList) {
        this.setProperty(RES, url);
        this.setPropertyAttribure(RES, PROTOCOL_INFO, protocolInfo);
        int attrCnt = attrList.size();
        for (int n = 0; n < attrCnt; ++n) {
            Attribute attr = attrList.getAttribute(n);
            String name = attr.getName();
            String value = attr.getValue();
            this.setPropertyAttribure(RES, name, value);
        }
    }

    public void setResource(String url, String protocolInfo) {
        this.setResource(url, protocolInfo, new AttributeList());
    }

    public String getResource() {
        return this.getPropertyValue(RES);
    }

    public String getProtocolInfo() {
        return this.getPropertyAttribureValue(RES, PROTOCOL_INFO);
    }

    public long getContentLength() {
        return 0L;
    }

    public InputStream getContentInputStream() {
        return null;
    }

    public String getMimeType() {
        return "*/*";
    }
}

