/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.std.av.server.object.item;

import org.cybergarage.upnp.std.av.server.object.ContentNode;
import org.cybergarage.xml.Attribute;
import org.cybergarage.xml.Node;

public class ResourceNode
extends ContentNode {
    public static final String NAME = "res";
    public static final String PROTOCOL_INFO = "protocolInfo";
    public static final String SIZE = "size";
    public static final String IMPORT_URI = "importUri";
    public static final String COLOR_DEPTH = "colorDepth";
    public static final String RESOLUTION = "resolution";

    public static final boolean isResourceNode(Node node) {
        String name = node.getName();
        if (name == null) {
            return false;
        }
        return name.equals(NAME);
    }

    @Override
    public boolean set(Node node) {
        this.setValue(node.getValue());
        int nAttr = node.getNAttributes();
        for (int n = 0; n < nAttr; ++n) {
            Attribute attr = node.getAttribute(n);
            this.setAttribute(attr.getName(), attr.getValue());
        }
        return true;
    }

    public String getURL() {
        return this.getValue();
    }

    public String getProtocolInfo() {
        return this.getAttributeValue(PROTOCOL_INFO);
    }

    public String getProtocolInfoAtIndex(int anIndex) {
        String protocolInfo = this.getProtocolInfo();
        if (protocolInfo == null) {
            return "";
        }
        String[] protocols = protocolInfo.split(":");
        if (protocols == null || protocols.length <= anIndex) {
            return "";
        }
        return protocols[anIndex];
    }

    public String getProtocol() {
        return this.getProtocolInfoAtIndex(0);
    }

    public String getNetwork() {
        return this.getProtocolInfoAtIndex(1);
    }

    public String getContentFormat() {
        return this.getProtocolInfoAtIndex(2);
    }

    public String getAdditionalInfo() {
        return this.getProtocolInfoAtIndex(3);
    }

    public String getAdditionalInfoForKey(String aKey) {
        if (aKey == null) {
            return "";
        }
        String fullAddInfo = this.getAdditionalInfo();
        if (fullAddInfo == null) {
            return "";
        }
        String[] addInfos = fullAddInfo.split(";");
        if (addInfos == null || addInfos.length <= 0) {
            return "";
        }
        for (int n = 0; n < addInfos.length; ++n) {
            String addInfo = addInfos[n];
            if (!addInfo.startsWith(aKey)) continue;
            String[] tokens = addInfo.split("=");
            if (tokens == null || tokens.length < 2) {
                return "";
            }
            return tokens[1];
        }
        return "";
    }

    public String getDlnaOrgPn() {
        return this.getAdditionalInfoForKey("DLNA.ORG_PN");
    }

    public String getDlnaOrgOp() {
        return this.getAdditionalInfoForKey("DLNA.ORG_OP");
    }

    public String getDlnaOrgFlags() {
        return this.getAdditionalInfoForKey("DLNA.ORG_FLAGS");
    }

    public boolean isThumbnail() {
        String dlnaOrgPn = this.getDlnaOrgPn();
        if (dlnaOrgPn == null) {
            return false;
        }
        return dlnaOrgPn.endsWith("_TN");
    }

    public boolean isSmallImage() {
        String dlnaOrgPn = this.getDlnaOrgPn();
        if (dlnaOrgPn == null) {
            return false;
        }
        return dlnaOrgPn.endsWith("_SM");
    }

    public boolean isMediumImage() {
        String dlnaOrgPn = this.getDlnaOrgPn();
        if (dlnaOrgPn == null) {
            return false;
        }
        return dlnaOrgPn.endsWith("_MED");
    }

    public boolean isLargeImage() {
        String dlnaOrgPn = this.getDlnaOrgPn();
        if (dlnaOrgPn == null) {
            return false;
        }
        return dlnaOrgPn.endsWith("_LRG");
    }

    public boolean isImage() {
        String mimeType = this.getContentFormat();
        if (mimeType == null) {
            return false;
        }
        return mimeType.startsWith("image");
    }

    public boolean isMovie() {
        String mimeType = this.getContentFormat();
        if (mimeType == null) {
            return false;
        }
        if (mimeType.startsWith("movie")) {
            return true;
        }
        return mimeType.startsWith("video");
    }

    public boolean isVideo() {
        return this.isMovie();
    }

    public boolean isAudio() {
        String mimeType = this.getContentFormat();
        if (mimeType == null) {
            return false;
        }
        return mimeType.startsWith("audio");
    }
}

