/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.std.av.server.object.item.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.cybergarage.upnp.std.av.server.ContentDirectory;
import org.cybergarage.upnp.std.av.server.object.Format;
import org.cybergarage.upnp.std.av.server.object.item.ItemNode;
import org.cybergarage.util.Debug;
import org.cybergarage.util.FileUtil;

public class FileItemNode
extends ItemNode {
    private File itemFile;

    public FileItemNode() {
        this.setFile(null);
    }

    public void setFile(File file) {
        this.itemFile = file;
    }

    public File getFile() {
        return this.itemFile;
    }

    public long getFileTimeStamp() {
        long itemFileTimeStamp = 0L;
        if (this.itemFile != null) {
            try {
                itemFileTimeStamp = this.itemFile.lastModified();
            }
            catch (Exception e) {
                Debug.warning((Exception)e);
            }
        }
        return itemFileTimeStamp;
    }

    public boolean equals(File file) {
        if (this.itemFile == null) {
            return false;
        }
        return this.itemFile.equals(file);
    }

    public byte[] getContent() {
        byte[] fileByte = new byte[]{};
        try {
            fileByte = FileUtil.load((File)this.itemFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileByte;
    }

    @Override
    public long getContentLength() {
        return this.itemFile.length();
    }

    @Override
    public InputStream getContentInputStream() {
        try {
            return new FileInputStream(this.itemFile);
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
            return null;
        }
    }

    @Override
    public String getMimeType() {
        File itemFile;
        ContentDirectory cdir = this.getContentDirectory();
        Format itemFormat = cdir.getFormat(itemFile = this.getFile());
        if (itemFormat == null) {
            return "*/*";
        }
        return itemFormat.getMimeType();
    }
}

