/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.std.av.server.object.item.mythtv;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.cybergarage.upnp.std.av.server.directory.mythtv.MythRecordedInfo;
import org.cybergarage.upnp.std.av.server.object.item.ItemNode;
import org.cybergarage.util.Debug;
import org.cybergarage.util.FileUtil;
import org.cybergarage.xml.Attribute;
import org.cybergarage.xml.AttributeList;

public class MythRecordedItemNode
extends ItemNode {
    private static final String MIME_TYPE = "video/mpeg";
    private MythRecordedInfo recInfo;

    public MythRecordedItemNode() {
        this.setRecordedInfo(null);
    }

    public MythRecordedInfo getRecordedInfo() {
        return this.recInfo;
    }

    public void setRecordedInfo(MythRecordedInfo info) {
        this.recInfo = info;
        if (info == null) {
            return;
        }
        this.setTitle(info.getTitle());
        this.setCreator("");
        this.setUPnPClass("object.item.videoItem.movie");
        this.setDate(info.getStartTime());
        this.setStorageUsed(info.getFileSize());
        String protocol = "http-get:*:video/mpeg:*";
        String id = this.getID();
        String url = this.getContentDirectory().getContentExportURL(id);
        AttributeList attrList = new AttributeList();
        Attribute attr = new Attribute("size", Long.toString(info.getFileSize()));
        attrList.add((Object)attr);
        this.setResource(url, protocol, attrList);
    }

    public boolean equals(MythRecordedInfo info) {
        MythRecordedInfo recInfo = this.getRecordedInfo();
        if (info == null || recInfo == null) {
            return false;
        }
        return info.getChanID() == recInfo.getChanID();
    }

    public byte[] getContent() {
        File recFile = this.getRecordedInfo().getFile();
        if (!recFile.exists()) {
            return new byte[0];
        }
        byte[] fileByte = new byte[]{};
        try {
            fileByte = FileUtil.load((File)recFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileByte;
    }

    @Override
    public long getContentLength() {
        File recFile = this.getRecordedInfo().getFile();
        return recFile.length();
    }

    @Override
    public InputStream getContentInputStream() {
        try {
            File recFile = this.getRecordedInfo().getFile();
            return new FileInputStream(recFile);
        }
        catch (Exception e) {
            Debug.warning((Exception)e);
            return null;
        }
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }
}

