/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.doorman.service.core;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cyclopsgroup.caff.util.UUIDUtils;
import org.cyclopsgroup.doorman.api.SessionService;
import org.cyclopsgroup.doorman.api.User;
import org.cyclopsgroup.doorman.api.UserOperationResult;
import org.cyclopsgroup.doorman.api.UserSession;
import org.cyclopsgroup.doorman.api.UserSessionAttributes;
import org.cyclopsgroup.doorman.api.UserSessionConfig;
import org.cyclopsgroup.doorman.api.UserSignUpResult;
import org.cyclopsgroup.doorman.api.UserType;
import org.cyclopsgroup.doorman.service.dao.DAOFactory;
import org.cyclopsgroup.doorman.service.dao.UserDAO;
import org.cyclopsgroup.doorman.service.dao.UserSessionDAO;
import org.cyclopsgroup.doorman.service.security.PasswordStrategy;
import org.cyclopsgroup.doorman.service.storage.StoredUser;
import org.cyclopsgroup.doorman.service.storage.StoredUserSession;
import org.cyclopsgroup.doorman.service.storage.UserState;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultSessionService
implements SessionService {
    private static final Log LOG = LogFactory.getLog(DefaultSessionService.class);
    private final UserSessionConfig config;
    private final UserDAO userDao;
    private final UserSessionDAO userSessionDao;

    @Autowired
    public DefaultSessionService(DAOFactory daoFactory, UserSessionConfig config) {
        this.userSessionDao = daoFactory.createUserSessionDAO();
        this.userDao = daoFactory.createUserDAO();
        this.config = config;
    }

    @Transactional
    public UserOperationResult confirmSignUp(String sessionId, String userId, String token) {
        StoredUser user = this.userDao.get(userId);
        if (user == null) {
            return UserOperationResult.NO_SUCH_IDENTITY;
        }
        if (user.getUserState() != UserState.PENDING || !StringUtils.equals((String)token, (String)user.getActivationToken())) {
            return UserOperationResult.AUTHENTICATION_FAILURE;
        }
        user.setActivationToken(null);
        user.setUserState(UserState.ACTIVE);
        this.userDao.saveUser(user);
        this.userSessionDao.updateUser(sessionId, user);
        return UserOperationResult.SUCCESSFUL;
    }

    private StoredUser createUserForSignUp(User user, UserType type) {
        String userId = UUIDUtils.randomStringId();
        StoredUser storedUser = new StoredUser();
        storedUser.copyFrom(user);
        storedUser.setUserId(userId);
        storedUser.setDomainName(this.config.getDomainName());
        storedUser.setUserType(type);
        PasswordStrategy strategy = PasswordStrategy.valueOf(this.config.getPasswordStrategy());
        storedUser.setPasswordStrategy(strategy);
        String storedPassword = strategy.encode(user.getPassword(), userId);
        storedUser.setPassword(storedPassword);
        DateTime now = new DateTime();
        storedUser.setCreationDate(now);
        storedUser.setLastModified(now);
        return storedUser;
    }

    @Transactional
    public UserSession getSession(String sessionId) {
        StoredUserSession session = this.userSessionDao.pingSession(sessionId);
        if (session == null) {
            return null;
        }
        return session.toUserSession();
    }

    @Transactional
    public UserSession pingSession(String sessionId) {
        StoredUserSession session = this.userSessionDao.pingSession(sessionId);
        if (session == null) {
            throw new IllegalStateException("Session " + sessionId + " doesn't exist");
        }
        return session.toUserSession();
    }

    @Transactional
    public UserSignUpResult requestSignUp(String sessionId, User user) {
        StoredUser existingUser = this.userDao.findNonPendingUser(user.getUserName());
        if (existingUser != null) {
            return new UserSignUpResult(UserOperationResult.IDENTITY_EXISTED, user, null);
        }
        StoredUser storedUser = this.createUserForSignUp(user, UserType.LOCAL);
        String userId = storedUser.getUserId();
        storedUser.setUserState(UserState.PENDING);
        storedUser.setActivationToken(UUIDUtils.randomStringId());
        this.userDao.saveUser(storedUser);
        LOG.info((Object)("Sign up request " + userId + " is saved"));
        user.setUserId(userId);
        UserSignUpResult result = new UserSignUpResult(UserOperationResult.SUCCESSFUL, user, storedUser.getActivationToken());
        this.config.getListener().signUpRequested(sessionId, result);
        return result;
    }

    @Transactional
    public UserOperationResult signIn(String sessionId, String userName, String password) {
        StoredUser user = this.userDao.findNonPendingUser(userName);
        if (user == null) {
            return UserOperationResult.NO_SUCH_IDENTITY;
        }
        if (!StringUtils.equals((String)user.getPasswordStrategy().encode(password, user.getUserId()), (String)user.getPassword())) {
            return UserOperationResult.AUTHENTICATION_FAILURE;
        }
        this.userSessionDao.updateUser(sessionId, user);
        return UserOperationResult.SUCCESSFUL;
    }

    @Transactional
    public UserOperationResult forceSignIn(String sessionId, String userName) {
        StoredUser user = this.userDao.findNonPendingUser(userName);
        if (user == null) {
            return UserOperationResult.NO_SUCH_IDENTITY;
        }
        this.userSessionDao.updateUser(sessionId, user);
        return UserOperationResult.SUCCESSFUL;
    }

    @Transactional
    public UserOperationResult signOut(String sessionId) {
        this.userSessionDao.updateUser(sessionId, null);
        return UserOperationResult.SUCCESSFUL;
    }

    @Transactional
    public UserOperationResult signUp(String sessionId, User user, UserType type) {
        StoredUser existing = this.userDao.findNonPendingUser(user.getUserName());
        if (existing != null) {
            return UserOperationResult.IDENTITY_EXISTED;
        }
        StoredUser storedUser = this.createUserForSignUp(user, type == null ? UserType.LOCAL : type);
        storedUser.setUserState(UserState.ACTIVE);
        this.userDao.saveUser(storedUser);
        this.userSessionDao.updateUser(sessionId, storedUser);
        return UserOperationResult.SUCCESSFUL;
    }

    @Transactional
    public UserSession startSession(String sessionId, UserSessionAttributes attributes) {
        Validate.notNull((Object)sessionId, (String)"Session ID can't be NULL");
        StoredUserSession session = new StoredUserSession();
        session.setSessionId(sessionId);
        if (attributes != null) {
            session.setAcceptLanguage(attributes.getAcceptLanguage());
            session.setIpAddress(attributes.getIpAddress());
            session.setUserAgent(attributes.getUserAgent());
        }
        this.userSessionDao.createNew(session);
        return session.toUserSession();
    }
}

