/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.doorman.service.core;

import java.util.ArrayList;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.cyclopsgroup.doorman.api.ListUserRequest;
import org.cyclopsgroup.doorman.api.User;
import org.cyclopsgroup.doorman.api.UserOperationResult;
import org.cyclopsgroup.doorman.api.UserService;
import org.cyclopsgroup.doorman.api.UserSessionConfig;
import org.cyclopsgroup.doorman.api.UserType;
import org.cyclopsgroup.doorman.api.Users;
import org.cyclopsgroup.doorman.service.dao.DAOFactory;
import org.cyclopsgroup.doorman.service.dao.UserDAO;
import org.cyclopsgroup.doorman.service.security.PasswordStrategy;
import org.cyclopsgroup.doorman.service.storage.StoredUser;
import org.cyclopsgroup.doorman.service.storage.UserState;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultUserService
implements UserService {
    private final UserSessionConfig config;
    private final UserDAO userDao;

    private static WebApplicationException exceptionOf(String message, Response.Status status) {
        String errorMessage = message + " (HTTP response status: " + status.getStatusCode() + ")";
        Response error = Response.status((Response.Status)status).entity((Object)errorMessage).build();
        return new WebApplicationException((Throwable)new RuntimeException(message), error);
    }

    @Autowired
    public DefaultUserService(DAOFactory daoFactory, UserSessionConfig config) {
        this.userDao = daoFactory.createUserDAO();
        this.config = config;
    }

    @Transactional(readOnly=true)
    public UserOperationResult authenticate(String userName, String secureCredential) {
        StoredUser user = this.userDao.findNonPendingUser(userName);
        if (user == null) {
            return UserOperationResult.NO_SUCH_IDENTITY;
        }
        if (StringUtils.equals((String)user.getPasswordStrategy().encode(secureCredential, user.getUserId()), (String)user.getPassword())) {
            return UserOperationResult.SUCCESSFUL;
        }
        return UserOperationResult.AUTHENTICATION_FAILURE;
    }

    @Transactional
    public void changeCredential(String userName, String secureCredential) {
        StoredUser user = this.getRequiredNonPendingUser(userName);
        PasswordStrategy strategy = PasswordStrategy.valueOf(this.config.getPasswordStrategy());
        user.setPasswordStrategy(strategy);
        String newPassword = strategy.encode(secureCredential, user.getUserId());
        user.setPassword(newPassword);
        user.setUserType(UserType.LOCAL);
        this.userDao.saveUser(user);
    }

    @Transactional(readOnly=true)
    public User get(String userName) {
        return this.getRequiredNonPendingUser(userName).toUser();
    }

    private StoredUser getRequiredNonPendingUser(String userName) {
        StoredUser user = this.userDao.findNonPendingUser(userName);
        if (user == null) {
            throw DefaultUserService.exceptionOf("User " + userName + " is not found", Response.Status.NOT_FOUND);
        }
        return user;
    }

    @Transactional(readOnly=true)
    public Users list(ListUserRequest request) {
        ArrayList<User> users = new ArrayList<User>(request.getUserNames().size());
        for (String userName : request.getUserNames()) {
            User user = this.get(userName);
            if (user == null) continue;
            users.add(user);
        }
        return new Users(users);
    }

    @Transactional(readOnly=true)
    public UserOperationResult ping(String userName) {
        StoredUser storedUser = this.userDao.findNonPendingUser(userName);
        if (storedUser == null || storedUser.getUserState() == UserState.PENDING) {
            return UserOperationResult.NO_SUCH_IDENTITY;
        }
        return UserOperationResult.SUCCESSFUL;
    }

    @Transactional
    public void update(String userName, User user) {
        StoredUser storedUser = this.userDao.findNonPendingUser(userName);
        if (storedUser == null) {
            Response error = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("User " + userName + " not found")).build();
            throw new WebApplicationException(error);
        }
        storedUser.copyFrom(user);
        this.userDao.saveUser(storedUser);
    }
}

