/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.doorman.service.hibernate;

import java.io.Serializable;
import org.cyclopsgroup.doorman.service.dao.UserDAO;
import org.cyclopsgroup.doorman.service.storage.StoredUser;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.joda.time.DateTime;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

class HibernateUserDAO
extends HibernateDaoSupport
implements UserDAO {
    HibernateUserDAO(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
    }

    @Override
    public StoredUser findNonPendingUser(String nameOrId) {
        Query findByName = this.getSession(true).getNamedQuery("findNonPendingUserByNameOrId");
        return (StoredUser)findByName.setParameter("nameOrId", (Object)nameOrId).uniqueResult();
    }

    @Override
    public StoredUser get(String userId) {
        return (StoredUser)this.getHibernateTemplate().get(StoredUser.class, (Serializable)((Object)userId));
    }

    @Override
    public void saveUser(StoredUser user) {
        user.setLastModified(new DateTime());
        this.getHibernateTemplate().saveOrUpdate((Object)user);
    }
}

