/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.doorman.service.hibernate;

import java.io.Serializable;
import org.cyclopsgroup.doorman.service.dao.UserSessionDAO;
import org.cyclopsgroup.doorman.service.storage.StoredUser;
import org.cyclopsgroup.doorman.service.storage.StoredUserSession;
import org.hibernate.SessionFactory;
import org.joda.time.DateTime;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

class HibernateUserSessionDAO
extends HibernateDaoSupport
implements UserSessionDAO {
    HibernateUserSessionDAO(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
    }

    @Override
    public StoredUserSession pingSession(String sessionId) {
        StoredUserSession session = (StoredUserSession)this.getHibernateTemplate().get(StoredUserSession.class, (Serializable)((Object)sessionId));
        if (session == null) {
            return null;
        }
        DateTime now = new DateTime();
        session.setLastModified(now);
        StoredUser user = session.getUser();
        if (user != null) {
            user.setLastVisit(now);
        }
        this.getHibernateTemplate().update((Object)session);
        return session;
    }

    @Override
    public void createNew(StoredUserSession session) {
        DateTime now = new DateTime();
        session.setCreationDate(now);
        session.setLastModified(now);
        StoredUser user = session.getUser();
        if (user != null) {
            session.getUser().setLastVisit(now);
        }
        this.getHibernateTemplate().save((Object)session);
    }

    @Override
    public StoredUserSession findById(String sessionId) {
        return (StoredUserSession)this.getHibernateTemplate().get(StoredUserSession.class, (Serializable)((Object)sessionId));
    }

    @Override
    public void updateUser(String sessionId, StoredUser user) {
        StoredUserSession session = (StoredUserSession)this.getHibernateTemplate().load(StoredUserSession.class, (Serializable)((Object)sessionId));
        session.setUser(user);
        DateTime now = new DateTime();
        session.setLastModified(now);
        if (user != null) {
            session.setLastVerification(now);
            user.setLastVisit(now);
        }
        this.getHibernateTemplate().update((Object)session);
    }
}

