/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.doorman.service.servlet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

class ParameterOverridingRequest
extends HttpServletRequestWrapper {
    private Map<String, String> parameters = new HashMap<String, String>();

    ParameterOverridingRequest(HttpServletRequest request) {
        super(request);
        String requestedPath = StringUtils.trimToEmpty((String)request.getServletPath()) + StringUtils.trimToEmpty((String)request.getPathInfo());
        this.setAttribute("requestedPath", requestedPath);
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public Enumeration getParameterNames() {
        return new IteratorEnumeration(this.parameters.keySet().iterator());
    }

    public String[] getParameterValues(String name) {
        String value = this.parameters.get(name);
        if (value == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return new String[]{value};
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this));
    }
}

