/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.doorman.service.servlet;

import java.io.IOException;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cyclopsgroup.caff.util.UUIDUtils;
import org.cyclopsgroup.doorman.api.SessionInjectionFilterContext;
import org.cyclopsgroup.doorman.api.UnauthenticatedError;
import org.cyclopsgroup.doorman.api.UserSession;
import org.cyclopsgroup.doorman.api.UserSessionAttributes;
import org.cyclopsgroup.doorman.service.servlet.ParameterOverridingRequest;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.util.NestedServletException;

public class SessionInjectionFilter
implements Filter {
    private static final String DEFAULT_CONTEXT_BEAN = "sessionInjectionFilterContext";
    private static final Log LOG = LogFactory.getLog(SessionInjectionFilter.class);
    private SessionInjectionFilterContext context;

    private static String getParameter(FilterConfig config, String paramName, String defaultValue) {
        String value = config.getInitParameter(paramName);
        if (StringUtils.isBlank((String)value)) {
            value = defaultValue;
        }
        return value;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        DateTime now = new DateTime();
        HttpServletRequest req = (HttpServletRequest)request;
        if (this.context.shouldIgnorePath(req)) {
            chain.doFilter(request, response);
            return;
        }
        UserSession session = (UserSession)req.getSession().getAttribute(this.context.getSessionAttribute());
        if (session == null || session.getLastActivity().plusSeconds(this.context.getSessionCheckingInterval()).isBefore((ReadableInstant)now)) {
            LOG.info((Object)("Looking for sessionId cookie from request cookies: " + Arrays.toString(req.getCookies())));
            Cookie sessionIdCookie = null;
            if (req.getCookies() != null) {
                for (Cookie c : req.getCookies()) {
                    if (!c.getName().equals(this.context.getSessionIdCookie())) continue;
                    sessionIdCookie = c;
                }
            }
            LOG.info((Object)("Found cookie " + ToStringBuilder.reflectionToString(sessionIdCookie)));
            if (sessionIdCookie != null && (session = this.context.getSessionService().getSession(sessionIdCookie.getValue())) != null) {
                LOG.info((Object)("Found existing session from session service: " + ToStringBuilder.reflectionToString((Object)session) + ", user=" + ToStringBuilder.reflectionToString((Object)session.getUser()) + ", attributes=" + ToStringBuilder.reflectionToString((Object)session.getAttributes())));
            }
            String userAgent = req.getHeader("User-Agent");
            if (session == null || sessionIdCookie == null) {
                String sessionId = UUIDUtils.randomStringId();
                UserSessionAttributes attributes = new UserSessionAttributes();
                attributes.setAcceptLanguage(req.getHeader("Accept-Language"));
                attributes.setUserAgent(userAgent);
                attributes.setIpAddress(req.getRemoteAddr());
                LOG.info((Object)("Start new session for " + sessionId + " with attributes " + ToStringBuilder.reflectionToString((Object)attributes)));
                session = this.context.getSessionService().startSession(sessionId, attributes);
                sessionIdCookie = new Cookie(this.context.getSessionIdCookie(), sessionId);
            }
            session.setLastActivity(now);
            req.getSession().setAttribute(this.context.getSessionAttribute(), (Object)session);
            sessionIdCookie.setMaxAge(604800);
            ((HttpServletResponse)response).addCookie(sessionIdCookie);
        }
        try {
            chain.doFilter(request, response);
        }
        catch (UnauthenticatedError e) {
            this.forwardToSignInUrl(req, (HttpServletResponse)response);
        }
        catch (NestedServletException e) {
            if (e.getCause() instanceof UnauthenticatedError) {
                this.forwardToSignInUrl(req, (HttpServletResponse)response);
            }
            throw e;
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String name = SessionInjectionFilter.getParameter(filterConfig, "contextBean", DEFAULT_CONTEXT_BEAN);
        LOG.info((Object)("Name of filter context bean in context is " + name));
        WebApplicationContext applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)filterConfig.getServletContext());
        this.context = (SessionInjectionFilterContext)applicationContext.getBean(name, SessionInjectionFilterContext.class);
    }

    private void forwardToSignInUrl(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String signInUrl;
        StringBuffer url = req.getRequestURL();
        if (StringUtils.isNotBlank((String)req.getQueryString())) {
            url.append("?" + req.getQueryString());
        }
        if ((signInUrl = this.context.getSignInUrl()).indexOf("{contextPath}") != -1) {
            signInUrl = StringUtils.replace((String)signInUrl, (String)"{contextPath}", (String)req.getContextPath());
        }
        if (this.context.isRedirectingToUrl()) {
            resp.sendRedirect(signInUrl + "?redirectTo=" + resp.encodeRedirectURL(url.toString()));
            return;
        }
        RequestDispatcher dispatcher = req.getRequestDispatcher(signInUrl);
        ParameterOverridingRequest request = new ParameterOverridingRequest(req);
        request.setParameter("redirectTo", url.toString());
        dispatcher.forward((ServletRequest)request, (ServletResponse)resp);
    }
}

