/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.doorman.service.storage;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.cyclopsgroup.doorman.api.User;
import org.cyclopsgroup.doorman.api.UserType;
import org.cyclopsgroup.doorman.service.security.PasswordStrategy;
import org.cyclopsgroup.doorman.service.storage.UserState;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;

@Entity
@Table(name="dm_user", uniqueConstraints={@UniqueConstraint(columnNames={"user_name", "activation_token"}), @UniqueConstraint(columnNames={"email_address", "activation_token"})})
@NamedQueries(value={@NamedQuery(name="findNonPendingUserByNameOrId", query="FROM StoredUser WHERE (userName = :nameOrId OR userId = :nameOrId) AND userState <> 'PENDING'")})
@org.hibernate.annotations.Entity(dynamicUpdate=true)
public class StoredUser {
    public static final String QUERY_BY_NAME_OR_ID = "findNonPendingUserByNameOrId";
    private String activationToken;
    private String countryCode;
    private DateTime creationDate;
    private String displayName;
    private String domainName;
    private String emailAddress;
    private String languageCode;
    private DateTime lastModified;
    private DateTime lastVisit;
    private String password;
    private PasswordStrategy passwordStrategy;
    private String timeZoneId;
    private String userId;
    private String userName;
    private UserState userState;
    private UserType userType;

    public void copyFrom(User from) {
        this.setCountryCode(from.getCountryCode());
        this.setDisplayName(from.getDisplayName());
        this.setDomainName(from.getDomainName());
        this.setEmailAddress(from.getEmailAddress());
        this.setLanguageCode(from.getLanguageCode());
        this.setTimeZoneId(from.getTimeZoneId());
        this.setUserName(from.getUserName());
    }

    @Column(name="activation_token", length=255)
    public String getActivationToken() {
        return this.activationToken;
    }

    @Column(name="country_code", length=8, nullable=false)
    public String getCountryCode() {
        return this.countryCode;
    }

    @Column(name="creation_date", nullable=false)
    @Type(type="datetime")
    public DateTime getCreationDate() {
        return this.creationDate;
    }

    @Column(name="display_name", nullable=false, length=64)
    public String getDisplayName() {
        return this.displayName;
    }

    @Column(name="domain_name", length=32, nullable=false)
    public String getDomainName() {
        return this.domainName;
    }

    @Column(name="email_address", nullable=false, length=64)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Column(name="language_code", length=8, nullable=false)
    public String getLanguageCode() {
        return this.languageCode;
    }

    @Column(name="last_modified")
    @Type(type="datetime")
    public DateTime getLastModified() {
        return this.lastModified;
    }

    @Column(name="last_visit")
    @Type(type="datetime")
    public DateTime getLastVisit() {
        return this.lastVisit;
    }

    @Column(name="password", nullable=false, length=32)
    public String getPassword() {
        return this.password;
    }

    @Column(name="password_strategy", length=8, nullable=false)
    @Enumerated(value=EnumType.STRING)
    public PasswordStrategy getPasswordStrategy() {
        return this.passwordStrategy;
    }

    @Column(name="time_zone_id", nullable=false, length=32)
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    @Id
    @Column(name="user_id", nullable=false, length=32)
    public String getUserId() {
        return this.userId;
    }

    @Column(name="user_name", nullable=false, length=64)
    public String getUserName() {
        return this.userName;
    }

    @Column(name="user_state", nullable=false, length=8)
    @Enumerated(value=EnumType.STRING)
    public UserState getUserState() {
        return this.userState;
    }

    @Column(name="user_type", nullable=false, length=8)
    @Enumerated(value=EnumType.STRING)
    public UserType getUserType() {
        return this.userType;
    }

    public void setActivationToken(String activationToken) {
        this.activationToken = activationToken;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void setCreationDate(DateTime creationDate) {
        this.creationDate = creationDate;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public void setLastModified(DateTime lastModified) {
        this.lastModified = lastModified;
    }

    public void setLastVisit(DateTime lastVisit) {
        this.lastVisit = lastVisit;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPasswordStrategy(PasswordStrategy passwordStrategy) {
        this.passwordStrategy = passwordStrategy;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setUserState(UserState userState) {
        this.userState = userState;
    }

    public void setUserType(UserType userType) {
        this.userType = userType;
    }

    public User toUser() {
        User user = new User();
        user.setCountryCode(this.getCountryCode());
        user.setCreationDate(this.getCreationDate());
        user.setDisplayName(this.getDisplayName());
        user.setDomainName(this.getDomainName());
        user.setEmailAddress(this.getEmailAddress());
        user.setLanguageCode(this.getLanguageCode());
        user.setLastVisit(this.getLastVisit());
        user.setTimeZoneId(this.getTimeZoneId());
        user.setUserId(this.getUserId());
        user.setUserName(this.getUserName());
        user.setOpenAuthOnly(this.userType != UserType.LOCAL);
        return user;
    }
}

