/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.doorman.service.storage;

import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.cyclopsgroup.doorman.api.UserSession;
import org.cyclopsgroup.doorman.api.UserSessionAttributes;
import org.cyclopsgroup.doorman.service.storage.StoredUser;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;

@Entity
@Table(name="dm_session")
@org.hibernate.annotations.Entity(dynamicUpdate=true)
public class StoredUserSession {
    private static final Pattern MOBILE_USER_AGENT = Pattern.compile("iphone|ipad|ipod|android|blackberry|mini|windows\\sce|palm");
    private String acceptLanguage;
    private DateTime creationDate;
    private String ipAddress;
    private DateTime lastModified;
    private DateTime lastVerification;
    private String sessionId;
    private StoredUser user;
    private String userAgent;

    public UserSession toUserSession() {
        UserSession session = new UserSession();
        session.setCreationDate(this.getCreationDate());
        session.setLastActivity(this.getLastModified());
        session.setSessionId(this.getSessionId());
        UserSessionAttributes attributes = new UserSessionAttributes();
        attributes.setAcceptLanguage(this.getAcceptLanguage());
        attributes.setIpAddress(this.getIpAddress());
        attributes.setUserAgent(this.getUserAgent());
        session.setAttributes(attributes);
        if (this.getUser() != null) {
            session.setUser(this.getUser().toUser());
        }
        session.setMobileDevice(MOBILE_USER_AGENT.matcher(this.userAgent.toLowerCase()).find());
        return session;
    }

    @Column(name="accept_language", length=16)
    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    @Column(name="creation_date", nullable=false)
    @Type(type="datetime")
    public DateTime getCreationDate() {
        return this.creationDate;
    }

    @Column(name="id_address", length=16)
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Column(name="last_modified", nullable=false)
    @Type(type="datetime")
    public DateTime getLastModified() {
        return this.lastModified;
    }

    @Column(name="last_verification")
    @Type(type="datetime")
    public DateTime getLastVerification() {
        return this.lastVerification;
    }

    @Id
    @Column(name="session_id", nullable=false, length=32)
    public String getSessionId() {
        return this.sessionId;
    }

    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="user_id")
    public StoredUser getUser() {
        return this.user;
    }

    @Column(name="user_agent", length=256)
    public String getUserAgent() {
        return this.userAgent;
    }

    public void setAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
    }

    public void setCreationDate(DateTime creationDate) {
        this.creationDate = creationDate;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setLastModified(DateTime lastModified) {
        this.lastModified = lastModified;
    }

    public void setLastVerification(DateTime lastVerification) {
        this.lastVerification = lastVerification;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setUser(StoredUser user) {
        this.user = user;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }
}

