/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm;

import java.io.IOException;
import java.io.PrintWriter;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jmxterm.Connection;
import org.cyclopsgroup.jmxterm.ConnectionImpl;
import org.cyclopsgroup.jmxterm.SyntaxUtils;

public class Session {
    private boolean abbreviated;
    private String bean;
    private boolean closed;
    private ConnectionImpl connection;
    private String domain;
    public final PrintWriter output;
    private boolean verbose = true;

    public Session(PrintWriter output) {
        Validate.notNull((Object)output, (String)"Output can't be NULL");
        this.output = output;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        if (this.connection != null) {
            this.unsetConnection();
        }
        this.closed = true;
    }

    public synchronized boolean connect(String url) throws IOException {
        Validate.isTrue((this.connection == null ? 1 : 0) != 0, (String)"Session is already opened");
        Validate.notNull((Object)url, (String)"URL can't be NULL");
        JMXServiceURL u = SyntaxUtils.getUrl(url);
        JMXConnector connector = JMXConnectorFactory.connect(u);
        this.connection = new ConnectionImpl(connector, u, url);
        return true;
    }

    public synchronized boolean disconnect() throws IOException {
        ConnectionImpl conn = this.connection;
        this.unsetConnection();
        if (conn != null) {
            conn.getConnector().close();
            return true;
        }
        return false;
    }

    public final String getBean() {
        return this.bean;
    }

    public final Connection getConnection() {
        return this.connection;
    }

    public final String getDomain() {
        return this.domain;
    }

    public MBeanServerConnection getServerConnection() throws IOException {
        this.requireConnector();
        return this.connection.getConnector().getMBeanServerConnection();
    }

    public final boolean isAbbreviated() {
        return this.abbreviated;
    }

    public final boolean isClosed() {
        return this.closed;
    }

    public final boolean isVerbose() {
        return this.verbose;
    }

    public void msg(String msg) {
        this.msg(msg, null);
    }

    public void msg(String msg, String abbr) {
        if (this.abbreviated) {
            if (StringUtils.isNotEmpty((String)abbr)) {
                this.output.println(abbr);
            }
        } else if (StringUtils.isNotEmpty((String)msg)) {
            this.output.println(msg);
        }
    }

    public void ok() {
        if (this.abbreviated) {
            this.output.println("ok");
        }
    }

    private void requireConnector() {
        this.requireSession();
        Validate.notNull((Object)this.connection, (String)"Connection is not opened yet");
    }

    private void requireSession() {
        Validate.isTrue((!this.closed ? 1 : 0) != 0, (String)"Session is already closed");
    }

    public final void setAbbreviated(boolean abbreviated) {
        this.abbreviated = abbreviated;
    }

    public final void setBean(String bean) {
        this.bean = bean;
    }

    public void setConnection(ConnectionImpl connection) {
        Validate.notNull((Object)connection, (String)"Connection can't be NULL");
        this.requireSession();
        Validate.isTrue((this.connection == null ? 1 : 0) != 0, (String)"Connection already exists");
        this.connection = connection;
    }

    public void setDomain(String domain) {
        Validate.notNull((Object)domain, (String)"domain can't be NULL");
        this.requireConnector();
        this.domain = domain;
    }

    public final void setVerbose(boolean debug) {
        this.verbose = debug;
    }

    public void unsetConnection() {
        if (this.domain != null) {
            this.unsetDomain();
        }
        this.connection = null;
    }

    public void unsetDomain() {
        this.bean = null;
        this.domain = null;
    }
}

