/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.boot;

import java.beans.IntrospectionException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Parser;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jcli.jccli.JakartaCommonsCliParser;
import org.cyclopsgroup.jmxterm.boot.MainOptions;
import org.cyclopsgroup.jmxterm.impl.CommandCenter;

public class Main {
    private static final PrintWriter STDOUT_WRITER = new PrintWriter(System.out, true);
    private final CommandCenter commandCenter;

    Main(CommandCenter commandCenter) {
        Validate.notNull((Object)commandCenter, (String)"CommandCenter can't be NULL");
        this.commandCenter = commandCenter;
    }

    private Main() throws IOException {
        this(new CommandCenter(STDOUT_WRITER));
    }

    public static final void main(String[] args) throws IntrospectionException, IOException {
        Main main = new Main();
        main.execute(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(String[] args) throws IntrospectionException, IOException {
        boolean closeInputFinally;
        InputStreamReader input;
        MainOptions options = new MainOptions();
        JakartaCommonsCliParser parser = new JakartaCommonsCliParser((Parser)new GnuParser());
        parser.parse(args, options);
        if (options.isHelp()) {
            parser.printUsage(MainOptions.class, STDOUT_WRITER);
            return;
        }
        this.commandCenter.setAbbreviated(options.isAbbreviated());
        if (options.getUrl() != null) {
            this.commandCenter.connect(options.getUrl());
        }
        if (options.getInput().equals("stdin")) {
            input = new InputStreamReader(System.in);
            closeInputFinally = false;
        } else {
            input = new FileReader(new File(options.getInput()));
            closeInputFinally = true;
        }
        try {
            LineNumberReader in = new LineNumberReader(input);
            this.commandCenter.prompt();
            String line = in.readLine();
            while (line != null) {
                this.commandCenter.execute(line);
                if (this.commandCenter.isClosed()) break;
                this.commandCenter.prompt();
                line = in.readLine();
            }
            this.commandCenter.close();
        }
        finally {
            if (closeInputFinally) {
                ((Reader)input).close();
            }
        }
    }
}

