/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.boot;

import java.io.File;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.Option;

@Cli(name="jmxterm", description="Main executable of JMX terminal CLI tool", note="Without any option, this command opens an interactive command line based console. With a given input file, commands in file will be executed and process ends after file is processed")
public class MainOptions {
    public static final String STDERR = "stderr";
    public static final String STDIN = "stdin";
    public static final String STDOUT = "stdout";
    private boolean abbreviated;
    private boolean help;
    private String input = "stdin";
    private String output = "stdout";
    private String url;

    public final String getInput() {
        return this.input;
    }

    public final String getOutput() {
        return this.output;
    }

    public final String getUrl() {
        return this.url;
    }

    public final boolean isAbbreviated() {
        return this.abbreviated;
    }

    public final boolean isHelp() {
        return this.help;
    }

    @Option(name="a", longName="abbreviated", description="Flag for printing abbreviated version")
    public final void setAbbreviated(boolean abbreviated) {
        this.abbreviated = abbreviated;
    }

    @Option(name="h", longName="help", description="Show usage of this command line")
    public final void setHelp(boolean help) {
        this.help = help;
    }

    @Option(name="i", longName="input", description="Input script file. There can only be one input file. \"stdin\" is the default value which means console input")
    public final void setInput(String file) {
        Validate.notNull((Object)file, (String)"Input file can't be NULL");
        Validate.isTrue((boolean)new File(file).isFile(), (String)("File " + file + " doesn't exist"));
        this.input = file;
    }

    @Option(name="o", longName="output", description="Output file")
    public final void setOutput(String outputFile) {
        Validate.notNull((Object)outputFile, (String)"Output file can't be NULL");
        this.output = outputFile;
    }

    @Option(name="u", longName="url", description="JMX connection URL")
    public final void setUrl(String url) {
        Validate.notNull((Object)url, (String)"URL can't be NULL");
        this.url = url;
    }
}

