/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.cmd.DomainCommand;
import org.cyclopsgroup.jmxterm.cmd.DomainsCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cli(name="beans", description="List available beans", note="Example:\nbeans\nbeans -d java.lang")
public class BeansCommand
extends Command {
    private String domain;

    @Option(name="d", longName="domain", description="Domain name or %N domain index")
    public final void setDomain(String domain) {
        this.domain = domain;
    }

    private static List<String> getBeans(Session session, String domainName) throws MalformedObjectNameException, IOException {
        ObjectName queryName = null;
        if (domainName != null) {
            queryName = new ObjectName(domainName + ":*");
        }
        Set<ObjectName> names = session.getServerConnection().queryNames(queryName, null);
        ArrayList<String> results = new ArrayList<String>(names.size());
        for (ObjectName name : names) {
            results.add(name.getCanonicalName());
        }
        Collections.sort(results);
        return results;
    }

    @Override
    public void execute(Session session) throws MalformedObjectNameException, IOException {
        if (session.getConnection() == null) {
            throw new IllegalStateException("There's no open connection right now, use open command");
        }
        String domainName = DomainCommand.getDomainName(this.domain, session);
        ArrayList<String> domains = new ArrayList<String>();
        if (domainName == null) {
            domains.addAll(DomainsCommand.getDomains(session));
        } else {
            domains.add(domainName);
        }
        int i = 0;
        for (String d : domains) {
            session.msg("domain = " + d + ":");
            for (String bean : BeansCommand.getBeans(session, d)) {
                session.msg(String.format("  %%%-3d - %s", i++, bean), bean);
            }
        }
    }
}

