/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Pattern;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.cmd.BeanCommand;

@Cli(name="info", description="Display detail about an MBean")
public class InfoCommand
extends Command {
    private static final String TEXT_ATTRIBUTES = "# attributes";
    private static final String TEXT_NOTIFICATIONS = "# notifications";
    private static final String TEXT_OPERATIONS = "# operations";
    private static final Comparator<MBeanFeatureInfo> INFO_COMPARATOR = new Comparator<MBeanFeatureInfo>(){

        @Override
        public int compare(MBeanFeatureInfo o1, MBeanFeatureInfo o2) {
            return new CompareToBuilder().append((Object)o1.getName(), (Object)o2.getName()).append(o1.hashCode(), o2.hashCode()).toComparison();
        }
    };
    private String bean;
    private String domain;
    private boolean showDescription;
    private String type = "aon";

    private void displayAttributes(Session session, MBeanInfo info) {
        MBeanAttributeInfo[] attrInfos = info.getAttributes();
        if (attrInfos.length == 0) {
            session.msg("there is no attribute");
            return;
        }
        int index = 0;
        session.msg(TEXT_ATTRIBUTES, TEXT_ATTRIBUTES);
        ArrayList<MBeanAttributeInfo> infos = new ArrayList<MBeanAttributeInfo>(Arrays.asList(attrInfos));
        Collections.sort(infos, INFO_COMPARATOR);
        for (MBeanAttributeInfo attr : infos) {
            String rw = "" + (attr.isReadable() ? "r" : "") + (attr.isWritable() ? "w" : "");
            session.msg(String.format("  %%%-3d - %s (%s, %s)" + (this.showDescription ? ", %s" : ""), index++, attr.getName(), attr.getType(), rw, attr.getDescription()), attr.getName());
        }
    }

    private void displayNotifications(Session session, MBeanInfo info) {
        MBeanNotificationInfo[] notificationInfos = info.getNotifications();
        if (notificationInfos.length == 0) {
            session.msg("there's no notifications");
            return;
        }
        int index = 0;
        session.msg(TEXT_NOTIFICATIONS, TEXT_NOTIFICATIONS);
        for (MBeanNotificationInfo notification : notificationInfos) {
            session.msg(String.format("  %%%-3d - %s(%s)" + (this.showDescription ? ", %s" : ""), index++, notification.getName(), StringUtils.join((Object[])notification.getNotifTypes(), (String)","), notification.getDescription()), notification.getName());
        }
    }

    private void displayOperations(Session session, MBeanInfo info) {
        MBeanOperationInfo[] operationInfos = info.getOperations();
        if (operationInfos.length == 0) {
            session.msg("there's no operations");
            return;
        }
        ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>(Arrays.asList(operationInfos));
        Collections.sort(operations, INFO_COMPARATOR);
        session.msg(TEXT_OPERATIONS, TEXT_OPERATIONS);
        int index = 0;
        for (MBeanOperationInfo op : operations) {
            MBeanParameterInfo[] paramInfos = op.getSignature();
            ArrayList<String> paramTypes = new ArrayList<String>(paramInfos.length);
            for (MBeanParameterInfo paramInfo : paramInfos) {
                paramTypes.add(paramInfo.getType() + " " + paramInfo.getName());
            }
            session.msg(String.format("  %%%-3d - %s %s(%s)" + (this.showDescription ? ", %s" : ""), index++, op.getReturnType(), op.getName(), StringUtils.join(paramTypes, (char)','), op.getDescription()), op.getName());
        }
    }

    public void execute(Session session) throws IOException, JMException {
        String beanName = BeanCommand.getBeanName(this.bean, this.domain, session);
        if (beanName == null) {
            throw new IllegalArgumentException("Please specify a bean using either -b option or bean command");
        }
        ObjectName name = new ObjectName(beanName);
        MBeanServerConnection con = session.getServerConnection();
        MBeanInfo info = con.getMBeanInfo(name);
        session.msg("mbean = " + beanName);
        session.msg("class name = " + info.getClassName());
        block5: for (char t : this.type.toCharArray()) {
            switch (t) {
                case 'a': {
                    this.displayAttributes(session, info);
                    continue block5;
                }
                case 'o': {
                    this.displayOperations(session, info);
                    continue block5;
                }
                case 'n': {
                    this.displayNotifications(session, info);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognizable character " + t + " in type option " + this.type);
                }
            }
        }
    }

    @Option(name="b", longName="bean", description="Name of MBean")
    public final void setBean(String bean) {
        this.bean = bean;
    }

    @Option(name="d", longName="domain", description="Domain for bean")
    public final void setDomain(String domain) {
        this.domain = domain;
    }

    @Option(name="e", longName="detail", description="Show description")
    public final void setShowDescription(boolean showDescription) {
        this.showDescription = showDescription;
    }

    @Option(name="t", longName="type", description="Types(a|o|u) to display, for example aon for all attributes, operations and notifications")
    public void setType(String type) {
        Validate.isTrue((boolean)StringUtils.isNotEmpty((String)type), (String)"Type can't be NULL");
        Validate.isTrue((boolean)Pattern.matches("^a?o?n?$", type), (String)"Type must be a?|o?|n?");
        this.type = type;
    }
}

