/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.Session;

@Cli(name="option", description="Set options for command session")
public class OptionCommand
extends Command {
    private String verbose;
    private String abbreviated;

    @Option(name="a", longName="abbreviated", description="yes|no")
    public final void setAbbreviated(String abbreviated) {
        this.abbreviated = abbreviated;
    }

    @Option(name="v", longName="verbose", description="yes|no")
    public final void setVerbose(String verbose) {
        this.verbose = verbose;
    }

    private static Boolean toBoolean(String value) {
        if (value == null) {
            return null;
        }
        if (value.equalsIgnoreCase("yes")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("no")) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Boolean option value has to be yes|no, " + value + " is invalid");
    }

    public void execute(Session session) throws Exception {
        Boolean v = OptionCommand.toBoolean(this.verbose);
        if (v != null) {
            session.setVerbose(v);
            session.msg("verbose option is turned " + (v != false ? "on" : "off"));
        } else {
            session.msg("no change for verbose, verbose = " + (session.isVerbose() ? "yes" : "no"));
        }
        Boolean a = OptionCommand.toBoolean(this.abbreviated);
        if (a != null) {
            session.setAbbreviated(a);
            session.msg("abbreviated option is turned " + (a != false ? "on" : "off"));
        } else {
            session.msg("no change for abbreviated, abbreviated = " + (session.isAbbreviated() ? "yes" : "no"));
        }
        session.ok();
    }
}

