/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Parser;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jcli.annotation.CliParser;
import org.cyclopsgroup.jcli.jccli.JakartaCommonsCliParser;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.impl.CommandFactory;
import org.cyclopsgroup.jmxterm.impl.HelpCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCenter {
    private static final String COMMAND_DELIMITER = "&&";
    private final CliParser cliParser = new JakartaCommonsCliParser((Parser)new GnuParser());
    private final CommandFactory commandFactory;
    private final Lock lock = new ReentrantLock();
    private final Session session;

    public CommandCenter(PrintWriter output) throws IOException {
        Validate.notNull((Object)output, (String)"Output can't be NULL");
        this.session = new Session(output);
        try {
            this.commandFactory = new CommandFactory();
            output.println("Welcome to JMX terminal. Type \"help\" for available commands.");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Command class not found, jar is corrupted probably", e);
        }
    }

    public void close() {
        this.session.close();
    }

    public void connect(String url) throws IOException {
        Validate.notNull((Object)url, (String)"URL can't be NULL");
        this.session.connect(url);
    }

    private void doExecute(String command) throws Exception {
        if (command == null || command.trim().length() == 0) {
            return;
        }
        if ((command = command.trim()).startsWith("#")) {
            return;
        }
        int commandEnds = command.indexOf(35);
        if (commandEnds != -1) {
            command = command.substring(0, commandEnds);
        }
        if (command.indexOf(COMMAND_DELIMITER) != -1) {
            String[] commands;
            for (String c : commands = StringUtils.split((String)command, (String)COMMAND_DELIMITER)) {
                this.execute(c);
            }
            return;
        }
        String[] args = StringUtils.split((String)command, (char)' ');
        String commandName = args[0];
        String[] commandArgs = new String[args.length - 1];
        System.arraycopy(args, 1, commandArgs, 0, args.length - 1);
        this.doExecute(commandName, commandArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute(String commandName, String[] commandArgs) throws Exception {
        Command cmd = this.commandFactory.createCommand(commandName);
        if (cmd instanceof HelpCommand) {
            ((HelpCommand)cmd).setCommandCenter(this);
        }
        this.cliParser.parse(commandArgs, cmd);
        if (cmd.isHelp()) {
            this.cliParser.printUsage(cmd.getClass(), this.session.output);
            return;
        }
        this.lock.lock();
        try {
            cmd.execute(this.session);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void execute(String command) {
        try {
            this.doExecute(command);
        }
        catch (Exception e) {
            if (this.session.isVerbose()) {
                e.printStackTrace(this.session.output);
            }
            this.session.output.println(e.getClass().getSimpleName() + ":" + e.getMessage());
        }
    }

    public Set<String> getCommandNames() {
        return this.commandFactory.commandTypes.keySet();
    }

    public Class<? extends Command> getCommandType(String name) {
        return this.commandFactory.commandTypes.get(name);
    }

    public boolean isClosed() {
        return this.session.isClosed();
    }

    public void prompt() throws IOException {
        if (!this.session.isAbbreviated()) {
            this.session.output.print((this.session.getConnection() == null ? "?" : ">") + "$ ");
            this.session.output.flush();
        }
    }

    public void setAbbreviated(boolean abbreviated) {
        this.session.setAbbreviated(abbreviated);
    }
}

